/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileBlock;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBlockRegistry {
    private static HashMap<Block, TileBlockEntry> registry = new HashMap();

    @SideOnly(value=Side.CLIENT)
    public static void registerGui(Block id, Class<? extends GuiContainer> gui) {
        TileBlockEntry entry = registry.get(id);
        if (entry != null) {
            if (entry.gui != null) {
                FMLLog.warning((String)"CD4017BE-modlib: GuiContainer %1$s overrrides already registered GuiContainer %2$s for Block-ID %3$d !", (Object[])new Object[]{gui.getName(), entry.gui.getName(), id});
            }
            entry.gui = gui;
        } else {
            FMLLog.warning((String)"CD4017BE-modlib: Failed to register GuiContainer %1$s because Block-ID %2$s is not registered!", (Object[])new Object[]{gui.getName(), id});
        }
    }

    public static void register(TileBlock block, Class<? extends ModTileEntity> tileEntity, Class<? extends Container> container) {
        if (container != null && !DataContainer.IGuiData.class.isAssignableFrom(tileEntity)) {
            throw new IllegalArgumentException(String.format("%s doesn't implement %s !", tileEntity.getName(), DataContainer.IGuiData.class.getName()));
        }
        TileBlockEntry entry = new TileBlockEntry(block);
        entry.tileEntity = tileEntity;
        block.tileEntity = tileEntity;
        GameRegistry.registerTileEntity(tileEntity, (String)block.func_149739_a());
        entry.container = container;
        registry.put(block, entry);
    }

    public static TileBlockEntry getBlockEntry(Block b) {
        return registry.get(b);
    }

    public static class TileBlockEntry {
        public final TileBlock block;
        public Class<? extends ModTileEntity> tileEntity;
        public Class<? extends Container> container;
        @SideOnly(value=Side.CLIENT)
        public Class<? extends GuiContainer> gui;

        public TileBlockEntry(TileBlock block) {
            this.block = block;
        }
    }
}

