/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.Gui;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.SlotHolo;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.TooltipInfo;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.util.Utils;
import cd4017be.lib.util.Vec3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.SlotItemHandler;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiMachine
extends GuiContainer {
    public static final ResourceLocation LIB_TEX = new ResourceLocation("cd4017be_lib", "textures/icons.png");
    public ResourceLocation MAIN_TEX;
    public int focus = -1;
    public int tabsX = 0;
    public int tabsY = 7;
    public int bgTexX = 0;
    public int bgTexY = 0;
    public int titleX;
    public int titleY;
    protected byte drawBG = (byte)7;
    public ArrayList<GuiComp<?>> guiComps = new ArrayList();
    private Slot lastClickSlot;

    public GuiMachine(Container container) {
        super(container);
    }

    public void func_73866_w_() {
        this.guiComps.clear();
        super.func_73866_w_();
        this.titleX = this.field_146999_f / 2;
        this.titleY = 4;
        if (this.field_147002_h instanceof TileContainer) {
            TileContainer cont = (TileContainer)this.field_147002_h;
            for (TileContainer.TankSlot slot : cont.tankSlots) {
                this.guiComps.add(new FluidTank(this.guiComps.size(), slot));
            }
            if (cont.data instanceof AutomatedTile) {
                AutomatedTile tile = (AutomatedTile)((Object)cont.data);
                int xPos = this.tabsX;
                if (tile.tanks != null && tile.tanks.tanks.length > 0) {
                    this.guiComps.add(new FluidSideCfg(this.guiComps.size(), xPos -= tile.tanks.tanks.length * 9 + 9, this.tabsY, tile));
                }
                if (tile.inventory != null && tile.inventory.groups.length > 0) {
                    this.guiComps.add(new ItemSideCfg(this.guiComps.size(), xPos -= tile.inventory.groups.length * 9 + 9, this.tabsY, tile));
                }
                if (tile.energy != null) {
                    this.guiComps.add(new EnergySideCfg(this.guiComps.size(), xPos - 18, this.tabsY, tile));
                }
            }
        }
    }

    protected void func_146979_b(int mx, int my) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        for (GuiComp<?> comp : this.guiComps) {
            if (!comp.isInside(mx, my)) continue;
            comp.drawOverlay(mx, my);
        }
        GlStateManager.func_179121_F();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if ((this.drawBG & 1) != 0) {
            this.field_146297_k.field_71446_o.func_110577_a(this.MAIN_TEX);
            this.func_73729_b(this.field_147003_i, this.field_147009_r, this.bgTexX, this.bgTexY, this.field_146999_f, this.field_147000_g);
        }
        if ((this.drawBG & 4) != 0 && this.field_147002_h instanceof TileContainer) {
            TileContainer cont = (TileContainer)this.field_147002_h;
            if (cont.invPlayerS != cont.invPlayerE) {
                Slot pos = (Slot)cont.field_75151_b.get(cont.invPlayerS);
                this.drawStringCentered(I18n.func_74838_a((String)"container.inventory"), this.field_147003_i + pos.field_75223_e + 80, this.field_147009_r + pos.field_75221_f - 14, 0x404040);
            }
        }
        if ((this.drawBG & 2) != 0 && this.field_147002_h instanceof DataContainer) {
            this.drawStringCentered(((DataContainer)this.field_147002_h).data.getName(), this.field_147003_i + this.titleX, this.field_147009_r + this.titleY, 0x404040);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (GuiComp<?> comp : this.guiComps) {
            comp.draw();
        }
    }

    protected void func_73864_a(int x, int y, int b) throws IOException {
        boolean doSuper = true;
        for (GuiComp<?> comp : this.guiComps) {
            if (!comp.isInside(x, y)) continue;
            if (comp.id != this.focus) {
                this.setFocus(comp.id);
            }
            if (doSuper = !comp.mouseIn(x, y, b, 0)) continue;
            break;
        }
        if (this.focus >= 0 && !this.guiComps.get(this.focus).isInside(x, y)) {
            this.setFocus(-1);
        }
        if (doSuper) {
            super.func_73864_a(x, y, b);
        }
    }

    protected void func_146273_a(int x, int y, int b, long t) {
        if (this.focus >= 0) {
            this.guiComps.get(this.focus).mouseIn(x, y, b, 1);
        } else {
            Slot slot = this.getSlotUnderMouse();
            ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            if (slot instanceof SlotHolo && slot != this.lastClickSlot) {
                if (itemstack == null || slot.func_75211_c() == null || itemstack.func_77969_a(slot.func_75211_c())) {
                    this.func_184098_a(slot, slot.field_75222_d, b, ClickType.PICKUP);
                }
            } else {
                super.func_146273_a(x, y, b, t);
            }
            this.lastClickSlot = slot;
        }
    }

    protected void func_146286_b(int x, int y, int b) {
        if (this.focus < 0 || !this.guiComps.get(this.focus).mouseIn(x, y, b, 2)) {
            super.func_146286_b(x, y, b);
        }
        this.lastClickSlot = null;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.focus >= 0) {
            this.guiComps.get(this.focus).keyTyped(typedChar, keyCode);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        int z = Mouse.getEventDWheel();
        if (z != 0) {
            GuiComp<?> comp;
            if (z > 1) {
                z = 1;
            } else if (z < -1) {
                z = -1;
            }
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            Iterator<GuiComp<?>> iterator = this.guiComps.iterator();
            while (!(!iterator.hasNext() || (comp = iterator.next()).isInside(x, y) && comp.mouseIn(x, y, -z, 3))) {
            }
        }
        super.func_146274_d();
    }

    public void drawFormatInfo(int x, int y, String key, Object ... args) {
        this.drawHoveringText(Arrays.asList(TooltipInfo.format("gui.cd4017be." + key, args).split("\n")), x, y, this.field_146289_q);
    }

    public void drawLocString(int x, int y, int h, int c, String s, Object ... args) {
        String[] text;
        for (String l : text = TooltipInfo.format("gui.cd4017be." + s, args).split("\n")) {
            this.field_146289_q.func_78276_b(l, x, y, c);
            y += h;
        }
    }

    public void drawStringCentered(String s, int x, int y, int c) {
        this.field_146289_q.func_78276_b(s, x - this.field_146289_q.func_78256_a(s) / 2, y, c);
    }

    protected void drawSideCube(int x, int y, int s, byte dir) {
        Vec3 a;
        GlStateManager.func_179126_j();
        this.func_73733_a(x, y, x + 64, y + 64, -16777216, -16777216);
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x + 32), (float)(y + 32), (float)32.0f);
        GL11.glScalef((float)16.0f, (float)-16.0f, (float)16.0f);
        EntityPlayer player = ((DataContainer)this.field_147002_h).player;
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(player.field_70177_z + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.5f);
        DataContainer.IGuiData tile = ((DataContainer)this.field_147002_h).data;
        this.field_146297_k.func_175602_ab().func_175016_a(tile.pos().func_177956_o() >= 0 ? player.field_70170_p.func_180495_p(tile.pos()) : Blocks.field_150359_w.func_176223_P(), 1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(LIB_TEX);
        Vec3 p = Vec3.Def(0.5, 0.5, 0.5);
        switch (s) {
            case 0: {
                a = Vec3.Def(0.0, -1.0, 0.0);
                break;
            }
            case 1: {
                a = Vec3.Def(0.0, 1.0, 0.0);
                break;
            }
            case 2: {
                a = Vec3.Def(0.0, 0.0, -1.0);
                break;
            }
            case 3: {
                a = Vec3.Def(0.0, 0.0, 1.0);
                break;
            }
            case 4: {
                a = Vec3.Def(-1.0, 0.0, 0.0);
                break;
            }
            default: {
                a = Vec3.Def(1.0, 0.0, 0.0);
            }
        }
        Vec3d look = player.func_70040_Z();
        Vec3 b = Vec3.Def(look.field_72450_a, look.field_72448_b, look.field_72449_c).mult(a).norm();
        p = p.add(a.scale(0.5)).add(b.scale(-0.5));
        a = a.scale(1.5);
        float tx = (float)(144 + 16 * dir) / 256.0f;
        float dtx = 0.0625f;
        float ty = 0.09375f;
        float dty = 0.03125f;
        VertexBuffer t = Tessellator.func_178181_a().func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        t.func_181662_b(p.x + b.x, p.y + b.y, p.z + b.z).func_187315_a((double)tx, 0.125).func_181675_d();
        t.func_181662_b(p.x + a.x + b.x, p.y + a.y + b.y, p.z + a.z + b.z).func_187315_a((double)(tx + 0.0625f), 0.125).func_181675_d();
        t.func_181662_b(p.x + a.x, p.y + a.y, p.z + a.z).func_187315_a((double)(tx + 0.0625f), 0.09375).func_181675_d();
        t.func_181662_b(p.x, p.y, p.z).func_187315_a((double)tx, 0.09375).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
    }

    public void func_146982_a(ItemStack stack, int x, int y, String altText) {
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    public void sendChat(String msg) {
        this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(msg));
    }

    public static void color(int c) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)((float)(c >> 16 & 0xFF) / 255.0f), (float)((float)(c >> 8 & 0xFF) / 255.0f), (float)((float)(c & 0xFF) / 255.0f), (float)((float)(c >> 24 & 0xFF) / 255.0f));
    }

    public void setFocus(int id) {
        if (this.focus >= 0 && this.focus < this.guiComps.size()) {
            this.guiComps.get(this.focus).unfocus();
        }
        this.focus = id >= 0 && id < this.guiComps.size() && this.guiComps.get(id).focus() ? id : -1;
    }

    protected Object getDisplVar(int id) {
        return null;
    }

    protected void setDisplVar(int id, Object obj, boolean send) {
    }

    public class FluidTank
    extends GuiComp<Object> {
        final TileContainer.TankSlot slot;

        public FluidTank(int id, TileContainer.TankSlot slot) {
            super(id, slot.xDisplayPosition, slot.yDisplayPosition, (slot.size >> 4 & 0xF) * 18 - 2, (slot.size & 0xF) * 18 - 2, null, null, null);
            this.slot = slot;
        }

        @Override
        public void drawOverlay(int mx, int my) {
            FluidStack stack = this.slot.getStack();
            ArrayList<String> info = new ArrayList<String>();
            info.add(stack != null ? stack.getLocalizedName() : "Empty");
            info.add(String.format("%s/%s ", Utils.formatNumber(stack != null ? (double)((float)stack.amount / 1000.0f) : 0.0, 3), Utils.formatNumber((float)this.slot.inventory.getCapacity(this.slot.tankNumber) / 1000.0f, 3)) + TooltipInfo.getFluidUnit());
            GuiMachine.this.drawHoveringText(info, mx, my, GuiMachine.this.field_146289_q);
        }

        @Override
        public void draw() {
            ResourceLocation res;
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            FluidStack stack = this.slot.getStack();
            if (stack != null && (res = stack.getFluid().getStill()) != null) {
                GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                int c = this.slot.inventory.getCapacity(this.slot.tankNumber);
                int n = c == 0 || stack.amount >= c ? this.h : (int)((long)this.h * (long)stack.amount / (long)c);
                GuiMachine.this.func_175175_a(this.px, this.py + this.h - n, GuiMachine.this.field_146297_k.func_147117_R().func_110572_b(res.toString()), this.w, n);
            }
            GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(LIB_TEX);
            GuiMachine.this.func_73729_b(this.px + this.w - 16, this.py, 110, 52 - this.h, 16, this.h);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        }

        @Override
        public boolean mouseIn(int x, int y, int b, int d) {
            if (d == 0 && GuiMachine.this.field_147002_h instanceof DataContainer) {
                FluidStack fluid = FluidUtil.getFluidContained((ItemStack)((DataContainer)GuiMachine.this.field_147002_h).player.field_71071_by.func_70445_o());
                GuiMachine.this.setDisplVar(this.id, fluid != null ? fluid.getFluid() : null, false);
            }
            return false;
        }
    }

    public class ItemSideCfg
    extends GuiComp<Object> {
        final AutomatedTile tile;

        public ItemSideCfg(int id, int px, int py, AutomatedTile tile) {
            super(id, px, py, 9 * tile.inventory.groups.length + 9, 63, null, null, null);
            this.tile = tile;
        }

        @Override
        public void drawOverlay(int mx, int my) {
            int s = (my - this.py) / 9 - 1;
            int i = (mx - this.px) / 9 - 1;
            byte dir = this.tile.inventory.getConfig(s, i);
            if (i >= 0) {
                GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(LIB_TEX);
                int i0 = this.tile.inventory.groups[i].s;
                int i1 = this.tile.inventory.groups[i].e;
                for (Slot slot : GuiMachine.this.field_147002_h.field_75151_b) {
                    if (!(slot instanceof SlotItemHandler) || slot.getSlotIndex() < i0 || slot.getSlotIndex() >= i1) continue;
                    GuiMachine.this.func_73729_b(GuiMachine.this.field_147003_i + slot.field_75223_e, GuiMachine.this.field_147009_r + slot.field_75221_f, 144 + dir * 16, 0, 16, 16);
                }
            }
            if (s >= 0) {
                GuiMachine.this.drawSideCube(GuiMachine.this.field_147003_i + GuiMachine.this.tabsX - 64, this.py + 63, s, dir);
            }
        }

        @Override
        public void draw() {
            int s = this.tile.inventory.groups.length;
            GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(LIB_TEX);
            GuiMachine.this.func_73729_b(this.px, this.py, 0, 0, 9 + s * 9, 63);
            GuiMachine.this.func_73729_b(this.px, this.py, 0, 90, 9, 9);
            for (int j = 0; j < s; ++j) {
                GuiMachine.this.func_73729_b(this.px + 9 + j * 9, this.py, 18 + this.tile.inventory.groups[j].dir * 9, 90, 9, 9);
                for (int i = 0; i < 6; ++i) {
                    GuiMachine.this.func_73729_b(this.px + 9 + j * 9, this.py + 9 + i * 9, 9 + (int)(this.tile.inventory.sideCfg >> 10 * i + 2 * j & 3L) * 9, 81, 9, 9);
                }
            }
        }

        @Override
        public boolean mouseIn(int x, int y, int b, int d) {
            boolean dir = b == 0 || d == 3 && b > 0;
            x = (x - this.px) / 9 - 1;
            y = (y - this.py) / 9 - 1;
            if (x >= 0 && y >= 0) {
                int p = y * 10 + x * 2;
                long sp = 3L << p;
                PacketBuffer dos = this.tile.getPacketTargetData();
                dos.writeByte(0);
                this.tile.inventory.sideCfg = this.tile.inventory.sideCfg & (sp ^ 0xFFFFFFFFFFFFFFFFL) | this.tile.inventory.sideCfg + (dir ? 1L << p : sp) & sp;
                dos.writeLong(this.tile.inventory.sideCfg);
                BlockGuiHandler.sendPacketToServer(dos);
            }
            return true;
        }
    }

    public class FluidSideCfg
    extends GuiComp<Object> {
        final AutomatedTile tile;

        public FluidSideCfg(int id, int px, int py, AutomatedTile tile) {
            super(id, px, py, 9 * tile.tanks.tanks.length + 9, 81, null, null, null);
            this.tile = tile;
        }

        @Override
        public void drawOverlay(int mx, int my) {
            byte dir;
            int s = (my - this.py) / 9 - 1;
            int i = (mx - this.px) / 9 - 1;
            byte by = s < 6 ? (byte)this.tile.tanks.getConfig(s, i) : (s != 6 ? (byte)4 : (dir = this.tile.tanks.isLocked(i) ? (byte)5 : 6));
            if (i >= 0) {
                GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(LIB_TEX);
                for (TileContainer.TankSlot slot : ((TileContainer)GuiMachine.this.field_147002_h).tankSlots) {
                    if (slot.tankNumber != i) continue;
                    GuiMachine.this.func_73729_b(GuiMachine.this.field_147003_i + slot.xDisplayPosition + (slot.size >> 4 & 0xF) * 9 - 9, GuiMachine.this.field_147009_r + slot.yDisplayPosition + (slot.size & 0xF) * 18 - (s < 6 ? 10 : 18), 144 + dir * 16, 16, 16, s < 6 ? 8 : 16);
                }
            }
            if (s >= 0 && s < 6) {
                GuiMachine.this.drawSideCube(GuiMachine.this.field_147003_i + GuiMachine.this.tabsX - 64, this.py + 63, s, dir);
            }
        }

        @Override
        public void draw() {
            int s = this.tile.tanks.tanks.length;
            GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(LIB_TEX);
            GuiMachine.this.func_73729_b(this.px, this.py, 0, 0, 9 + s * 9, 81);
            GuiMachine.this.func_73729_b(this.px, this.py, 0, 81, 9, 9);
            for (int j = 0; j < s; ++j) {
                GuiMachine.this.func_73729_b(this.px + 9 + j * 9, this.py, 18 + this.tile.tanks.tanks[j].dir * 9, 90, 9, 9);
                for (int i = 0; i < 6; ++i) {
                    GuiMachine.this.func_73729_b(this.px + 9 + j * 9, this.py + 9 + i * 9, 9 + (int)(this.tile.tanks.sideCfg >> 8 * i + 2 * j & 3L) * 9, 81, 9, 9);
                }
                if ((this.tile.tanks.sideCfg >> 48 + j & 1L) == 0L) continue;
                GuiMachine.this.func_73729_b(this.px + 9 + j * 9, this.py + 63, 9, 81, 9, 9);
            }
        }

        @Override
        public boolean mouseIn(int x, int y, int b, int d) {
            boolean dir = b == 0 || d == 3 && b > 0;
            x = (x - this.px) / 9 - 1;
            y = (y - this.py) / 9 - 1;
            if (x >= 0 && y >= 0) {
                PacketBuffer dos = this.tile.getPacketTargetData();
                if (y == 7) {
                    dos.writeByte(2).writeByte(x);
                } else if (y == 6) {
                    dos.writeByte(1).writeLong(this.tile.tanks.sideCfg ^= 1L << 48 + x);
                } else {
                    int p = y * 8 + x * 2;
                    long sp = 3L << p;
                    this.tile.tanks.sideCfg = this.tile.tanks.sideCfg & (sp ^ 0xFFFFFFFFFFFFFFFFL) | this.tile.tanks.sideCfg + (dir ? 1L << p : sp) & sp;
                    dos.writeByte(1).writeLong(this.tile.tanks.sideCfg);
                }
                BlockGuiHandler.sendPacketToServer(dos);
            }
            return true;
        }
    }

    public class EnergySideCfg
    extends GuiComp<Object> {
        final AutomatedTile tile;

        public EnergySideCfg(int id, int px, int py, AutomatedTile tile) {
            super(id, px, py, 18, 63, null, null, null);
            this.tile = tile;
        }

        @Override
        public void drawOverlay(int mx, int my) {
            int s = (my - this.py) / 9 - 1;
            if (s >= 0) {
                GuiMachine.this.drawSideCube(GuiMachine.this.field_147003_i + GuiMachine.this.tabsX - 64, this.py + 63, s, (this.tile.energy.sideCfg >> s & 1) != 0 ? (byte)3 : 0);
            }
        }

        @Override
        public void draw() {
            GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(LIB_TEX);
            GuiMachine.this.func_73729_b(this.px, this.py, 0, 0, 18, 63);
            GuiMachine.this.func_73729_b(this.px, this.py, 0, 99, 9, 9);
            GuiMachine.this.func_73729_b(this.px + 9, this.py, 36, 90, 9, 9);
            for (int i = 0; i < 6; ++i) {
                GuiMachine.this.func_73729_b(this.px + 9, this.py + 9 + i * 9, (this.tile.energy.sideCfg >> i & 1) != 0 ? 36 : 9, 81, 9, 9);
            }
        }

        @Override
        public boolean mouseIn(int x, int y, int b, int d) {
            if (x >= this.px + 9 && (y -= this.py + 9) >= 0) {
                PacketBuffer dos = this.tile.getPacketTargetData();
                dos.writeByte(3);
                this.tile.energy.sideCfg = (byte)(this.tile.energy.sideCfg ^ 1 << y / 9);
                dos.writeByte((int)this.tile.energy.sideCfg);
                BlockGuiHandler.sendPacketToServer(dos);
            }
            return true;
        }
    }

    public class ProgressBar
    extends GuiComp<Float> {
        public final byte type;
        public final int tx;
        public final int ty;

        public ProgressBar(int id, int px, int py, int w, int h, int tx, int ty, byte type) {
            super(id, px, py, w, h);
            this.type = type;
            this.tx = tx;
            this.ty = ty;
        }

        public ProgressBar(int id, int px, int py, int w, int h, int tx, int ty, byte type, Supplier<Float> get) {
            super(id, px, py, w, h, get, null, null);
            this.type = type;
            this.tx = tx;
            this.ty = ty;
        }

        @Override
        public void draw() {
            boolean v;
            float f = ((Float)this.get.get()).floatValue();
            if (Float.isNaN(f)) {
                return;
            }
            if (this.type < 2 || this.type == 4) {
                if (f > 1.0f) {
                    f = 1.0f;
                } else if (f < -1.0f) {
                    f = -1.0f;
                }
            }
            GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(GuiMachine.this.MAIN_TEX);
            boolean bl = v = (this.type & 1) != 0;
            if (this.type == 0 || this.type == 1) {
                int n = (int)((float)(v ? this.h : this.w) * (f < 0.0f ? -f : f));
                int dx = !v && f < 0.0f ? this.w - n : 0;
                int dy = v && f > 0.0f ? this.h - n : 0;
                GuiMachine.this.func_73729_b(this.px + dx, this.py + dy, this.tx + dx, this.ty + dy, v ? this.w : n, v ? n : this.h);
            } else if (this.type == 2 || this.type == 3) {
                int n = (int)((float)(v ? this.h : this.w) * f);
                GuiMachine.this.func_73729_b(this.px, this.py, this.tx + (v ? 0 : n), this.ty + (v ? n : 0), this.w, this.h);
            } else if (this.type == 4) {
                int n = (int)((float)(this.w * this.h) * (f < 0.0f ? -f : f));
                int m = n / this.h;
                int dx = f < 0.0f ? this.w - m : 0;
                int dx1 = f < 0.0f ? this.w - m - 1 : m;
                int dy1 = f < 0.0f ? this.h - (n %= this.h) : 0;
                GuiMachine.this.func_73729_b(this.px + dx, this.py, this.tx + dx, this.ty, m, this.h);
                GuiMachine.this.func_73729_b(this.px + dx1, this.py + dy1, this.tx + dx1, this.ty + dy1, 1, n);
            }
        }
    }

    public class Button
    extends GuiComp<Object> {
        public final int states;
        public int tx;
        public int ty;

        public Button(int id, int px, int py, int w, int h, int states) {
            super(id, px, py, w, h);
            this.states = states;
        }

        public Button(int id, int px, int py, int w, int h, int states, Supplier<Object> get, Consumer<Object> update) {
            super(id, px, py, w, h, get, null, update);
            this.states = states;
        }

        public Button(int id, int px, int py, int w, int h, Consumer<Object> update) {
            super(id, px, py, w, h, null, null, update);
            this.states = -1;
        }

        public Button texture(int tx, int ty) {
            this.tx = tx;
            this.ty = ty;
            return this;
        }

        @Override
        public void drawOverlay(int mx, int my) {
            Object o;
            super.drawOverlay(mx, my);
            if (this.states >= 0 && (o = this.get.get()) instanceof EnumFacing) {
                GuiMachine.this.drawSideCube(GuiMachine.this.tabsX + GuiMachine.this.field_147003_i - 64, GuiMachine.this.tabsY + GuiMachine.this.field_147009_r + 63, ((EnumFacing)o).ordinal(), (byte)this.states);
            }
        }

        @Override
        public void draw() {
            if (this.states < 0) {
                return;
            }
            Object o = this.get.get();
            int s = o instanceof EnumFacing ? ((EnumFacing)o).ordinal() : ((Integer)o).intValue();
            GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(GuiMachine.this.MAIN_TEX);
            GuiMachine.this.func_73729_b(this.px, this.py, this.tx, this.ty + s * this.h, this.w, this.h);
        }

        @Override
        public boolean mouseIn(int x, int y, int b, int d) {
            if (d == 3) {
                return true;
            }
            this.update.accept(b);
            return b == 0;
        }
    }

    public class NumberSel
    extends GuiComp<Integer> {
        public boolean hor;
        public boolean above;
        public int ts;
        public int tc;
        public int nb;
        public int min;
        public int max;
        public int exp;
        public final String form;

        public NumberSel(int id, int px, int py, int w, int h, String form, int min, int max, int exp) {
            super(id, px, py, w, h);
            this.hor = false;
            this.above = false;
            this.ts = 4;
            this.tc = -12566464;
            this.nb = 1;
            this.min = min;
            this.max = max;
            this.exp = exp;
            this.form = form;
        }

        public NumberSel(int id, int px, int py, int w, int h, String form, int min, int max, int exp, Supplier<Integer> get, Consumer<Integer> update) {
            super(id, px, py, w, h, get, null, update);
            this.hor = false;
            this.above = false;
            this.ts = 4;
            this.tc = -12566464;
            this.nb = 1;
            this.min = min;
            this.max = max;
            this.exp = exp;
            this.form = form;
        }

        public NumberSel setup(int ts, int tc, int nb, boolean hor) {
            this.nb = nb;
            this.tc = tc;
            this.ts = ts / 2;
            this.hor = hor;
            return this;
        }

        public NumberSel around() {
            this.above = true;
            return this;
        }

        @Override
        public void draw() {
            String s = String.format(this.form, this.get.get());
            int x = this.px + (this.w - GuiMachine.this.field_146289_q.func_78256_a(s)) / 2;
            int y = this.py + (this.h - 8) / 2;
            GuiMachine.this.field_146289_q.func_78276_b(s, x, y, this.tc);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public boolean mouseIn(int x, int y, int b, int d) {
            int ofs;
            if (d == 3) {
                ofs = b;
            } else if (d == 0) {
                if (this.above) {
                    int p = (this.px + this.w - 1 - x) * this.nb / this.w + b;
                    if ((y -= this.py + this.h / 2) < -this.ts) {
                        ofs = 1;
                        for (int i = 0; i < p; ++i) {
                            ofs *= this.exp;
                        }
                    } else if (y >= this.ts) {
                        ofs = -1;
                        for (int i = 0; i < p; ++i) {
                            ofs *= this.exp;
                        }
                    } else {
                        ofs = 0;
                    }
                } else {
                    int pw;
                    int p = (this.hor ? x - this.px : this.py + this.h - 1 - y) - (pw = (this.hor ? this.w : this.h) / 2);
                    if (p < -this.ts) {
                        p = (-p - this.ts) * this.nb / (pw - this.ts) * 2 + b;
                        ofs = -1;
                        for (int i = 0; i < p; ++i) {
                            ofs *= this.exp;
                        }
                    } else if (p >= this.ts) {
                        p = (p - this.ts) * this.nb / (pw - this.ts) * 2 + b;
                        ofs = 1;
                        for (int i = 0; i < p; ++i) {
                            ofs *= this.exp;
                        }
                    } else {
                        ofs = 0;
                    }
                }
            } else {
                return true;
            }
            if (ofs != 0) {
                this.update.accept(Math.max(this.min, Math.min(this.max, (Integer)this.get.get() + ofs)));
            }
            return true;
        }
    }

    public class Slider
    extends GuiComp<Float> {
        public final int l;
        public final int tx;
        public final int ty;
        public final int tw;
        public final int th;
        public final boolean hor;
        public float scrollStep;

        public Slider(int id, int x, int y, int l, int texX, int texY, int texW, int texH, boolean hor) {
            super(id, x, y, hor ? l : texW, hor ? texH : l);
            this.scrollStep = 0.125f;
            this.hor = hor;
            this.l = l;
            this.tx = texX;
            this.ty = texY;
            this.tw = texW;
            this.th = texH;
        }

        public Slider(int id, int x, int y, int l, int texX, int texY, int texW, int texH, boolean hor, Supplier<Float> get, Consumer<Float> set, Consumer<Float> update) {
            super(id, x, y, hor ? l : texW, hor ? texH : l, get, set, update);
            this.scrollStep = 0.125f;
            this.hor = hor;
            this.l = l;
            this.tx = texX;
            this.ty = texY;
            this.tw = texW;
            this.th = texH;
        }

        public Slider scroll(float step) {
            this.scrollStep = step;
            return this;
        }

        @Override
        public void draw() {
            GuiMachine.this.field_146297_k.field_71446_o.func_110577_a(GuiMachine.this.MAIN_TEX);
            int f = (int)(((Float)this.get.get()).floatValue() * (float)this.l) - (this.hor ? this.tw : this.th) / 2;
            GuiMachine.this.func_73729_b(this.hor ? this.px + f : this.px, this.hor ? this.py : this.py + f, this.tx, this.ty, this.tw, this.th);
        }

        @Override
        public boolean mouseIn(int x, int y, int b, int d) {
            float f;
            float f2 = d == 3 ? ((Float)this.get.get()).floatValue() + (float)b * this.scrollStep + 1.0E-5f : (f = ((float)(this.hor ? x - this.px : y - this.py) + 0.5f) / (float)this.l);
            if (f < 0.0f) {
                f = 0.0f;
            } else if (f > 1.0f) {
                f = 1.0f;
            }
            (d == 3 ? this.update : this.set).accept(Float.valueOf(f));
            if (d == 2) {
                GuiMachine.this.setFocus(-1);
            }
            return true;
        }

        @Override
        public void unfocus() {
            if (this.update != null) {
                this.update.accept(this.get.get());
            }
        }

        @Override
        public boolean focus() {
            return true;
        }
    }

    public class TextField
    extends GuiComp<String> {
        public final int maxL;
        public int tc;
        public int cc;
        public String text;
        public int cur;

        public TextField(int id, int x, int y, int w, int h, int max) {
            super(id, x, y, w, h);
            this.tc = -12566464;
            this.cc = -8388608;
            this.text = "";
            this.maxL = max;
        }

        public TextField(int id, int x, int y, int w, int h, int max, Supplier<String> get, Consumer<String> update) {
            super(id, x, y, w, h, get, null, update);
            this.tc = -12566464;
            this.cc = -8388608;
            this.text = "";
            this.maxL = max;
        }

        public TextField color(int text, int cursor) {
            this.tc = text;
            this.cc = cursor;
            return this;
        }

        @Override
        public void draw() {
            if (GuiMachine.this.focus == this.id) {
                if (this.cur > this.text.length()) {
                    this.cur = this.text.length();
                }
                GuiMachine.this.func_73728_b(this.px - 1 + GuiMachine.this.field_146289_q.func_78256_a(this.text.substring(0, this.cur)), this.py + (this.h - 9) / 2, this.py + (this.h + 7) / 2, this.cc);
            } else {
                this.text = (String)this.get.get();
            }
            GuiMachine.this.field_146289_q.func_78276_b(this.text, this.px, this.py + (this.h - 8) / 2, this.tc);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void keyTyped(char c, int k) {
            block24: {
                try {
                    boolean ctr = GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
                    switch (k) {
                        case 203: {
                            if (this.cur > 0) {
                                --this.cur;
                            }
                            break;
                        }
                        case 205: {
                            if (this.cur < this.text.length()) {
                                ++this.cur;
                            }
                            break;
                        }
                        case 211: {
                            if (this.cur < this.text.length()) {
                                this.text = this.text.substring(0, this.cur).concat(this.text.substring(this.cur + 1));
                            }
                            break;
                        }
                        case 14: {
                            if (this.cur > 0) {
                                --this.cur;
                                this.text = this.text.substring(0, this.cur).concat(this.text.substring(this.cur + 1));
                            }
                            break;
                        }
                        case 28: {
                            GuiMachine.this.setFocus(-1);
                            break;
                        }
                        case 200: {
                            GuiMachine.this.setFocus(this.id - 1);
                            break;
                        }
                        case 208: {
                            GuiMachine.this.setFocus(this.id + 1);
                            break;
                        }
                        case 46: {
                            if (ctr) {
                                GuiScreen.func_146275_d((String)this.text);
                                break;
                            }
                        }
                        case 47: {
                            if (ctr) {
                                String s = GuiScreen.func_146277_j();
                                this.text = this.text.substring(0, this.cur).concat(s).concat(this.text.substring(this.cur, this.text.length()));
                                this.cur += s.length();
                                if (this.text.length() > this.maxL) {
                                    this.text = this.text.substring(0, this.maxL);
                                    this.cur = this.maxL;
                                }
                                break;
                            }
                        }
                        case 32: {
                            if (ctr) {
                                this.text = "";
                                break;
                            }
                        }
                        default: {
                            if (ChatAllowedCharacters.func_71566_a((char)c) && this.cur < this.maxL) {
                                this.text = this.text.substring(0, this.cur).concat("" + c).concat(this.text.substring(this.cur, Math.min(this.text.length(), this.maxL - 1)));
                                ++this.cur;
                            }
                            break;
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    if (this.cur < 0) {
                        this.cur = 0;
                    }
                    if (this.cur <= this.text.length()) break block24;
                    this.cur = this.text.length();
                }
            }
        }

        @Override
        public void unfocus() {
            this.update.accept(this.text);
        }

        @Override
        public boolean focus() {
            this.text = (String)this.get.get();
            this.cur = this.text.length();
            return true;
        }
    }

    public class Text<V>
    extends GuiComp<V> {
        public String text;
        public int fh;
        public int tc;
        public boolean center;

        public Text(int id, int x, int y, int w, int h, String key) {
            super(id, x, y, w, h);
            this.fh = 8;
            this.tc = -12566464;
            this.center = false;
            this.text = key;
        }

        public Text(int id, int x, int y, int w, int h, String key, Supplier<V> get) {
            super(id, x, y, w, h, get, null, null);
            this.fh = 8;
            this.tc = -12566464;
            this.center = false;
            this.text = key;
        }

        public Text<V> font(int tc, int fh) {
            this.tc = tc;
            this.fh = fh;
            return this;
        }

        public Text<V> center() {
            this.center = true;
            return this;
        }

        @Override
        public void draw() {
            Object[] objectArray;
            Object obj = this.get.get();
            if (obj instanceof Object[]) {
                objectArray = (Object[])obj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = obj;
            }
            Object[] objA = objectArray;
            String[] lines = (this.text.startsWith("\\") ? String.format(this.text.substring(1), objA) : TooltipInfo.format("gui.cd4017be." + (this.text.endsWith("#") ? this.text.replaceAll("#", ((Integer)obj).toString()) : this.text), objA)).split("\n");
            int y = this.py;
            for (String l : lines) {
                int x = this.center ? this.px + (this.w - GuiMachine.this.field_146289_q.func_78256_a(l)) / 2 : this.px;
                GuiMachine.this.field_146289_q.func_78276_b(l, x, y, this.tc);
                y += this.fh;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public class Tooltip<V>
    extends GuiComp<V> {
        public Tooltip(int id, int px, int py, int w, int h, String tooltip) {
            super(id, px, py, w, h);
            this.setTooltip(tooltip);
        }

        public Tooltip(int id, int px, int py, int w, int h, String tooltip, Supplier<V> get) {
            super(id, px, py, w, h, get, null, null);
            this.setTooltip(tooltip);
        }

        @Override
        public void drawOverlay(int mx, int my) {
            Object[] objectArray;
            Object obj = this.get.get();
            if (obj instanceof Object[]) {
                objectArray = (Object[])obj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = obj;
            }
            Object[] objA = objectArray;
            String s = this.tooltip.startsWith("\\") ? String.format(this.tooltip.substring(1), objA) : TooltipInfo.format("gui.cd4017be." + this.tooltip, objA);
            GuiMachine.this.drawHoveringText(Arrays.asList(s.split("\n")), mx, my, GuiMachine.this.field_146289_q);
        }
    }

    public class GuiComp<V> {
        protected final Supplier<V> get;
        protected final Consumer<V> set;
        protected final Consumer<V> update;
        public final int id;
        public final int px;
        public final int py;
        public final int w;
        public final int h;
        public String tooltip;

        public GuiComp(int id, int px, int py, int w, int h) {
            this.id = id;
            this.px = px + GuiMachine.this.field_147003_i;
            this.py = py + GuiMachine.this.field_147009_r;
            this.w = w;
            this.h = h;
            this.get = () -> GuiMachine.this.getDisplVar(this.id);
            this.set = v -> GuiMachine.this.setDisplVar(this.id, v, false);
            this.update = v -> GuiMachine.this.setDisplVar(this.id, v, true);
        }

        public GuiComp(int id, int px, int py, int w, int h, Supplier<V> get, Consumer<V> set, Consumer<V> update) {
            this.id = id;
            this.px = px + GuiMachine.this.field_147003_i;
            this.py = py + GuiMachine.this.field_147009_r;
            this.w = w;
            this.h = h;
            this.get = get;
            this.set = set;
            this.update = update;
        }

        public GuiComp<V> setTooltip(String s) {
            this.tooltip = s;
            return this;
        }

        public boolean isInside(int x, int y) {
            return x >= this.px && x < this.px + this.w && y >= this.py && y < this.py + this.h;
        }

        public void drawOverlay(int mx, int my) {
            String text;
            if (this.tooltip == null) {
                return;
            }
            if (this.tooltip.startsWith("x*")) {
                int p = this.tooltip.indexOf(43, 2);
                int q = this.tooltip.indexOf(59, p);
                float f = ((Float)this.get.get()).floatValue() * Float.parseFloat(this.tooltip.substring(2, p)) + Float.parseFloat(this.tooltip.substring(p + 1, q));
                text = TooltipInfo.format("gui.cd4017be." + this.tooltip.substring(q + 1), Float.valueOf(f));
            } else {
                text = this.tooltip.endsWith("#") ? this.tooltip.replace("#", this.get.get().toString()) : this.tooltip;
                text = TooltipInfo.getLocFormat("gui.cd4017be." + text);
            }
            GuiMachine.this.drawHoveringText(Arrays.asList(text.split("\n")), mx, this.py + this.h + 12, GuiMachine.this.field_146289_q);
        }

        public void draw() {
        }

        public void keyTyped(char c, int k) {
        }

        public boolean mouseIn(int x, int y, int b, int d) {
            return false;
        }

        public void unfocus() {
        }

        public boolean focus() {
            return false;
        }
    }
}

