/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.IGuiItem;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileBlockRegistry;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class BlockGuiHandler
implements IGuiHandler {
    private static final String guiChannel = "CD4017BE_gui";
    public static BlockGuiHandler instance = new BlockGuiHandler();
    private static Object modRef;
    public static FMLEventChannel eventChannel;

    public static void registerMod(Object mod) {
        if (modRef == null) {
            modRef = mod;
            NetworkRegistry.INSTANCE.registerGuiHandler(modRef, (IGuiHandler)instance);
        }
    }

    public static void openGui(EntityPlayer player, World world, int x, int y, int z) {
        if (modRef != null) {
            player.openGui(modRef, 0, world, x, y, z);
        } else {
            FMLLog.severe((String)"CD4017BE-lib: BlockGuiHandler failed to open Gui! No Mod registered!", (Object[])new Object[0]);
        }
    }

    public static void openItemGui(EntityPlayer player, World world, int x, int y, int z) {
        if (modRef != null) {
            player.openGui(modRef, 1, world, x, y, z);
        } else {
            FMLLog.severe((String)"CD4017BE-lib: BlockGuiHandler failed to open Gui! No Mod registered!", (Object[])new Object[0]);
        }
    }

    public static void sendPacketToServer(PacketBuffer data) {
        eventChannel.sendToServer(new FMLProxyPacket(data, guiChannel));
    }

    public static void sendPacketToPlayer(EntityPlayerMP player, PacketBuffer data) {
        eventChannel.sendTo(new FMLProxyPacket(data, guiChannel), player);
    }

    public static PacketBuffer getPacketTargetData(BlockPos pos) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.func_179255_a(pos);
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onServerPacketReceived(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        if (!packet.channel().equals(guiChannel)) {
            return;
        }
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container != null && container instanceof DataContainer) {
            PacketBuffer data = new PacketBuffer(packet.payload());
            DataContainer.IGuiData te = ((DataContainer)container).data;
            try {
                if (te.pos().equals((Object)data.func_179259_c())) {
                    ((DataContainer)container).onDataUpdate(data);
                }
            }
            catch (Exception e) {
                String s = " ";
                byte[] d = data.array();
                for (int i = 8; i < data.writerIndex(); ++i) {
                    s = s + Integer.toHexString(d[i] & 0xFF) + " ";
                }
                FMLLog.log((String)"CD4017BE_packet", (Level)Level.ERROR, (Throwable)e, (String)"reading gui update packet: [%s]", (Object[])new Object[]{s});
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPacketReceived(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        if (!packet.channel().equals(guiChannel)) {
            return;
        }
        if (!(event.getHandler() instanceof NetHandlerPlayServer)) {
            FMLLog.log((Level)Level.WARN, (String)"NetHandler not instanceof NetHandlerPlayServer!", (Object[])new Object[0]);
        }
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        try {
            PacketBuffer data = new PacketBuffer(packet.payload());
            BlockPos pos = data.func_179259_c();
            if (pos.func_177956_o() < 0) {
                ItemStack item = player.func_184614_ca();
                if (item != null && item.func_77973_b() instanceof IGuiItem) {
                    ((IGuiItem)item.func_77973_b()).onPlayerCommand(item, (EntityPlayer)player, data);
                }
            } else {
                TileEntity te = player.field_70170_p.func_175625_s(pos);
                if (te != null && te instanceof ModTileEntity) {
                    ((ModTileEntity)te).onPlayerCommand(data, player);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Container c;
        if (ID == 0) {
            BlockPos pos = new BlockPos(x, y, z);
            TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(world.func_180495_p(pos).func_177230_c());
            TileEntity te = world.func_175625_s(pos);
            if (entry == null || entry.container == null || te == null || !entry.tileEntity.isInstance(te)) return null;
            try {
                c = entry.container.getConstructor(DataContainer.IGuiData.class, EntityPlayer.class).newInstance((DataContainer.IGuiData)te, player);
            }
            catch (NoSuchMethodException ex) {
                FMLLog.severe((String)"CD4017BE-lib: TileContainer %1$s is missing the Constructor ( %2$s , %3$s )", (Object[])new Object[]{entry.container.getName(), ModTileEntity.class.getName(), EntityPlayer.class.getName()});
                return null;
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            if (ID != 1) return null;
            ItemStack item = player.func_184614_ca();
            if (item == null || !(item.func_77973_b() instanceof IGuiItem)) return null;
            c = ((IGuiItem)item.func_77973_b()).getContainer(world, player, x, y, z);
        }
        if (!(c instanceof DataContainer)) return c;
        ((DataContainer)c).data.initContainer((DataContainer)c);
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        GuiContainer g;
        if (ID == 0) {
            BlockPos pos = new BlockPos(x, y, z);
            TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(world.func_180495_p(pos).func_177230_c());
            TileEntity te = world.func_175625_s(pos);
            if (entry == null || entry.gui == null || te == null || !entry.tileEntity.isInstance(te)) return null;
            if (player.field_71070_bA != null && player.field_71070_bA instanceof DataContainer && ((DataContainer)player.field_71070_bA).data == te) {
                return Minecraft.func_71410_x().field_71462_r;
            }
            try {
                g = entry.gui.getConstructor(entry.tileEntity, EntityPlayer.class).newInstance(entry.tileEntity.cast(te), player);
            }
            catch (NoSuchMethodException ex) {
                FMLLog.severe((String)"CD4017BE-lib: GuiContainer %1$s is missing the Constructor ( %2$s , %3$s )", (Object[])new Object[]{entry.gui.getName(), entry.tileEntity.getName(), EntityPlayer.class.getName()});
                return null;
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            if (ID != 1) return null;
            ItemStack item = player.func_184614_ca();
            if (item == null || !(item.func_77973_b() instanceof IGuiItem)) return null;
            g = ((IGuiItem)item.func_77973_b()).getGui(world, player, x, y, z);
        }
        if (!(g.field_147002_h instanceof DataContainer)) return g;
        DataContainer c = (DataContainer)g.field_147002_h;
        c.data.initContainer(c);
        c.refInts = c.data.getSyncVariables();
        if (c.refInts == null || !(c.data instanceof ModTileEntity)) return g;
        for (int i = 0; i < c.refInts.length; ++i) {
            c.data.setSyncVariable(i, 0);
        }
        return g;
    }

    static {
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(guiChannel);
        eventChannel.register((Object)instance);
    }
}

