/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.ConfigurationFile;
import cd4017be.lib.script.Context;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.ScriptFiles;
import cd4017be.lib.util.OreDictStack;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class RecipeScriptContext
extends Context {
    private static final Function<Parameters, Object> IT = p -> {
        ItemStack item = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            if (name.indexOf(58) < 0) {
                item = BlockItemRegistry.stack(name, 1);
            } else if (name.startsWith("ore:")) {
                List list = OreDictionary.getOres((String)(name = name.substring(4)));
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("empty OreDictionary type: " + name);
                }
                item = ((ItemStack)list.get(0)).func_77946_l();
            } else {
                item = new ItemStack(Item.func_111206_d((String)name));
            }
            if (item == null || item.func_77973_b() == null) {
                throw new IllegalArgumentException("invalid item name: " + name);
            }
        } else if (o instanceof ItemStack) {
            item = ((ItemStack)o).func_77946_l();
        } else {
            if (o instanceof OreDictStack) {
                ItemStack[] arr = ((OreDictStack)o).getItems();
                return Arrays.copyOf(arr, arr.length, Object[].class);
            }
            throw new IllegalArgumentException("expected String, ItemStack or OreDictStack @ 0");
        }
        switch (p.param.length) {
            case 4: {
                item.func_77982_d(p.get(3, NBTTagCompound.class));
            }
            case 3: {
                item.func_77964_b((int)p.getNumber(2));
            }
            case 2: {
                item.field_77994_a = (int)p.getNumber(1);
            }
        }
        return item;
    };
    private static final Function<Parameters, Object> FL = p -> {
        FluidStack fluid = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            fluid = FluidRegistry.getFluidStack((String)name, (int)0);
            if (fluid == null) {
                throw new IllegalArgumentException("invalid fluid name: " + name);
            }
        } else if (o instanceof FluidStack) {
            fluid = ((FluidStack)o).copy();
        } else {
            throw new IllegalArgumentException("expected String or FluidStack @ 0");
        }
        switch (p.param.length) {
            case 3: {
                fluid.tag = p.get(2, NBTTagCompound.class);
            }
            case 2: {
                fluid.amount = (int)p.getNumber(1);
            }
        }
        return fluid;
    };
    private static final Function<Parameters, Object> ORE = p -> {
        OreDictStack ore = null;
        Object o = p.get(0);
        if (o instanceof String) {
            String name = (String)o;
            ore = new OreDictStack(name, 1);
        } else if (o instanceof OreDictStack) {
            ore = ((OreDictStack)o).copy();
        } else {
            throw new IllegalArgumentException("expected String or OreDictStack @ 0");
        }
        if (p.param.length == 2) {
            ore.stacksize = (int)p.getNumber(1);
        }
        return ore;
    };
    private static final Function<Parameters, Object> HASIT = p -> {
        for (Object o : p.param) {
            String name = (String)o;
            if (!(name.indexOf(58) < 0 ? BlockItemRegistry.stack(name, 1) == null : (name.startsWith("ore:") ? OreDictionary.getOres((String)name.substring(4)).isEmpty() : Item.func_111206_d((String)name) == null))) continue;
            return false;
        }
        return true;
    };
    private static final Function<Parameters, Object> HASFL = p -> {
        for (Object o : p.param) {
            if (FluidRegistry.isFluidRegistered((String)((String)o))) continue;
            return false;
        }
        return true;
    };
    private static final Function<Parameters, Object> ORES = p -> OreDictionary.getOres((String)p.getString(0)).toArray();
    private static final Function<Parameters, Object> HASMOD = p -> Loader.isModLoaded((String)p.getString(0));
    private static final Function<Parameters, Object> ADD = p -> {
        RecipeAPI.IRecipeHandler h = RecipeAPI.Handlers.get(p.getString(0));
        if (h == null) {
            throw new IllegalArgumentException(String.format("recipe Handler \"%s\" does'nt exist!", p.param[0]));
        }
        h.addRecipe((Parameters)p);
        return null;
    };
    private static final Function<Parameters, Object> LISTORE = p -> {
        Pattern filter = Pattern.compile(p.getString(0));
        ArrayList<String> list = new ArrayList<String>();
        for (String name : OreDictionary.getOreNames()) {
            if (!filter.matcher(name).matches()) continue;
            list.add(name);
        }
        return list.toArray();
    };
    public static final List<ScriptFiles.Version> scriptRegistry = new ArrayList<ScriptFiles.Version>();
    public static RecipeScriptContext instance;

    public RecipeScriptContext() {
        this.defFunc.put("it", IT);
        this.defFunc.put("fl", FL);
        this.defFunc.put("ore", ORE);
        this.defFunc.put("hasit", HASIT);
        this.defFunc.put("hasfl", HASFL);
        this.defFunc.put("ores", ORES);
        this.defFunc.put("hasmod", HASMOD);
        this.defFunc.put("add", ADD);
        this.defFunc.put("listore", LISTORE);
    }

    public void setup(FMLPreInitializationEvent event) {
        Script[] scripts;
        File dir = new File(event.getModConfigurationDirectory(), "cd4017be");
        File comp = new File(dir, "compiled.dat");
        HashMap<String, ScriptFiles.Version> versions = new HashMap<String, ScriptFiles.Version>();
        for (ScriptFiles.Version v : scriptRegistry) {
            if (v.fallback == null) continue;
            versions.put(v.name, v);
        }
        boolean reload = true;
        try {
            scripts = ScriptFiles.loadPackage(comp, versions, true);
        }
        catch (IOException e) {
            scripts = null;
            reload = false;
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"loading compiled config scripts failed!", (Object[])new Object[0]);
        }
        for (ScriptFiles.Version v : versions.values()) {
            try {
                ConfigurationFile.copyData(v.fallback, new File(dir, v.name + ".rcp"));
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"copying script preset failed!", (Object[])new Object[0]);
            }
        }
        if (scripts == null && (scripts = ScriptFiles.createCompiledPackage(comp)) == null && reload) {
            try {
                FMLLog.log((Level)Level.INFO, (String)"Falling back to old scripts", (Object[])new Object[0]);
                scripts = ScriptFiles.loadPackage(comp, versions, false);
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"loading compiled config scripts failed!", (Object[])new Object[0]);
            }
        }
        if (scripts != null) {
            for (Script s : scripts) {
                this.add(s);
            }
        }
    }

    public void runAll(String p) {
        for (ScriptFiles.Version v : scriptRegistry) {
            this.run(v.name + "." + p);
        }
    }

    public void run(String name) {
        this.reset();
        try {
            this.invoke(name, new Parameters(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            FMLLog.log((String)"RECIPE_SCRIPT", (Level)Level.INFO, (String)"skipped %s", (Object[])new Object[]{name});
        }
        catch (ScriptException e) {
            FMLLog.log((String)"RECIPE_SCRIPT", (Level)Level.ERROR, (Throwable)e, (String)"script execution failed for %s", (Object[])new Object[]{name});
        }
    }

    static {
        scriptRegistry.add(new ScriptFiles.Version("core"));
    }
}

