/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.AutomationRecipes;
import cd4017be.api.recipes.OreGenHandler;
import cd4017be.lib.Lib;
import cd4017be.lib.NBTRecipe;
import cd4017be.lib.script.Parameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeAPI {
    public static HashMap<String, IRecipeHandler> Handlers = new HashMap();

    public static void createOreDictEntries(Class<?> c, String name) {
        block3: {
            block2: {
                if (!Block.class.isAssignableFrom(c)) break block2;
                for (Block block : Block.field_149771_c) {
                    Item item;
                    if (!c.isInstance(block) || (item = Item.func_150898_a((Block)block)) == null) continue;
                    OreDictionary.registerOre((String)name, (Item)item);
                }
                break block3;
            }
            if (!Item.class.isAssignableFrom(c)) break block3;
            for (Item item : Item.field_150901_e) {
                if (!c.isInstance(item)) continue;
                OreDictionary.registerOre((String)name, (Item)item);
            }
        }
    }

    static {
        Handlers.put("shaped", p -> {
            int i;
            String[] pattern = p.getString(2).split("/");
            int n = p.param.length - 3;
            Object[] arr = new Object[n * 2 + pattern.length];
            for (i = 0; i < pattern.length; ++i) {
                arr[i] = pattern[i];
            }
            for (i = 0; i < n; ++i) {
                arr[pattern.length + i * 2] = Character.valueOf(Character.forDigit(i, 9));
                arr[pattern.length + i * 2 + 1] = p.param[i + 3];
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(p.get(1, ItemStack.class), arr));
        });
        Handlers.put("shapedNBT", p -> {
            int i;
            String[] pattern = p.getString(3).split("/");
            int n = p.param.length - 4;
            Object[] arr = new Object[n * 2 + pattern.length];
            for (i = 0; i < pattern.length; ++i) {
                arr[i] = pattern[i];
            }
            for (i = 0; i < n; ++i) {
                arr[pattern.length + i * 2] = Character.valueOf(Character.forDigit(i, 9));
                arr[pattern.length + i * 2 + 1] = p.param[i + 4];
            }
            GameRegistry.addRecipe((IRecipe)new NBTRecipe(p.get(2, ItemStack.class), p.getString(1), arr));
        });
        Handlers.put("ore", p -> {
            String name = p.getString(1);
            for (int i = 2; i < p.param.length; ++i) {
                OreDictionary.registerOre((String)name, (ItemStack)p.get(i, ItemStack.class));
            }
        });
        Handlers.put("shapeless", p -> GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(p.get(1, ItemStack.class), Arrays.copyOfRange(p.param, 2, p.param.length))));
        Handlers.put("smelt", p -> GameRegistry.addSmelting((ItemStack)p.get(1, ItemStack.class), (ItemStack)p.get(2, ItemStack.class), (float)(p.param.length > 3 ? (float)p.getNumber(3) : 0.0f)));
        Handlers.put("fuel", new FuelHandler());
        Handlers.put("worldgen", new OreGenHandler());
        Handlers.put("item", p -> Lib.materials.addMaterial((int)p.getNumber(1), p.getString(2)));
        Handlers.put("fluidCont", p -> FluidContainerRegistry.registerFluidContainer((FluidStack)p.get(1, FluidStack.class), (ItemStack)p.get(2, ItemStack.class), (ItemStack)p.get(3, ItemStack.class)));
        if (Loader.isModLoaded((String)"Automation")) {
            Handlers.put("advFurn", p -> {
                FluidStack Fin = null;
                FluidStack Fout = null;
                ArrayList<Object> Iin = new ArrayList<Object>();
                ArrayList<ItemStack> Iout = new ArrayList<ItemStack>();
                for (Object o : p.getArray(1)) {
                    if (o instanceof FluidStack) {
                        Fin = (FluidStack)o;
                        continue;
                    }
                    Iin.add(o);
                }
                for (Object o : p.getArray(2)) {
                    if (o instanceof FluidStack) {
                        Fout = (FluidStack)o;
                        continue;
                    }
                    if (o instanceof ItemStack) {
                        Iout.add((ItemStack)o);
                        continue;
                    }
                    throw new IllegalArgumentException("expected ItemStack or FluidStack as element of array @ 2");
                }
                AutomationRecipes.addRecipe(new AutomationRecipes.LFRecipe(Fin, Iin.isEmpty() ? null : Iin.toArray(new Object[Iin.size()]), Fout, Iout.isEmpty() ? null : Iout.toArray(new ItemStack[Iout.size()]), (float)p.getNumber(3)));
            });
            Handlers.put("compAs", p -> AutomationRecipes.addCmpRecipe(p.get(1, ItemStack.class), Arrays.copyOfRange(p.param, 2, p.param.length)));
            Handlers.put("electr", p -> AutomationRecipes.addRecipe(new AutomationRecipes.ElRecipe(p.get(1), p.get(2), p.get(3), (float)p.getNumber(4))));
            Handlers.put("cool", p -> AutomationRecipes.addRecipe(new AutomationRecipes.CoolRecipe(p.get(1), p.get(2), p.get(3), p.get(4), (float)p.getNumber(5))));
            Handlers.put("trash", p -> AutomationRecipes.addRecipe(new AutomationRecipes.GCRecipe(p.get(1, ItemStack.class), p.get(2, ItemStack.class), (int)p.getNumber(3))));
            Handlers.put("heatRad", p -> AutomationRecipes.addRadiatorRecipe(p.get(1, FluidStack.class), p.get(2, FluidStack.class)));
            Handlers.put("algae", p -> AutomationRecipes.bioList.add(new AutomationRecipes.BioEntry(p.get(1), (int)p.getNumber(2), (int)p.getNumber(3))));
        }
    }

    private static class FuelHandler
    implements IRecipeHandler,
    IFuelHandler {
        HashMap<Integer, Integer> fuelList = new HashMap();

        public FuelHandler() {
            GameRegistry.registerFuelHandler((IFuelHandler)this);
        }

        int key(ItemStack item) {
            return Item.func_150891_b((Item)item.func_77973_b()) & 0xFFFF | (item.func_77952_i() & 0xFFFF) << 16;
        }

        @Override
        public void addRecipe(Parameters p) {
            this.fuelList.put(this.key(p.get(1, ItemStack.class)), (int)p.getNumber(2));
        }

        public int getBurnTime(ItemStack fuel) {
            Integer val = this.fuelList.get(this.key(fuel));
            return val == null ? 0 : val;
        }
    }

    public static interface IRecipeHandler {
        public void addRecipe(Parameters var1);
    }
}

