/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.lib.script.Parameters;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class OreGenHandler
implements RecipeAPI.IRecipeHandler,
IWorldGenerator {
    ArrayList<OreGen> generators = new ArrayList();

    public OreGenHandler() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (OreGen gen : this.generators) {
            gen.func_180709_b(world, random, new BlockPos(chunkX << 4, 0, chunkZ << 4));
        }
    }

    @Override
    public void addRecipe(Parameters p) {
        ItemStack is = p.get(2, ItemStack.class);
        Item i = is.func_77973_b();
        if (!(i instanceof ItemBlock)) {
            throw new IllegalArgumentException("supplied item has no registered block equivalent");
        }
        double[] vec = p.getVector(4);
        if (vec.length != 3) {
            throw new IllegalArgumentException("height parameter must have 3 elements");
        }
        IBlockState out = ((ItemBlock)i).field_150939_a.func_176203_a(i.func_77647_b(is.func_77960_j()));
        Block in = Block.func_149684_b((String)p.getString(1));
        if (in == null) {
            throw new IllegalArgumentException("block type does not exists");
        }
        this.generators.add(new OreGen(out, is.field_77994_a, (int)p.getNumber(3), (int)vec[0], (int)vec[1], (int)vec[2], (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)in)));
    }

    class OreGen
    extends WorldGenMinable {
        final int numV;
        final int hgt;
        final float min;
        final float max;

        public OreGen(IBlockState state, int numB, int numV, int minH, int mainH, int maxH, Predicate<IBlockState> target) {
            super(state, numB, target);
            this.numV = numV;
            this.min = mainH - minH;
            this.max = maxH - mainH;
            this.hgt = mainH;
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
            boolean side = this.max < this.min;
            for (int i = 0; i < this.numV; ++i) {
                int r = rand.nextInt();
                float f = (float)((r & 0xFFF) + (r >> 12 & 0xFFF) - 4095) / 4095.0f;
                if (side) {
                    if ((f *= this.min) > this.max) {
                        f = this.max - (f - this.max) / (this.min - this.max) * (this.min + this.max);
                    }
                } else {
                    if ((f *= this.max) > this.min) {
                        f = this.min - (f - this.min) / (this.max - this.min) * (this.max + this.min);
                    }
                    f = -f;
                }
                super.func_180709_b(worldIn, rand, position.func_177982_a(r >> 24 & 0xF, (int)Math.floor(f) + this.hgt, r >> 28 & 0xF));
            }
            return true;
        }
    }
}

