/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAPI;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class EnergyTesla
implements EnergyAPI.IEnergyHandler {
    @Override
    public EnergyAPI.IEnergyAccess create(TileEntity te, EnumFacing s) {
        return te.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, s) || te.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, s) || te.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, s) ? new Energy((ICapabilityProvider)te, s) : null;
    }

    @Override
    public EnergyAPI.IEnergyAccess create(ItemStack item, int s) {
        EnumFacing side = s >= 0 && s < 6 ? EnumFacing.field_82609_l[s] : null;
        return item.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side) || item.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side) || item.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side) ? new Energy((ICapabilityProvider)item, side) : null;
    }

    static class Energy
    implements EnergyAPI.IEnergyAccess {
        final ICapabilityProvider cp;
        final EnumFacing s;

        Energy(ICapabilityProvider cp, EnumFacing s) {
            this.cp = cp;
            this.s = s;
        }

        @Override
        public float getStorage() {
            ITeslaHolder h = (ITeslaHolder)this.cp.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, this.s);
            return h != null ? (float)h.getStoredPower() * EnergyAPI.RF_value : 0.0f;
        }

        @Override
        public float getCapacity() {
            ITeslaHolder h = (ITeslaHolder)this.cp.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, this.s);
            return h != null ? (float)h.getCapacity() * EnergyAPI.RF_value : 0.0f;
        }

        @Override
        public float addEnergy(float e) {
            if (e >= EnergyAPI.RF_value) {
                ITeslaConsumer c = (ITeslaConsumer)this.cp.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, this.s);
                return c != null ? (float)c.givePower((long)Math.floor(e / EnergyAPI.RF_value), false) * EnergyAPI.RF_value : 0.0f;
            }
            if (e <= -EnergyAPI.RF_value) {
                ITeslaProducer p = (ITeslaProducer)this.cp.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, this.s);
                return p != null ? (float)p.takePower((long)Math.floor(e / -EnergyAPI.RF_value), false) * -EnergyAPI.RF_value : 0.0f;
            }
            return 0.0f;
        }
    }
}

