/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAPI;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class EnergyRedstoneFlux
implements EnergyAPI.IEnergyHandler {
    @Override
    public EnergyAPI.IEnergyAccess create(TileEntity te, EnumFacing s) {
        return te instanceof IEnergyHandler ? new EnergyTile((IEnergyHandler)te, s) : null;
    }

    @Override
    public EnergyAPI.IEnergyAccess create(ItemStack item, int s) {
        return item.func_77973_b() instanceof IEnergyContainerItem ? new EnergyItem(item, (IEnergyContainerItem)item.func_77973_b()) : null;
    }

    static class EnergyItem
    implements EnergyAPI.IEnergyAccess {
        final ItemStack item;
        final IEnergyContainerItem energy;

        EnergyItem(ItemStack item, IEnergyContainerItem energy) {
            this.item = item;
            this.energy = energy;
        }

        @Override
        public float getStorage() {
            return (float)this.energy.getEnergyStored(this.item) * EnergyAPI.RF_value;
        }

        @Override
        public float getCapacity() {
            return (float)this.energy.getMaxEnergyStored(this.item) * EnergyAPI.RF_value;
        }

        @Override
        public float addEnergy(float e) {
            if (e >= EnergyAPI.RF_value) {
                return (float)this.energy.receiveEnergy(this.item, (int)Math.floor(e / EnergyAPI.RF_value), false) * EnergyAPI.RF_value;
            }
            if (e <= -EnergyAPI.RF_value && this.energy instanceof IEnergyProvider) {
                return (float)this.energy.extractEnergy(this.item, (int)Math.floor(e / -EnergyAPI.RF_value), false) * -EnergyAPI.RF_value;
            }
            return 0.0f;
        }
    }

    static class EnergyTile
    implements EnergyAPI.IEnergyAccess {
        final IEnergyHandler energy;
        final EnumFacing s;

        EnergyTile(IEnergyHandler tile, EnumFacing s) {
            this.energy = tile;
            this.s = s;
        }

        @Override
        public float getStorage() {
            return (float)this.energy.getEnergyStored(this.s) * EnergyAPI.RF_value;
        }

        @Override
        public float getCapacity() {
            return (float)this.energy.getMaxEnergyStored(this.s) * EnergyAPI.RF_value;
        }

        @Override
        public float addEnergy(float e) {
            if (e >= EnergyAPI.RF_value && this.energy instanceof IEnergyReceiver) {
                return (float)((IEnergyReceiver)this.energy).receiveEnergy(this.s, (int)Math.floor(e / EnergyAPI.RF_value), false) * EnergyAPI.RF_value;
            }
            if (e <= -EnergyAPI.RF_value && this.energy instanceof IEnergyProvider) {
                return (float)((IEnergyProvider)this.energy).extractEnergy(this.s, (int)Math.floor(e / -EnergyAPI.RF_value), false) * -EnergyAPI.RF_value;
            }
            return 0.0f;
        }
    }
}

