/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.Capabilities;
import cd4017be.api.energy.EnergyAPI;
import cd4017be.lib.TooltipInfo;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class EnergyAutomation
implements EnergyAPI.IEnergyHandler {
    @Override
    public EnergyAPI.IEnergyAccess create(TileEntity te, EnumFacing s) {
        return (EnergyAPI.IEnergyAccess)te.getCapability(Capabilities.ELECTRIC_CAPABILITY, s);
    }

    @Override
    public EnergyAPI.IEnergyAccess create(ItemStack item, int s) {
        return item != null && item.func_77973_b() instanceof IEnergyItem ? new EnergyItem(item, (IEnergyItem)item.func_77973_b(), s) : null;
    }

    public static class EnergyItem
    implements EnergyAPI.IEnergyAccess {
        private final ItemStack stack;
        private final int s;
        public final IEnergyItem item;
        public float fractal = 0.0f;

        public EnergyItem(ItemStack stack, IEnergyItem item, int s) {
            this.stack = stack;
            this.item = item;
            this.s = s;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
        }

        public void addInformation(List<String> list) {
            list.add(String.format("Energy: %d / %d %s", this.getStorageI(), this.item.getEnergyCap(this.stack), TooltipInfo.getEnergyUnit()));
        }

        public int getStorageI() {
            return this.stack.func_77978_p().func_74762_e(this.item.getEnergyTag());
        }

        public int addEnergyI(int n) {
            int e;
            if (n == 0) {
                return n;
            }
            int cap = this.item.getEnergyCap(this.stack);
            if (this.s >= 0) {
                int max = this.item.getChargeSpeed(this.stack);
                if (n > max) {
                    n = max;
                } else if (n < -max) {
                    n = -max;
                }
            }
            if ((e = this.stack.func_77978_p().func_74762_e(this.item.getEnergyTag()) + n) < 0) {
                n -= e;
                e = 0;
            } else if (e > cap) {
                n -= e - cap;
                e = cap;
            }
            this.stack.func_77978_p().func_74768_a(this.item.getEnergyTag(), e);
            return n;
        }

        @Override
        public float getStorage() {
            if (this.s == -2) {
                return ((float)this.getStorageI() + this.fractal) * 1000.0f;
            }
            return (float)this.getStorageI() * 1000.0f;
        }

        @Override
        public float getCapacity() {
            return (float)this.item.getEnergyCap(this.stack) * 1000.0f;
        }

        @Override
        public float addEnergy(float E) {
            E /= 1000.0f;
            if (this.s == -2) {
                this.fractal = E - (float)this.addEnergyI((int)Math.floor(E + this.fractal));
                if (this.fractal < 0.0f || this.fractal >= 1.0f) {
                    float d = (float)Math.floor(this.fractal);
                    this.fractal -= d;
                    E -= d;
                }
                return E * 1000.0f;
            }
            return (float)this.addEnergyI(E < 0.0f ? (int)Math.ceil(E) : (int)Math.floor(E)) * 1000.0f;
        }
    }

    public static interface IEnergyItem {
        public int getEnergyCap(ItemStack var1);

        public int getChargeSpeed(ItemStack var1);

        public String getEnergyTag();
    }
}

