/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAutomation;
import cd4017be.api.energy.EnergyIndustrialCraft;
import cd4017be.api.energy.EnergyOpenComputers;
import cd4017be.api.energy.EnergyRedstoneFlux;
import cd4017be.api.energy.EnergyTesla;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;

public class EnergyAPI {
    public static ArrayList<IEnergyHandler> handlers = new ArrayList();
    public static final IEnergyAccess NULL = new NullAccess();
    public static final float IA_value = 1000.0f;
    public static float RF_value = 100.0f;
    public static float EU_value = 400.0f;
    public static float OC_value = 1000.0f;

    public static void init() {
        if (Loader.isModLoaded((String)"Automation")) {
            handlers.add(new EnergyAutomation());
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added Inductive Automation Energy-API", (Object[])new Object[0]);
        }
        if (Loader.isModLoaded((String)"OpenComputers")) {
            handlers.add(new EnergyOpenComputers());
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added Open Computers Energy-API", (Object[])new Object[0]);
        }
        if (Loader.isModLoaded((String)"Tesla")) {
            handlers.add(new EnergyTesla());
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added Tesla Energy-API", (Object[])new Object[0]);
        }
        if (Loader.isModLoaded((String)"IC2")) {
            handlers.add(new EnergyIndustrialCraft());
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added IC2 Energy-API", (Object[])new Object[0]);
        }
        handlers.add(new EnergyRedstoneFlux());
        FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added Redstone Flux Energy-API", (Object[])new Object[0]);
    }

    public static IEnergyAccess get(TileEntity te, EnumFacing s) {
        if (te == null) {
            return NULL;
        }
        if (te instanceof IEnergyAccess) {
            return (IEnergyAccess)te;
        }
        for (IEnergyHandler c : handlers) {
            IEnergyAccess e = c.create(te, s);
            if (e == null) continue;
            return e;
        }
        return NULL;
    }

    public static IEnergyAccess get(ItemStack item, int s) {
        if (item == null || item.func_77973_b() == null || item.field_77994_a != 1) {
            return NULL;
        }
        for (IEnergyHandler c : handlers) {
            IEnergyAccess e = c.create(item, s);
            if (e == null) continue;
            return e;
        }
        return NULL;
    }

    static class NullAccess
    implements IEnergyAccess {
        NullAccess() {
        }

        @Override
        public float getStorage() {
            return 0.0f;
        }

        @Override
        public float getCapacity() {
            return 0.0f;
        }

        @Override
        public float addEnergy(float e) {
            return 0.0f;
        }
    }

    public static interface IEnergyHandler {
        public IEnergyAccess create(TileEntity var1, EnumFacing var2);

        public IEnergyAccess create(ItemStack var1, int var2);
    }

    public static interface IEnergyAccess {
        public float getStorage();

        public float getCapacity();

        public float addEnergy(float var1);
    }
}

