/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.circuits.Objects;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.TooltipInfo;
import java.util.Arrays;
import java.util.List;
import multiblock.IntegerComp;
import multiblock.SharedInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;

public class WirelessConnector
extends ModTileEntity
implements TickRegistry.IUpdatable {
    protected BlockPos linkPos = BlockPos.field_177992_a;
    protected int linkDim;
    protected WirelessConnector linkTile;
    protected ModTileEntity conTile;
    private boolean updateLink;
    private boolean updateCon;

    protected void link(WirelessConnector tile) {
        if (tile != this.linkTile) {
            IntegerComp c;
            this.linkTile = tile;
            if (this.linkTile != null) {
                this.linkPos = this.linkTile.field_174879_c;
                this.linkDim = this.linkTile.dimensionId;
                if (!this.field_145846_f && this.conTile != null && !this.conTile.func_145837_r()) {
                    this.conTile.onNeighborTileChange(this.field_174879_c);
                }
            } else if (this.conTile != null && !this.conTile.func_145837_r() && (c = (IntegerComp)((Object)this.conTile.getCapability(Objects.RS_INTEGER_CAPABILITY, EnumFacing.field_82609_l[this.getOrientation() ^ 1]))) != null) {
                ((SharedInteger)c.network).markDirty();
            }
        }
        this.updateLink = false;
    }

    private void checkLink(boolean forceLoad) {
        TileEntity te;
        WorldServer world = DimensionManager.getWorld((int)this.linkDim);
        TileEntity tileEntity = te = world != null && (forceLoad || world.func_175667_e(this.linkPos)) ? world.func_175625_s(this.linkPos) : null;
        if (te == this.linkTile) {
            return;
        }
        if (this.linkTile != null && this.linkTile.linkTile == this) {
            this.linkTile.link(null);
        }
        if (te instanceof WirelessConnector) {
            this.link((WirelessConnector)te);
            this.linkTile.link(this);
        } else {
            this.link(null);
        }
    }

    public void process() {
        if (this.updateLink) {
            this.checkLink(false);
        }
        if (this.updateCon) {
            TileEntity te = this.getLoadedTile(this.field_174879_c.func_177972_a(EnumFacing.field_82609_l[this.getOrientation()]));
            if (!(te instanceof ModTileEntity) || te instanceof WirelessConnector) {
                te = null;
            }
            if (te != this.conTile) {
                this.conTile = (ModTileEntity)te;
                if (this.linkTile != null && this.linkTile.conTile != null && !this.linkTile.conTile.func_145837_r()) {
                    this.linkTile.conTile.onNeighborTileChange(this.linkTile.field_174879_c);
                }
            }
            this.updateCon = false;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.linkPos = new BlockPos(nbt.func_74762_e("lx"), nbt.func_74762_e("ly"), nbt.func_74762_e("lz"));
        this.linkDim = nbt.func_74762_e("ld");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("lx", this.linkPos.func_177958_n());
        nbt.func_74768_a("ly", this.linkPos.func_177956_o());
        nbt.func_74768_a("lz", this.linkPos.func_177952_p());
        nbt.func_74768_a("ld", this.linkDim);
        return super.func_189515_b(nbt);
    }

    public void func_145843_s() {
        if (this.linkTile != null && this.linkTile.linkTile == this) {
            this.linkTile.link(null);
        }
        this.linkTile = null;
        this.conTile = null;
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.linkTile != null && this.linkTile.linkTile == this) {
            this.linkTile.link(null);
        }
        this.linkTile = null;
        this.conTile = null;
        super.onChunkUnload();
    }

    public void func_145829_t() {
        this.updateCon = true;
        this.updateLink = true;
        TickRegistry.instance.updates.add(this);
        super.func_145829_t();
    }

    public void onNeighborTileChange(BlockPos pos) {
        if (!this.updateCon) {
            this.updateCon = true;
            TickRegistry.instance.updates.add(this);
        }
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == Objects.RS_INTEGER_CAPABILITY && facing.ordinal() == this.getOrientation();
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        return (T)(cap == Objects.RS_INTEGER_CAPABILITY && facing.ordinal() == this.getOrientation() && this.linkTile != null && this.linkTile.conTile != null ? this.linkTile.conTile.getCapability(cap, EnumFacing.field_82609_l[this.linkTile.getOrientation() ^ 1]) : null);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        String msg;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (item.func_77952_i() == 0) {
            ItemStack drop = new ItemStack(item.func_77973_b(), 1, 1);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("lx", this.field_174879_c.func_177958_n());
            nbt.func_74768_a("ly", this.field_174879_c.func_177956_o());
            nbt.func_74768_a("lz", this.field_174879_c.func_177952_p());
            nbt.func_74768_a("ld", this.dimensionId);
            drop.func_77982_d(nbt);
            EntityItem eitem = new EntityItem(this.field_145850_b, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, drop);
            this.field_145850_b.func_72838_d((Entity)eitem);
            msg = TooltipInfo.format((String)"msg.cd4017be.wireless0", (Object[])new Object[0]);
        } else if (item.func_77942_o()) {
            NBTTagCompound nbt = item.func_77978_p();
            this.linkPos = new BlockPos(nbt.func_74762_e("lx"), nbt.func_74762_e("ly"), nbt.func_74762_e("lz"));
            this.linkDim = nbt.func_74762_e("ld");
            this.checkLink(true);
            msg = TooltipInfo.format((String)(this.linkTile != null ? "msg.cd4017be.wireless1" : "msg.cd4017be.wireless2"), (Object[])new Object[]{this.linkDim, this.linkPos.func_177958_n(), this.linkPos.func_177956_o(), this.linkPos.func_177952_p()});
        } else {
            return;
        }
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_145747_a((ITextComponent)new TextComponentString(msg));
        }
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        String msg;
        if (this.field_145850_b.field_72995_K || !player.func_70093_af() || item != null) {
            return true;
        }
        this.checkLink(true);
        if (this.linkTile != null && this.linkTile.linkTile == this) {
            item = new ItemStack(this.func_145838_q());
            this.linkTile.field_145850_b.func_175698_g(this.linkTile.field_174879_c);
            this.field_145850_b.func_175698_g(this.func_174877_v());
            EntityItem eitem = new EntityItem(this.field_145850_b, player.field_70165_t, player.field_70163_u, player.field_70161_v, item);
            this.field_145850_b.func_72838_d((Entity)eitem);
            msg = TooltipInfo.format((String)"msg.cd4017be.wireless4", (Object[])new Object[0]);
        } else {
            msg = TooltipInfo.format((String)"msg.cd4017be.wireless5", (Object[])new Object[0]);
        }
        player.func_145747_a((ITextComponent)new TextComponentString(msg));
        return true;
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        ItemStack item = new ItemStack(state.func_177230_c(), 1, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("lx", this.linkPos.func_177958_n());
        nbt.func_74768_a("ly", this.linkPos.func_177956_o());
        nbt.func_74768_a("lz", this.linkPos.func_177952_p());
        nbt.func_74768_a("ld", this.linkDim);
        item.func_77982_d(nbt);
        return Arrays.asList(item);
    }
}

