/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.IPipe;
import cd4017be.lib.util.Utils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;

public class RSPipe8
extends ModTileEntity
implements IRedstone8bit,
IPipe,
ITickable {
    private byte state;
    private boolean update = false;
    private short flow;
    private boolean updateCon = true;
    private IPipe.Cover cover = null;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateCon) {
            this.updateConnections();
        }
        if (this.getFlowBit(6) && this.update) {
            this.transferSignal(0);
        }
    }

    private void updateConnections() {
        boolean lHasOut = this.getFlowBit(6);
        boolean lHasIn = this.getFlowBit(14);
        boolean nHasOut = false;
        boolean nHasIn = false;
        ArrayList<RSPipe8> updateList = new ArrayList<RSPipe8>();
        short lFlow = this.flow;
        for (int i = 0; i < 6; ++i) {
            boolean lDirOut = this.getFlowBit(i);
            boolean lDirIn = this.getFlowBit(i | 8);
            if (lDirOut && lDirIn) continue;
            EnumFacing dir = EnumFacing.field_82609_l[i];
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (te == null) {
                this.setFlowBit(i, false);
                this.setFlowBit(i | 8, false);
                continue;
            }
            if (te instanceof RSPipe8) {
                boolean nDirIn;
                RSPipe8 pipe = (RSPipe8)te;
                boolean pHasOut = pipe.getFlowBit(6);
                boolean pHasIn = pipe.getFlowBit(14);
                boolean pDirOut = pipe.getFlowBit(i ^ 1);
                boolean pDirIn = pipe.getFlowBit(i ^ 1 | 8);
                boolean nDirOut = pHasOut && !pDirOut;
                boolean bl = nDirIn = pHasIn && !pDirIn;
                if (pDirOut && pDirIn) {
                    nDirOut = true;
                    nDirIn = true;
                } else if (nDirOut && nDirIn) {
                    boolean s = lHasIn ^ lHasOut;
                    nDirOut = s && lHasIn && !lDirIn;
                    nDirIn = s && lHasOut && !lDirOut;
                }
                this.setFlowBit(i, nDirOut);
                this.setFlowBit(i | 8, nDirIn);
                nHasIn |= nDirIn && !nDirOut;
                nHasOut |= nDirOut && !nDirIn;
                updateList.add(pipe);
                continue;
            }
            if (te instanceof IRedstone8bit) {
                byte d = ((IRedstone8bit)te).getDirection(i ^ 1);
                if (d == 0) {
                    this.setFlowBit(i, false);
                    this.setFlowBit(i | 8, false);
                    continue;
                }
                if (d > 0) {
                    this.setFlowBit(i, false);
                    this.setFlowBit(i | 8, true);
                    nHasIn = true;
                    continue;
                }
                if (d >= 0) continue;
                this.setFlowBit(i, true);
                this.setFlowBit(i | 8, false);
                nHasOut = true;
                continue;
            }
            this.setFlowBit(i, false);
            this.setFlowBit(i | 8, false);
        }
        this.setFlowBit(6, nHasOut);
        this.setFlowBit(14, nHasIn);
        if (this.flow != lFlow) {
            this.markUpdate();
            for (RSPipe8 pipe : updateList) {
                pipe.onNeighborBlockChange(Blocks.field_150350_a);
            }
            this.update = true;
        }
        this.updateCon = false;
    }

    private void transferSignal(int recursion) {
        int i;
        IRedstone8bit[] rst = new IRedstone8bit[6];
        byte[] dir = new byte[6];
        int n = 0;
        byte lstate = this.state;
        this.state = 0;
        for (i = 0; i < 6; ++i) {
            boolean dirOut = this.getFlowBit(i);
            boolean dirIn = this.getFlowBit(i | 8);
            if (!dirIn ^ dirOut) continue;
            TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
            if (te == null || !(te instanceof IRedstone8bit)) {
                this.updateCon = true;
                continue;
            }
            if (dirIn) {
                this.state = (byte)(this.state | ((IRedstone8bit)te).getValue(i ^ 1));
                continue;
            }
            if (!dirOut) continue;
            rst[n] = (IRedstone8bit)te;
            dir[n++] = (byte)(i ^ 1);
        }
        if (this.state != lstate) {
            ++recursion;
            for (i = 0; i < n; ++i) {
                rst[i].setValue((int)dir[i], this.state, recursion);
            }
        }
        this.update = false;
    }

    public void onNeighborBlockChange(Block b) {
        this.updateCon = true;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing dir, float X, float Y, float Z) {
        int s = dir.func_176745_a();
        if (player.func_70093_af() && item == null) {
            float dz;
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            if (this.cover != null) {
                this.dropStack(this.cover.item);
                this.cover = null;
                this.markUpdate();
                return true;
            }
            float dx = Math.abs(X -= 0.5f);
            float dy = Math.abs(Y);
            s = dy > (dz = Math.abs(Z)) && dy > dx ? ((Y -= 0.5f) < 0.0f ? 0 : 1) : (dz > dx ? ((Z -= 0.5f) < 0.0f ? 2 : 3) : (X < 0.0f ? 4 : 5));
            boolean lock = !this.getFlowBit(s) || !this.getFlowBit(s | 8);
            this.setFlowBit(s, lock);
            this.setFlowBit(s | 8, lock);
            this.onNeighborBlockChange(Blocks.field_150350_a);
            this.markUpdate();
            TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)s));
            if (te != null && te instanceof RSPipe8) {
                RSPipe8 pipe = (RSPipe8)te;
                pipe.setFlowBit(s ^ 1, lock);
                pipe.setFlowBit(s ^ 1 | 8, lock);
                pipe.onNeighborBlockChange(Blocks.field_150350_a);
                pipe.markUpdate();
            }
            return true;
        }
        if (!player.func_70093_af() && this.cover == null && item != null && (this.cover = IPipe.Cover.create((ItemStack)item)) != null) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            --item.field_77994_a;
            if (item.field_77994_a <= 0) {
                item = null;
            }
            player.func_184611_a(hand, item);
            this.markUpdate();
            return true;
        }
        return false;
    }

    public boolean getFlowBit(int b) {
        return (this.flow & 1 << b) != 0;
    }

    private void setFlowBit(int b, boolean v) {
        this.flow = v ? (short)(this.flow | 1 << b) : (short)(this.flow & ~(1 << b));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74777_a("flow", this.flow);
        nbt.func_74774_a("state", this.state);
        if (this.cover != null) {
            this.cover.write(nbt, "cover");
        }
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.flow = nbt.func_74765_d("flow");
        this.state = nbt.func_74771_c("state");
        this.cover = IPipe.Cover.read((NBTTagCompound)nbt, (String)"cover");
        this.updateCon = true;
        this.update = true;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.flow = pkt.func_148857_g().func_74765_d("flow");
        this.cover = IPipe.Cover.read((NBTTagCompound)pkt.func_148857_g(), (String)"cover");
        this.markUpdate();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("flow", this.flow);
        if (this.cover != null) {
            this.cover.write(nbt, "cover");
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void breakBlock() {
        super.breakBlock();
        if (this.cover != null) {
            EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.cover.item);
            this.cover = null;
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    public byte getValue(int s) {
        return this.state;
    }

    public byte getDirection(int s) {
        boolean b2;
        boolean b1 = this.getFlowBit(s);
        return (byte)(b1 ^ (b2 = this.getFlowBit(s | 8)) ? (b1 ? 1 : -1) : 0);
    }

    public void setValue(int s, byte v, int recursion) {
        if (v != this.state) {
            if (recursion > 16) {
                this.update = true;
            } else {
                this.transferSignal(recursion);
            }
        }
    }

    public IPipe.Cover getCover() {
        return this.cover;
    }

    public int textureForSide(byte s) {
        boolean b1;
        if (s == -1) {
            return 0;
        }
        TileEntity p = Utils.getTileOnSide((ModTileEntity)this, (byte)s);
        boolean b0 = this.getFlowBit(s);
        if (b0 ^ (b1 = this.getFlowBit(s | 8)) || !b0 && !b1 && p != null && p instanceof IRedstone8bit) {
            return (b0 ? 1 : 0) | (b1 ? 2 : 0);
        }
        return -1;
    }
}

