/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.circuits.Objects;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.templates.Inventory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class Programmer
extends AutomatedTile
implements DataContainer.IGuiData {
    private static final int E_Load = 1;
    private static final int E_Save = 2;
    private static final int E_Comp = 3;
    private static final int E_invalid = 4;
    private static final int E_cap = 5;
    private static final int E_gate = 6;
    private static final int E_calc = 7;
    private static final int E_tooBig = 8;
    private static final int E_num = 9;
    private static final int E_arg = 10;
    private static final int E_cmd = 11;
    private static final int E_err = 12;
    private static final int E_struc = 13;
    public String[] code = new String[]{""};
    public String[] label = new String[]{""};
    public String name = "";
    public int errorCode = 0;
    public int errorArg;

    public Programmer() {
        this.inventory = new Inventory(1, 0, null);
    }

    public String getCode(int i) {
        return i < this.code.length && this.code[i] != null ? this.code[i] : "";
    }

    public String getLabel(int i) {
        return i < this.label.length && this.label[i] != null ? this.label[i] : "";
    }

    private String serializeCode() {
        String s = "";
        for (int i = 0; i < this.code.length; ++i) {
            s = s + this.code[i] + (this.label[i].isEmpty() ? "" : "\"" + this.label[i]) + (i != this.code.length - 1 ? "\n" : "");
        }
        return s;
    }

    private void deserializeCode(String s) {
        String[] c = s.split("\n", 256);
        this.code = new String[c.length];
        this.label = new String[c.length];
        for (int i = 0; i < c.length; ++i) {
            int j = c[i].indexOf(34);
            this.label[i] = j < 0 ? "" : c[i].substring(j + 1);
            String string = this.code[i] = j < 0 ? c[i] : c[i].substring(0, j);
            if (this.label[i].length() > 8) {
                this.label[i] = this.label[i].substring(0, 8);
            }
            if (this.code[i].length() <= 32) continue;
            this.code[i] = this.code[i].substring(0, 32);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("code", this.serializeCode());
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.name = nbt.func_74779_i("name");
        this.deserializeCode(nbt.func_74779_i("code"));
    }

    protected void customPlayerCommand(byte cmd, PacketBuffer dis, EntityPlayerMP player) throws IOException {
        this.errorCode = 0;
        if (cmd == 0 || cmd == 1) {
            Object[] arr;
            int p = dis.readByte() & 0xFF;
            String s = dis.func_150789_c(32);
            if (p >= this.code.length) {
                if (s.isEmpty()) {
                    return;
                }
                arr = new String[p + 1];
                System.arraycopy(this.code, 0, arr, 0, this.code.length);
                Arrays.fill(arr, this.code.length, arr.length, "");
                this.code = arr;
                arr = new String[p + 1];
                System.arraycopy(this.label, 0, arr, 0, this.label.length);
                Arrays.fill(arr, this.label.length, arr.length, "");
                this.label = arr;
            }
            if (cmd == 0) {
                this.code[p] = s;
            } else {
                String string = this.label[p] = s.length() > 8 ? s.substring(0, 8) : s;
            }
            if (p == this.code.length - 1 && s.isEmpty()) {
                while (p > 0 && this.code[p].isEmpty() && this.label[p].isEmpty()) {
                    --p;
                }
                if (++p < this.code.length) {
                    arr = new String[p];
                    System.arraycopy(this.code, 0, arr, 0, arr.length);
                    this.code = arr;
                    arr = new String[p];
                    System.arraycopy(this.label, 0, arr, 0, arr.length);
                    this.label = arr;
                }
            }
        } else if (cmd == 2) {
            this.name = dis.func_150789_c(24);
        } else if (cmd == 3) {
            NBTTagCompound nbt;
            if (this.inventory.items[0] != null && this.inventory.items[0].func_77973_b() == Objects.circuitPlan && (nbt = this.inventory.items[0].func_77978_p()) != null) {
                this.name = nbt.func_74779_i("name");
                this.deserializeCode(nbt.func_74779_i("code"));
                this.errorCode = 1;
                this.errorArg = this.code.length;
            } else if (this.inventory.items[0] == null || this.inventory.items[0].func_77973_b() == Items.field_151121_aF) {
                this.name = "";
                this.code = new String[]{""};
                this.label = new String[]{""};
                this.errorCode = 1;
                this.errorArg = 0;
            } else {
                this.errorCode = 4;
            }
        } else if (cmd == 4 && this.inventory.items[0] != null) {
            if (this.inventory.items[0].func_77973_b() == Objects.circuitPlan) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("name", this.name);
                nbt.func_74778_a("code", this.serializeCode());
                byte[] data = this.compile();
                if (data == null) {
                    return;
                }
                nbt.func_74773_a("data", data);
                this.inventory.items[0].func_77982_d(nbt);
                this.errorCode = 2;
                this.errorArg = this.code.length;
            } else {
                this.errorCode = 4;
            }
        }
    }

    private byte[] compile() {
        ByteBuf data = Unpooled.buffer();
        int n = 0;
        int p = data.writerIndex();
        data.writeByte(n);
        int l = 0;
        try {
            while (l < this.code.length) {
                if (this.code[l].isEmpty()) {
                    int k;
                    for (k = l + 1; k < this.code.length && this.code[k].isEmpty(); ++k) {
                    }
                    l += (k -= l);
                    data.writeByte(-1).writeByte(k);
                    ++n;
                    continue;
                }
                String lab = this.label[l];
                String s0 = this.code[l].substring(1);
                int cmd = 0;
                switch (this.code[l].charAt(0)) {
                    case '+': {
                        this.addBitParams(data, 0, s0);
                        ++l;
                        break;
                    }
                    case '-': {
                        this.addBitParams(data, 1, s0);
                        ++l;
                        break;
                    }
                    case '&': {
                        this.addBitParams(data, 2, s0);
                        ++l;
                        break;
                    }
                    case '*': {
                        this.addBitParams(data, 3, s0);
                        ++l;
                        break;
                    }
                    case '/': {
                        this.addBitParams(data, 4, s0);
                        ++l;
                        break;
                    }
                    case '\\': {
                        this.addBitParams(data, 5, s0);
                        ++l;
                        break;
                    }
                    case '<': {
                        this.addParameters(data, 6, 1, 0, s0);
                        ++l;
                        break;
                    }
                    case '>': {
                        this.addParameters(data, 7, 1, 0, s0);
                        ++l;
                        break;
                    }
                    case '=': {
                        this.addParameters(data, 8, 1, 0, s0);
                        ++l;
                        break;
                    }
                    case '~': {
                        this.addParameters(data, 9, 1, 0, s0);
                        ++l;
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        cmd = (byte)(cmd + 8);
                    }
                    case 'M': 
                    case 'm': {
                        cmd = (byte)(cmd + 8);
                    }
                    case 'S': 
                    case 's': {
                        cmd = (byte)(cmd + 8);
                    }
                    case 'B': 
                    case 'b': {
                        cmd = (byte)(cmd + 8);
                        s0 = s0.substring(1);
                        switch (this.code[l].charAt(1)) {
                            case '$': {
                                this.addParameters(data, 10, cmd, 2, s0);
                                break;
                            }
                            case '?': {
                                this.addParameters(data, 11, cmd, 1, s0);
                                break;
                            }
                            case '+': {
                                this.addParameters(data, 12, cmd, 0, s0);
                                break;
                            }
                            case '-': {
                                this.addParameters(data, 13, cmd, 0, s0);
                                break;
                            }
                            case '*': {
                                this.addParameters(data, 14, cmd, 0, s0);
                                break;
                            }
                            case '/': {
                                this.addParameters(data, 15, cmd, 0, s0);
                                break;
                            }
                            case '%': {
                                this.addParameters(data, 16, cmd, 0, s0);
                                break;
                            }
                            default: {
                                this.errorCode = 11;
                                this.errorArg = l;
                                return null;
                            }
                        }
                        l &= 0xF8;
                        int j = Math.min(this.code.length, ++l + cmd * 8 + 7);
                        while (l < j) {
                            if (!this.code[l].isEmpty()) {
                                this.errorCode = 13;
                                this.errorArg = l;
                                return null;
                            }
                            ++l;
                        }
                        break;
                    }
                    default: {
                        this.errorCode = 11;
                        this.errorArg = l;
                        return null;
                    }
                }
                byte[] b = lab.getBytes();
                data.writeByte(b.length);
                data.writeBytes(b);
                ++n;
            }
            data.setByte(p, n);
            data.writeByte(0);
            byte[] ret = new byte[data.writerIndex()];
            data.readBytes(ret);
            this.errorCode = 3;
            this.errorArg = p;
            return ret;
        }
        catch (NumberFormatException e) {
            this.errorCode = 9;
            this.errorArg = l;
        }
        catch (IllegalArgumentException e) {
            this.errorCode = 10;
            this.errorArg = l;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.errorCode = 8;
            this.errorArg = l;
        }
        catch (Exception e) {
            this.errorCode = 12;
            this.errorArg = l;
        }
        return null;
    }

    private void addBitParams(ByteBuf data, int cmd, String s) {
        data.writeByte(cmd);
        String[] s1 = s.split(",");
        if (s1.length > 15) {
            throw new IllegalArgumentException();
        }
        data.writeByte(s1.length);
        for (String s2 : s1) {
            if ((s2 = s2.trim()).length() > 2) {
                throw new NumberFormatException();
            }
            data.writeByte(Integer.parseInt(s2, 16));
        }
    }

    private void addParameters(ByteBuf data, int cmd, int t, int n, String s) {
        int j;
        String[] s1 = s.split(",");
        if (s1.length != n + 2) {
            throw new IllegalArgumentException();
        }
        data.writeByte(cmd);
        if (t >= 8) {
            data.writeByte(t);
        }
        for (j = 2; j < s1.length; ++j) {
            String s2 = s1[j].trim();
            if (s2.length() > 2) {
                throw new NumberFormatException();
            }
            data.writeByte(Integer.parseInt(s2, 16));
        }
        for (j = 0; j < 2; ++j) {
            try {
                int x = Integer.parseInt(s1[j]);
                data.writeByte(-1);
                data.writeInt(x);
                continue;
            }
            catch (NumberFormatException e) {
                int x;
                String s3 = s1[j];
                switch (s3.charAt(0)) {
                    case 'B': {
                        x = 4;
                        break;
                    }
                    case 'S': {
                        x = 5;
                        break;
                    }
                    case 'M': {
                        x = 6;
                        break;
                    }
                    case 'I': {
                        x = 7;
                        break;
                    }
                    case 'b': {
                        x = 0;
                        break;
                    }
                    case 's': {
                        x = 1;
                        break;
                    }
                    case 'm': {
                        x = 2;
                        break;
                    }
                    case 'i': {
                        x = 3;
                        break;
                    }
                    default: {
                        throw new NumberFormatException();
                    }
                }
                data.writeByte(x);
                data.writeByte((int)Byte.parseByte(s3.substring(1)));
            }
        }
    }

    public void initContainer(DataContainer container) {
        TileContainer c = (TileContainer)container;
        if (!this.field_145850_b.field_72995_K) {
            c.extraRef = new LastState();
        }
        c.addItemSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 0, 134, 91));
        c.addPlayerInventory(8, 125);
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        int j;
        int chng2;
        int p2;
        int i;
        LastState ls = (LastState)container.extraRef;
        int p = dos.writerIndex();
        dos.writeByte(0);
        byte chng = 0;
        if (this.errorCode != ls.errCode) {
            ls.errCode = this.errorCode;
            dos.writeByte(ls.errCode);
            chng = (byte)(chng | 1);
        }
        if (this.errorArg != ls.errArg) {
            ls.errArg = this.errorArg;
            dos.writeInt(ls.errArg);
            chng = (byte)(chng | 2);
        }
        if (this.name != ls.name) {
            ls.name = this.name;
            dos.func_180714_a(ls.name);
            chng = (byte)(chng | 4);
        }
        if (this.code.length != ls.size) {
            ls.size = this.code.length;
            dos.writeShort(ls.size);
            chng = (byte)(chng | 8);
        }
        int p1 = dos.writerIndex();
        int chng1 = 0;
        dos.writeInt(chng1);
        for (i = 0; i < this.code.length; i += 8) {
            p2 = dos.writerIndex();
            chng2 = 0;
            dos.writeByte(chng2);
            for (j = i; j < i + 8 && j < this.code.length; ++j) {
                if (this.code[j] == ls.code[j]) continue;
                chng2 = (byte)(chng2 | 1 << (j & 7));
                ls.code[j] = this.code[j];
                dos.func_180714_a(ls.code[j]);
            }
            if (chng2 != 0) {
                dos.setByte(p2, chng2);
                chng1 |= 1 << (i >> 3);
                continue;
            }
            dos.writerIndex(p2);
        }
        if (chng1 != 0) {
            dos.setInt(p1, chng1);
            chng = (byte)(chng | 0x10);
        } else {
            dos.writerIndex(p1);
        }
        p1 = dos.writerIndex();
        chng1 = 0;
        dos.writeInt(chng1);
        for (i = 0; i < this.label.length; i += 8) {
            p2 = dos.writerIndex();
            chng2 = 0;
            dos.writeByte(chng2);
            for (j = i; j < i + 8 && j < this.label.length; ++j) {
                if (this.label[j] == ls.label[j]) continue;
                chng2 = (byte)(chng2 | 1 << (j & 7));
                ls.label[j] = this.label[j];
                dos.func_180714_a(ls.label[j]);
            }
            if (chng2 != 0) {
                dos.setByte(p2, chng2);
                chng1 |= 1 << (i >> 3);
                continue;
            }
            dos.writerIndex(p2);
        }
        if (chng1 != 0) {
            dos.setInt(p1, chng1);
            chng = (byte)(chng | 0x20);
        } else {
            dos.writerIndex(p1);
        }
        if (chng == 0) {
            return false;
        }
        dos.setByte(p, (int)chng);
        return true;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
        int j;
        int chng2;
        int chng1;
        byte chng = dis.readByte();
        if ((chng & 1) != 0) {
            this.errorCode = dis.readByte();
        }
        if ((chng & 2) != 0) {
            this.errorArg = dis.readInt();
        }
        if ((chng & 4) != 0) {
            this.name = dis.func_150789_c(24);
        }
        if ((chng & 8) != 0) {
            short s = dis.readShort();
            String[] arr = new String[s];
            System.arraycopy(this.code, 0, arr, 0, Math.min(this.code.length, s));
            this.code = arr;
            arr = new String[s];
            System.arraycopy(this.label, 0, arr, 0, Math.min(this.label.length, s));
            this.label = arr;
        }
        if ((chng & 0x10) != 0) {
            int i = 0;
            for (chng1 = dis.readInt(); chng1 != 0; chng1 >>>= 1) {
                if ((chng1 & 1) != 0) {
                    chng2 = dis.readByte() & 0xFF;
                    for (j = i * 8; chng2 != 0 && j < this.code.length; ++j, chng2 >>= 1) {
                        if ((chng2 & 1) == 0) continue;
                        this.code[j] = dis.func_150789_c(32);
                    }
                }
                ++i;
            }
        }
        if ((chng & 0x20) != 0) {
            int i = 0;
            for (chng1 = dis.readInt(); chng1 != 0; chng1 >>>= 1) {
                if ((chng1 & 1) != 0) {
                    chng2 = dis.readByte() & 0xFF;
                    for (j = i * 8; chng2 != 0 && j < this.label.length; ++j, chng2 >>= 1) {
                        if ((chng2 & 1) == 0) continue;
                        this.label[j] = dis.func_150789_c(8);
                    }
                }
                ++i;
            }
        }
    }

    public void breakBlock() {
        this.inventory.dropItems((ModTileEntity)this, 0, 1);
    }

    private static final class LastState {
        final String[] code = new String[256];
        final String[] label = new String[256];
        String name;
        int errCode;
        int errArg;
        int size = 1;

        private LastState() {
        }
    }
}

