/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.ModTileEntity;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class Potentiometer
extends ModTileEntity
implements IDirectionalRedstone,
DataContainer.IGuiData {
    public int min = 0;
    public int max = 15;
    public int cur = 0;

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        int state;
        boolean abs;
        if (s.ordinal() != this.getOrientation()) {
            return super.onActivated(player, hand, item, s, X, Y, Z);
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        switch (s) {
            case NORTH: {
                abs = X >= 0.5f;
                break;
            }
            case SOUTH: {
                abs = X < 0.5f;
                break;
            }
            case WEST: {
                abs = Z < 0.5f;
                break;
            }
            case EAST: {
                abs = Z >= 0.5f;
                break;
            }
            default: {
                return false;
            }
        }
        if (abs) {
            Y -= 0.109375f;
            state = Math.round((float)this.min + ((float)this.max - (float)this.min) * (Y *= 1.28f));
        } else {
            Y -= 0.5f;
            state = this.cur + ((Y *= 2.0f) > 0.0f ? (int)Math.pow((double)this.max - (double)this.min, Y) : -((int)Math.pow((double)this.max - (double)this.min, -Y)));
        }
        if (state < this.min) {
            state = this.min;
        } else if (state > this.max) {
            state = this.max;
        }
        if (state != this.cur) {
            this.cur = state;
            this.field_145850_b.func_175685_c(this.field_174879_c, Blocks.field_150429_aA);
            this.markUpdate();
        }
        return true;
    }

    public int redstoneLevel(int s, boolean str) {
        return str ? 0 : this.cur;
    }

    public void onPlayerCommand(PacketBuffer data, EntityPlayerMP player) throws IOException {
        byte cmd = data.readByte();
        switch (cmd) {
            case 0: {
                this.min = data.readInt();
                break;
            }
            case 1: {
                this.max = data.readInt();
            }
        }
        if (this.min > this.max) {
            int i = this.min;
            this.min = this.max;
            this.max = i;
        }
        if (this.cur > this.max) {
            this.cur = this.max;
            this.field_145850_b.func_175685_c(this.field_174879_c, Blocks.field_150429_aA);
        } else if (this.cur < this.min) {
            this.cur = this.min;
            this.field_145850_b.func_175685_c(this.field_174879_c, Blocks.field_150429_aA);
        }
        this.markUpdate();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.min = nbt.func_74762_e("min");
        this.max = nbt.func_74762_e("max");
        this.cur = nbt.func_74762_e("cur");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("min", this.min);
        nbt.func_74768_a("max", this.max);
        nbt.func_74768_a("cur", this.cur);
        return super.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("min", this.min);
        nbt.func_74768_a("max", this.max);
        nbt.func_74768_a("cur", this.cur);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.min = nbt.func_74762_e("min");
        this.max = nbt.func_74762_e("max");
        this.cur = nbt.func_74762_e("cur");
    }

    public byte getRSDirection(EnumFacing s) {
        return 2;
    }
}

