/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone1bit;
import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileEntityData;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class LogicConverter
extends AutomatedTile
implements IRedstone8bit,
IRedstone1bit {
    private byte state;
    private boolean update;
    private boolean updateCon;

    public LogicConverter() {
        this.netData = new TileEntityData(1, 0, 0, 0);
    }

    protected void customPlayerCommand(byte cmd, PacketBuffer dis, EntityPlayerMP player) throws IOException {
        if (cmd == 0) {
            this.netData.longs[0] = dis.readLong();
            this.update = true;
            this.updateCon = true;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("cfg", this.netData.longs[0]);
        nbt.func_74774_a("state", this.state);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.netData.longs[0] = nbt.func_74763_f("cfg");
        this.state = nbt.func_74771_c("state");
        this.update = true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateCon) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            this.updateCon = false;
        }
        if (this.update) {
            this.update(0);
        }
    }

    private void update(int recursion) {
        TileEntity te;
        byte d8;
        EnumFacing dir;
        int i;
        byte lstate = this.state;
        this.state = 0;
        for (i = 0; i < 6; ++i) {
            dir = EnumFacing.field_82609_l[i];
            d8 = this.getDirection(i);
            if (d8 >= 0) continue;
            te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
            if (te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) > 0) {
                this.state = (byte)(this.state | ((IRedstone8bit)te).getValue(i ^ 1) & this.getConfig(i));
                continue;
            }
            if ((te == null || !(te instanceof IRedstone1bit) || ((IRedstone1bit)te).getBitDirection(i ^ 1) <= 0 || ((IRedstone1bit)te).getBitValue(i ^ 1) <= 0) && this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir) <= 0) continue;
            this.state = (byte)(this.state | this.getConfig(i));
        }
        if (this.state != lstate) {
            ++recursion;
            for (i = 0; i < 6; ++i) {
                dir = EnumFacing.field_82609_l[i];
                d8 = this.getDirection(i);
                if (d8 <= 0) continue;
                te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                if (te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) < 0) {
                    ((IRedstone8bit)te).setValue(i ^ 1, this.getValue(i), recursion);
                    continue;
                }
                if (te != null && te instanceof IRedstone1bit && ((IRedstone1bit)te).getBitDirection(i ^ 1) < 0) {
                    ((IRedstone1bit)te).setBitValue(i ^ 1, this.getBitValue(i), recursion);
                    continue;
                }
                this.notifyStateChange(this.field_174879_c.func_177972_a(dir), dir.func_176734_d());
            }
        }
        this.update = false;
    }

    private void notifyStateChange(BlockPos pos, EnumFacing except) {
        this.field_145850_b.func_180496_d(pos, this.func_145838_q());
        this.field_145850_b.func_175695_a(pos, this.func_145838_q(), except);
    }

    public int redstoneLevel(int s, boolean str) {
        return (this.netData.longs[0] & 1L << s + 48) == 0L || this.getValue(s) == 0 ? 0 : 15;
    }

    public void onNeighborBlockChange(Block b) {
        this.update = true;
    }

    public byte getValue(int s) {
        return (byte)(this.state & this.getConfig(s));
    }

    public byte getDirection(int s) {
        return (byte)((this.netData.longs[0] & 255L << s * 8) == 0L ? 0 : ((this.netData.longs[0] & 1L << s + 48) == 0L ? -1 : 1));
    }

    public void setValue(int s, byte v, int recursion) {
        if (recursion < 16) {
            this.update(recursion);
        } else {
            this.update = true;
        }
    }

    public byte getBitDirection(int s) {
        return this.getDirection(s);
    }

    public byte getBitValue(int s) {
        return this.getValue(s) != 0 ? (byte)15 : 0;
    }

    public void setBitValue(int s, byte v, int recursion) {
        if (recursion < 16) {
            this.update(recursion);
        } else {
            this.update = true;
        }
    }

    public int getConfig(int s) {
        return (int)(this.netData.longs[0] >> s * 8 & 0xFFL);
    }

    public void setConfig(int s, int v) {
        this.netData.longs[0] = this.netData.longs[0] & (255L << s * 8 ^ 0xFFFFFFFFFFFFFFFFL);
        this.netData.longs[0] = this.netData.longs[0] | (long)(v & 0xFF) << s * 8;
    }
}

