/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.api.computers.ComputerAPI;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.util.Utils;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers")})
public class Lever8bit
extends ModTileEntity
implements IRedstone8bit,
ITickable,
Environment {
    private boolean update;
    public byte state;
    private ArrayList<Object> listeners = new ArrayList();
    private Object node = ComputerAPI.newOCnode((TileEntity)this, (String)"RedstoneCircuits-Out8bit", (boolean)false);

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (!player.func_70093_af() && s.func_176745_a() + 2 == this.func_145832_p()) {
            int i;
            int n = i = Y < 0.5f ? 4 : 0;
            if (s == EnumFacing.SOUTH) {
                i |= (int)Math.floor(X * 4.0f);
            } else if (s == EnumFacing.NORTH) {
                i |= (int)Math.floor((1.0f - X) * 4.0f);
            } else if (s == EnumFacing.WEST) {
                i |= (int)Math.floor(Z * 4.0f);
            } else if (s == EnumFacing.EAST) {
                i |= (int)Math.floor((1.0f - Z) * 4.0f);
            }
            this.state = (byte)(this.state ^ 1 << i);
            this.update = true;
            this.markUpdate();
            return true;
        }
        return false;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.state = pkt.func_148857_g().func_74771_c("state");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("state", this.state);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ComputerAPI.update((TileEntity)this, (Object)this.node, (double)0.0);
        if (this.update) {
            for (int i = 0; i < 6; ++i) {
                TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                if (te == null || !(te instanceof IRedstone8bit) || ((IRedstone8bit)te).getDirection(i ^ 1) >= 0) continue;
                ((IRedstone8bit)te).setValue(i ^ 1, this.state, 1);
            }
            this.updateEvent();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.node != null) {
            ComputerAPI.saveNode((Object)this.node, (NBTTagCompound)nbt);
        }
        nbt.func_74774_a("state", this.state);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null) {
            ComputerAPI.readNode((Object)this.node, (NBTTagCompound)nbt);
        }
        this.state = nbt.func_74771_c("state");
        this.update = true;
    }

    public byte getValue(int s) {
        return this.state;
    }

    public byte getDirection(int s) {
        return 1;
    }

    public void setValue(int s, byte v, int recursion) {
    }

    private void updateEvent() {
        for (Object computer : this.listeners) {
            ComputerAPI.sendEvent((Object)computer, (String)"out8bit", (Object[])new Object[]{this.state});
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
        if (node.host() instanceof Context) {
            this.listeners.add(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            this.listeners.remove(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="", direct=true)
    public Object[] getOutput(Context cont, Arguments args) {
        return new Object[]{this.state};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="", direct=true)
    public Object[] setOutput(Context cont, Arguments args) {
        this.state = (byte)args.checkInteger(0);
        this.update = true;
        this.markUpdate();
        return new Object[0];
    }
}

