/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.ILinkedInventory;
import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileContainer;
import cd4017be.lib.TileEntityData;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.templates.Inventory;
import cd4017be.lib.templates.SlotHolo;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ItemTranslocator
extends AutomatedTile
implements ILinkedInventory,
IRedstone8bit {
    private int[] linkPos = new int[]{0, -1, 0};
    private TileEntity linkObj;
    private byte state;
    private boolean update1 = true;
    private boolean linkUpdate = true;
    private short counter = 0;

    public ItemTranslocator() {
        this.inventory = new Inventory((ModTileEntity)this, 8, new Inventory.Component[0]);
        this.netData = new TileEntityData(4, 9, 0, 0);
        this.netData.ints[8] = 1;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update1) {
            this.output(0);
        }
        if (this.linkUpdate) {
            this.link();
        }
        this.counter = (short)(this.counter + 1);
        if ((this.netData.longs[3] >> 47 & 1L) == 0L) {
            this.counter = 0;
        }
        if (this.counter >= this.netData.ints[8]) {
            this.counter = 0;
            this.update1();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = nbt.func_74771_c("in");
        this.update1 = true;
        int[] data = nbt.func_74759_k("ref");
        System.arraycopy(data, 0, this.netData.ints, 0, Math.min(data.length, this.netData.ints.length));
        this.netData.longs[1] = nbt.func_74763_f("cfg1");
        this.netData.longs[2] = nbt.func_74763_f("cfg2");
        this.netData.longs[3] = nbt.func_74763_f("cfg3");
        this.counter = nbt.func_74765_d("count");
        this.linkUpdate = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("in", this.state);
        nbt.func_74783_a("ref", this.netData.ints);
        nbt.func_74772_a("cfg1", this.netData.longs[1]);
        nbt.func_74772_a("cfg2", this.netData.longs[2]);
        nbt.func_74772_a("cfg3", this.netData.longs[3]);
        nbt.func_74777_a("count", this.counter);
        return super.func_189515_b(nbt);
    }

    protected void customPlayerCommand(byte cmd, PacketBuffer dis, EntityPlayerMP player) throws IOException {
        if (cmd < 8) {
            this.netData.ints[cmd] = dis.readInt();
        } else if (cmd < 16) {
            byte s = dis.readByte();
            if (s >= 0 && s < 4) {
                long p = ((s & 1) == 0 ? cmd - 8 : cmd) * 3;
                int v = s < 2 ? 1 : 2;
                long x = ((this.netData.longs[v] >> (int)p & 7L) + 1L) % 6L;
                this.netData.longs[v] = this.netData.longs[v] & (7L << (int)p ^ 0xFFFFFFFFFFFFFFFFL) | x << (int)p;
            } else if (s >= 4 && s < 8) {
                this.netData.longs[3] = this.netData.longs[3] ^ 1L << (int)((long)(cmd - 8) * 4L + (long)s - 4L);
            }
        } else if (cmd == 16) {
            byte s = dis.readByte();
            if (s < 0 || s >= 6) {
                return;
            }
            long p = 32 + s * 2;
            long x = ((this.netData.longs[3] >> (int)p & 3L) + 1L) % 3L;
            this.netData.longs[3] = this.netData.longs[3] & (3L << (int)p ^ 0xFFFFFFFFFFFFFFFFL) | x << (int)p;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        } else if (cmd == 17) {
            this.netData.ints[8] = dis.readInt();
            if (this.netData.ints[8] < 1) {
                this.netData.ints[8] = 1;
            } else if (this.netData.ints[8] > 1200) {
                this.netData.ints[8] = 1200;
            }
        } else if (cmd == 18) {
            this.netData.longs[3] = this.netData.longs[3] ^ 0x800000000000L;
        } else if (cmd == 19) {
            long p = 44L;
            long x = ((this.netData.longs[3] >> (int)p & 7L) + 1L) % 6L;
            this.netData.longs[3] = this.netData.longs[3] & (7L << (int)p ^ 0xFFFFFFFFFFFFFFFFL) | x << (int)p;
            this.linkUpdate = true;
        }
    }

    public void initContainer(TileContainer container) {
        container.addPlayerInventory(8, 122);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                container.addEntitySlot((Slot)new SlotHolo((IInventory)this, i * 4 + j, 26 + i * 99, 16 + j * 18, false, false));
            }
        }
    }

    private void link() {
        TileEntity last = this.linkObj;
        byte s = (byte)(this.netData.longs[3] >> 44 & 7L);
        TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)s);
        if (te == null || !(te instanceof IInventory)) {
            this.linkPos[1] = -1;
            this.linkObj = null;
        } else if (te instanceof ILinkedInventory) {
            if ((((ILinkedInventory)te).getLinkDir() ^ s) == 1) {
                this.linkObj = null;
                this.linkPos[1] = -1;
            } else {
                this.linkPos = ((ILinkedInventory)te).getLinkPos();
                this.linkObj = this.field_145850_b.func_175625_s(new BlockPos(this.linkPos[0], this.linkPos[1], this.linkPos[2]));
            }
            if (this.linkObj != null && (this.linkObj instanceof ILinkedInventory || !(this.linkObj instanceof IInventory))) {
                this.linkObj = null;
                this.linkPos[1] = -1;
            }
        } else {
            this.linkObj = te;
            this.linkPos = new int[]{te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()};
        }
        if (this.linkObj != last) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
        this.linkUpdate = false;
    }

    private void update1() {
        for (int i = 0; i < 8; ++i) {
            IInventory inv1;
            IInventory inv0;
            TileEntity te;
            boolean neg;
            if (this.netData.ints[i] <= 0 || (this.state >> i & 1) == 0) continue;
            byte mode = this.getMode(i);
            boolean bl = neg = (mode & 1) != 0;
            if (!neg && this.inventory.items[i] == null || (te = Utils.getTileOnSide((ModTileEntity)this, (byte)this.getDir(i))) == null || !(te instanceof IInventory)) continue;
            if (te instanceof ILinkedInventory) {
                inv0 = ((ILinkedInventory)te).getLinkInv();
                if (inv0 == null) {
                    continue;
                }
            } else {
                inv0 = (IInventory)te;
            }
            if ((te = Utils.getTileOnSide((ModTileEntity)this, (byte)this.getDir(i | 0x10))) == null || !(te instanceof IInventory)) continue;
            if (te instanceof ILinkedInventory) {
                inv1 = ((ILinkedInventory)te).getLinkInv();
                if (inv1 == null) {
                    continue;
                }
            } else {
                inv1 = (IInventory)te;
            }
            byte side0 = this.getDir(i | 8);
            byte side1 = this.getDir(i | 0x18);
            int[] slots0 = Utils.accessibleSlots((IInventory)inv0, (int)side0);
            int[] slots1 = Utils.accessibleSlots((IInventory)inv1, (int)side1);
            if (slots0.length == 0 || slots1.length == 0) continue;
            Utils.ItemType filter = new Utils.ItemType((mode & 2) != 0, (mode & 4) != 0, (mode & 8) != 0, new ItemStack[]{this.inventory.items[i]});
            this.transfer(inv0, side0, slots0, inv1, side1, slots1, filter, neg, this.netData.ints[i]);
        }
    }

    private void transfer(IInventory src, int sideS, int[] sS, IInventory dst, int sideD, int[] sD, Utils.ItemType type, boolean neg, int am) {
        ISidedInventory srcS = src instanceof ISidedInventory ? (ISidedInventory)src : null;
        ISidedInventory dstS = dst instanceof ISidedInventory ? (ISidedInventory)dst : null;
        int am0 = am;
        for (int i : sS) {
            ItemStack curItem = src.func_70301_a(i);
            if (curItem == null || !(type.matches(curItem) ^ neg) || srcS != null && !srcS.func_180461_b(i, curItem, EnumFacing.field_82609_l[sideS])) continue;
            int m = Math.min(curItem.func_77976_d(), dst.func_70297_j_());
            int p = -1;
            for (int j : sD) {
                ItemStack stack = dst.func_70301_a(j);
                if (stack == null && p == -1 && (dstS == null || dstS.func_180462_a(j, curItem, EnumFacing.field_82609_l[sideD]))) {
                    p = j;
                    continue;
                }
                if (!Utils.itemsEqual((ItemStack)curItem, (ItemStack)stack) || stack.field_77994_a >= m) continue;
                int n = Math.min(m - stack.field_77994_a, am);
                ItemStack item = src.func_70298_a(i, n);
                if (item == null) break;
                stack.field_77994_a += item.field_77994_a;
                dst.func_70299_a(j, stack);
                if ((am -= item.field_77994_a) <= 0) {
                    src.func_70296_d();
                    dst.func_70296_d();
                    return;
                }
                curItem = src.func_70301_a(i);
                if (curItem == null) break;
            }
            if (p < 0 || curItem == null) continue;
            ItemStack item = src.func_70298_a(i, Math.min(m, am));
            dst.func_70299_a(p, item);
            if (item != null && (am -= item.field_77994_a) <= 0) break;
        }
        if (am < am0) {
            src.func_70296_d();
            dst.func_70296_d();
        }
    }

    private void output(int recursion) {
        TileEntity te;
        byte d8;
        int i;
        byte lstate = this.state;
        this.state = 0;
        for (i = 0; i < 6; ++i) {
            d8 = this.getDirection(i);
            if (d8 > -1) continue;
            te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
            if (d8 >= 0 || te == null || !(te instanceof IRedstone8bit) || ((IRedstone8bit)te).getDirection(i ^ 1) <= 0) continue;
            this.state = (byte)(this.state | ((IRedstone8bit)te).getValue(i ^ 1));
        }
        if (this.state != lstate) {
            ++recursion;
            for (i = 0; i < 6; ++i) {
                d8 = this.getDirection(i);
                if (d8 < 1) continue;
                te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                if (d8 <= 0 || te == null || !(te instanceof IRedstone8bit) || ((IRedstone8bit)te).getDirection(i ^ 1) >= 0) continue;
                ((IRedstone8bit)te).setValue(i ^ 1, this.state, recursion);
            }
        }
        this.update1 = false;
    }

    public byte getDir(int b) {
        return (byte)(this.netData.longs[b >= 16 ? 2 : 1] >> (int)((long)(b % 16 * 3)) & 7L);
    }

    public byte getMode(int b) {
        return (byte)(this.netData.longs[3] >> (int)((long)(b * 4)) & 0xFL);
    }

    public void onNeighborBlockChange(Block b) {
        this.update1 = true;
        this.linkUpdate = true;
    }

    public byte getValue(int s) {
        return this.state;
    }

    public byte getDirection(int s) {
        byte k = (byte)(this.netData.longs[3] >> (int)((long)(32 + s * 2)) & 3L);
        return k > 1 ? (byte)-1 : (byte)k;
    }

    public void setValue(int s, byte v, int recursion) {
        if (recursion < 16) {
            this.output(recursion);
        } else {
            this.update1 = true;
        }
    }

    public int[] getLinkPos() {
        return this.linkPos;
    }

    public IInventory getLinkInv() {
        if (this.linkObj == null) {
            return null;
        }
        if (this.linkObj.func_145837_r()) {
            this.linkUpdate = true;
            return null;
        }
        return (IInventory)this.linkObj;
    }

    public byte getLinkDir() {
        return (byte)(this.netData.longs[3] >> 44 & 7L);
    }

    public ItemStack removeStackFromSlot(int i) {
        return null;
    }
}

