/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.ILinkedInventory;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.IPipe;
import cd4017be.lib.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;

public class InvConnector
extends ModTileEntity
implements ILinkedInventory,
IPipe,
ITickable {
    private boolean linkUpdate = true;
    private BlockPos linkPos = Utils.NOWHERE;
    private TileEntity linkObj;
    private byte conDir;
    private IPipe.Cover cover;

    public void onNeighborBlockChange(Block b) {
        this.linkUpdate = true;
    }

    public void onNeighborTileChange(BlockPos pos) {
        this.linkUpdate = true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.conDir = nbt.func_74771_c("dir");
        this.cover = IPipe.Cover.read((NBTTagCompound)nbt, (String)"cover");
        this.linkUpdate = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("dir", this.conDir);
        if (this.cover != null) {
            this.cover.write(nbt, "cover");
        }
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.linkUpdate) {
            return;
        }
        TileEntity last = this.linkObj;
        TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)this.conDir);
        if (te == null) {
            this.linkPos = Utils.NOWHERE;
            this.linkObj = null;
        } else if (te instanceof ILinkedInventory) {
            if (((ILinkedInventory)te).getLinkDir() == EnumFacing.field_82609_l[this.conDir ^ 1]) {
                this.linkObj = null;
                this.linkPos = Utils.NOWHERE;
            } else {
                this.linkPos = ((ILinkedInventory)te).getLinkPos();
                this.linkObj = this.field_145850_b.func_175625_s(this.linkPos);
                if (this.linkObj instanceof ILinkedInventory) {
                    this.linkObj = null;
                }
                if (this.linkObj == null) {
                    this.linkPos = Utils.NOWHERE;
                }
            }
        } else {
            this.linkObj = te;
            this.linkPos = te.func_174877_v();
        }
        if (this.linkObj != last) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            this.markUpdate();
        }
        this.linkUpdate = false;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (player.func_70093_af() && item == null) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            if (this.cover != null) {
                this.dropStack(this.cover.item);
                this.cover = null;
                this.markUpdate();
                return true;
            }
            if (this.linkObj == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Not Linked!"));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("Linked to %s @ %s", this.field_145850_b.func_180495_p(this.linkPos).func_177230_c().func_149732_F(), this.linkPos.toString())));
            }
            return true;
        }
        if (item == null) {
            if (!this.field_145850_b.field_72995_K) {
                this.connect();
            }
            return true;
        }
        if (!player.func_70093_af() && this.cover == null && item != null && (this.cover = IPipe.Cover.create((ItemStack)item)) != null) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            --item.field_77994_a;
            if (item.field_77994_a <= 0) {
                item = null;
            }
            player.func_184611_a(hand, item);
            this.markUpdate();
            return true;
        }
        return false;
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        this.connect();
    }

    private void connect() {
        for (int i = 1; i < 6; ++i) {
            byte d = (byte)((this.conDir + i) % 6);
            if (Utils.getTileOnSide((ModTileEntity)this, (byte)d) == null) continue;
            this.conDir = d;
            this.markUpdate();
            this.linkUpdate = true;
            return;
        }
    }

    public int textureForSide(byte s) {
        if (s == -1) {
            return 0;
        }
        if (s == this.conDir) {
            return this.linkPos.func_177956_o() >= 0 ? 2 : 1;
        }
        TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)s);
        return te != null && te instanceof ILinkedInventory && ((ILinkedInventory)te).getLinkDir() == EnumFacing.field_82609_l[s ^ 1] ? 0 : -1;
    }

    public IPipe.Cover getCover() {
        return this.cover;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.conDir = pkt.func_148857_g().func_74771_c("dir");
        this.linkPos = pkt.func_148857_g().func_74767_n("link") ? new BlockPos(0, 0, 0) : new BlockPos(0, -1, 0);
        this.cover = IPipe.Cover.read((NBTTagCompound)pkt.func_148857_g(), (String)"cover");
        this.markUpdate();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("dir", (short)this.conDir);
        nbt.func_74757_a("link", this.linkPos.func_177956_o() >= 0);
        if (this.cover != null) {
            this.cover.write(nbt, "cover");
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void breakBlock() {
        if (this.cover != null) {
            EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.cover.item);
            this.cover = null;
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    public BlockPos getLinkPos() {
        return this.linkPos;
    }

    public EnumFacing getLinkDir() {
        return EnumFacing.field_82609_l[this.conDir];
    }

    public TileEntity getLinkObj() {
        return this.linkObj;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing s) {
        return this.linkObj == null ? false : this.linkObj.hasCapability(cap, s);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing s) {
        return (T)(this.linkObj == null ? null : this.linkObj.getCapability(cap, s));
    }
}

