/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.ModTileEntity;
import cofh.api.energy.IEnergyReceiver;
import java.io.IOException;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class EnergyValve
extends ModTileEntity
implements ITickable,
IDirectionalRedstone,
DataContainer.IGuiData,
IEnergyReceiver {
    public static final Capability<?> TeslaConsumer = Loader.isModLoaded((String)"Tesla") ? TeslaCapabilities.CAPABILITY_CONSUMER : null;
    private TileEntity out;
    public int tickInt = 1;
    public boolean measure;
    public boolean update;
    public int flow;
    public int state;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update) {
            EnumFacing dir = EnumFacing.field_82609_l[this.getOrientation()];
            this.out = this.getLoadedTile(this.field_174879_c.func_177972_a(dir.func_176734_d()));
        }
        if (this.field_145850_b.func_82737_E() % (long)this.tickInt != 0L) {
            return;
        }
        if (this.measure) {
            this.flow = Integer.MAX_VALUE - this.flow;
            if (this.flow != this.state) {
                this.state = this.flow;
                this.field_145850_b.func_175685_c(this.field_174879_c, Blocks.field_150429_aA);
            }
            this.flow = Integer.MAX_VALUE;
        } else {
            this.flow = this.state > 0 ? this.state : 0;
        }
    }

    public void onNeighborBlockChange(Block b) {
        if (this.field_145850_b.field_72995_K || this.measure) {
            return;
        }
        this.state = 0;
        for (EnumFacing s : EnumFacing.field_82609_l) {
            this.state |= this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(s), s);
        }
    }

    public void onNeighborTileChange(BlockPos pos) {
        this.update = true;
    }

    public int redstoneLevel(int s, boolean str) {
        return str || !this.measure ? 0 : this.state;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.flow = nbt.func_74762_e("flow");
        this.state = nbt.func_74762_e("state");
        this.tickInt = nbt.func_74762_e("tickInt");
        this.measure = nbt.func_74767_n("measure");
        this.update = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("flow", this.flow);
        nbt.func_74768_a("state", this.state);
        nbt.func_74768_a("tickInt", this.tickInt);
        nbt.func_74757_a("measure", this.measure);
        return super.func_189515_b(nbt);
    }

    public void onPlayerCommand(PacketBuffer data, EntityPlayerMP player) throws IOException {
        byte cmd = data.readByte();
        if (cmd == 0) {
            this.tickInt = data.readInt();
            if (this.tickInt < 1) {
                this.tickInt = 1;
            } else if (this.tickInt > 1200) {
                this.tickInt = 1200;
            }
        } else if (cmd == 1) {
            boolean bl = this.measure = !this.measure;
            if (this.measure) {
                this.flow = 0;
            } else {
                this.onNeighborBlockChange(null);
            }
        }
    }

    public int[] getSyncVariables() {
        return new int[]{this.flow, this.state, this.tickInt, this.measure ? 1 : 0};
    }

    public void setSyncVariable(int i, int v) {
        switch (i) {
            case 0: {
                this.flow = v;
                break;
            }
            case 1: {
                this.state = v;
                break;
            }
            case 2: {
                this.tickInt = v;
                break;
            }
            case 3: {
                this.measure = v != 0;
            }
        }
    }

    public byte getRSDirection(EnumFacing s) {
        return this.measure ? (byte)2 : 1;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == null && cap == TeslaConsumer && facing != null && facing.ordinal() == this.getOrientation();
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap != null && cap == TeslaConsumer && facing != null && facing.ordinal() == this.getOrientation()) {
            return (T)this.getTeslaConsumer();
        }
        return null;
    }

    @Optional.Method(modid="Tesla")
    private ITeslaConsumer getTeslaConsumer() {
        return (am, sim) -> {
            if (am > (long)this.flow) {
                am = this.flow;
            }
            if (am > 0L && this.out != null && !this.out.func_145837_r()) {
                ITeslaConsumer acc = (ITeslaConsumer)this.out.getCapability(TeslaConsumer, EnumFacing.field_82609_l[this.getOrientation()]);
                if (acc == null) {
                    return 0L;
                }
                am = acc.givePower(am, sim);
                if (!sim) {
                    this.flow = (int)((long)this.flow - am);
                }
                return am;
            }
            return 0L;
        };
    }

    public boolean canConnectEnergy(EnumFacing from) {
        byte dir = this.getOrientation();
        return from.ordinal() == dir || from.ordinal() == (dir ^ 1);
    }

    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return 0;
    }

    public int receiveEnergy(EnumFacing from, int am, boolean sim) {
        if (from.ordinal() == this.getOrientation()) {
            if (am > this.flow) {
                am = this.flow;
            }
            if (am > 0 && this.out != null && !this.out.func_145837_r() && this.out instanceof IEnergyReceiver) {
                am = ((IEnergyReceiver)this.out).receiveEnergy(from, am, sim);
                if (!sim) {
                    this.flow -= am;
                }
                return am;
            }
            return 0;
        }
        return 0;
    }
}

