/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.circuits.Objects;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.LinkedInventory;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class CircuitDesigner
extends ModTileEntity
implements DataContainer.IGuiData {
    public ItemStack dataItem;
    private GameProfile lastPlayer;
    public Module module0 = null;
    public Module moduleL = null;
    public Module selMod = null;
    public ArrayList<Module> outputs;
    public long modified = 1L;
    public boolean renderAll;
    public boolean mode;
    ByteBuf data = Unpooled.buffer();
    public String name = "";

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.writeNBT(nbt);
        return super.func_189515_b(nbt);
    }

    private NBTTagCompound writeNBT(NBTTagCompound nbt) {
        byte[] b = new byte[this.data.readableBytes()];
        this.data.readBytes(b);
        this.data.resetReaderIndex();
        nbt.func_74773_a("data", b);
        nbt.func_74778_a("name", this.name);
        return nbt;
    }

    private void readNBT(NBTTagCompound nbt) {
        this.data.clear();
        byte[] b = nbt.func_74770_j("data");
        this.data.writeBytes(b);
        this.name = nbt.func_74779_i("name");
    }

    public void onPlayerCommand(PacketBuffer dis, EntityPlayerMP player) throws IOException {
        byte cmd = dis.readByte();
        if (cmd == 0) {
            this.data.clear();
            this.data.writeBytes((ByteBuf)dis);
            this.lastPlayer = player.func_146103_bH();
            this.modify();
        } else if (cmd == 1) {
            if (this.dataItem != null && this.dataItem.func_77973_b() == Objects.circuitPlan) {
                this.dataItem.func_77982_d(this.writeNBT(new NBTTagCompound()));
            }
        } else if (cmd == 2) {
            if (this.dataItem != null && this.dataItem.func_77973_b() == Objects.circuitPlan && this.dataItem.func_77942_o()) {
                this.readNBT(this.dataItem.func_77978_p());
            } else {
                this.data.clear();
                this.data.writeByte(0).writeByte(0);
                this.name = "";
            }
            this.modify();
            this.lastPlayer = null;
        } else if (cmd == 3) {
            this.name = dis.func_150789_c(16);
        }
    }

    public void initContainer(DataContainer container) {
        TileContainer cont = (TileContainer)container;
        cont.addItemSlot((Slot)new SlotItemHandler((IItemHandler)new LinkedInventory(1, i -> this.dataItem, (item, i) -> {
            this.dataItem = item;
        }), 0, 194, 220));
        cont.addPlayerInventory(8, 162);
        if (this.field_145850_b.field_72995_K) {
            this.modified = 0L;
            if (this.outputs == null) {
                this.outputs = new ArrayList(6);
            }
        } else {
            cont.extraRef = new LastState();
            if (this.lastPlayer != null && this.lastPlayer.equals((Object)container.player.func_146103_bH())) {
                this.lastPlayer = null;
            }
        }
    }

    public boolean detectAndSendChanges(DataContainer cont, PacketBuffer dos) {
        LastState ls = (LastState)cont.extraRef;
        int chng = 0;
        int p = dos.writerIndex();
        dos.writeByte(chng);
        if (!(this.modified <= ls.edited || this.lastPlayer != null && this.lastPlayer.equals((Object)cont.player.func_146103_bH()))) {
            chng |= 1;
            dos.writeBytes(this.data, 0, this.data.writerIndex());
            ls.edited = this.modified;
        }
        if (!this.name.equals(ls.name)) {
            chng |= 2;
            dos.func_180714_a(this.name);
            ls.name = this.name;
        }
        if (this.renderAll != ls.drawAll) {
            chng |= this.renderAll ? 8 : 4;
            ls.drawAll = this.renderAll;
        }
        if (this.mode != ls.output) {
            chng |= this.mode ? 32 : 16;
            ls.output = this.mode;
        }
        if (chng == 0) {
            return false;
        }
        dos.setByte(p, chng);
        return true;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
        byte chng = dis.readByte();
        if ((chng & 1) != 0) {
            this.deserialize((ByteBuf)dis);
            this.fixCons();
            this.modified = 0L;
        }
        if ((chng & 2) != 0) {
            this.name = dis.func_150789_c(16);
        }
        if ((chng & 0xC) != 0) {
            boolean bl = this.renderAll = (chng & 8) != 0;
        }
        if ((chng & 0x30) != 0) {
            this.mode = (chng & 0x20) != 0;
        }
    }

    public ByteBuf serialize() {
        byte[] b;
        ByteBuf dos = Unpooled.buffer();
        int n = 0;
        int p = dos.writerIndex();
        dos.writeByte(n);
        int pnp = 0;
        Module m = this.module0;
        while (m != null) {
            if (m.pos > pnp) {
                dos.writeByte(-1);
                dos.writeByte(m.pos - pnp);
                ++n;
            }
            int t = m.type.ordinal();
            dos.writeByte(t);
            if (t < 6) {
                int l = 0;
                int q = dos.writerIndex();
                dos.writeByte(l);
                for (Con c : m.cons) {
                    if (c == null) continue;
                    dos.writeByte(c.getAddr());
                    ++l;
                }
                dos.setByte(q, l);
            } else {
                if (t >= 10) {
                    dos.writeByte(m.size);
                }
                for (int i = 0; i < m.cons.length; ++i) {
                    Con c = m.cons[i];
                    if (!m.type.conType(i)) {
                        dos.writeByte(c == null ? m.pos : c.getAddr());
                        continue;
                    }
                    if (c == null || c.type == 1) {
                        dos.writeByte(-1);
                        dos.writeInt(c == null ? 0 : c.size);
                        continue;
                    }
                    dos.writeByte(c.size / 8 - 1 | (c.type == 3 ? 4 : 0));
                    dos.writeByte(c.getAddr());
                }
            }
            b = m.label.getBytes();
            dos.writeByte(b.length);
            dos.writeBytes(b);
            pnp = m.nextPos;
            ++n;
            m = m.next;
        }
        dos.setByte(p, n);
        dos.writeByte(this.outputs.size());
        for (Module m2 : this.outputs) {
            dos.writeByte(m2.pos);
            dos.writeByte(m2.size);
            b = m2.label.getBytes();
            dos.writeByte(b.length);
            dos.writeBytes(b);
        }
        return dos;
    }

    public void deserialize(ByteBuf dis) {
        byte[] b;
        Module m;
        int n;
        this.module0 = null;
        this.moduleL = null;
        this.selMod = null;
        this.outputs.clear();
        Module k = null;
        int p = 0;
        for (n = dis.readByte() & 0xFF; n > 0; --n) {
            byte t = dis.readByte();
            if (t < 0 || t > 17) {
                p += dis.readByte() & 0xFF;
                continue;
            }
            m = new Module(ModuleType.values()[t]);
            if (t < 6) {
                int l = dis.readByte();
                for (int i = 0; i < l; ++i) {
                    m.cons[i] = new Con(null, dis.readByte() & 0xFF, 1, 0);
                }
            } else {
                if (t >= 10) {
                    m.size = dis.readByte();
                }
                for (int i = 0; i < m.cons.length; ++i) {
                    byte ct;
                    m.cons[i] = !m.type.conType(i) ? new Con(null, dis.readByte() & 0xFF, 1, 0) : ((ct = dis.readByte()) < 0 ? new Con(null, -1, dis.readInt(), 1) : new Con(null, dis.readByte() & 0xFF, 8 + 8 * (ct & 3), (byte)(2 + (ct >> 2))));
                }
            }
            m.setPos(p);
            p = m.nextPos;
            b = new byte[dis.readByte()];
            dis.readBytes(b);
            m.label = new String(b);
            if (k == null) {
                this.module0 = this.moduleL = m;
            } else {
                k.insert(m);
            }
            k = m;
        }
        for (n = dis.readByte() & 7; n > 0; --n) {
            int pos = dis.readByte() & 0xFF;
            m = new Module(ModuleType.IN);
            m.size = dis.readByte();
            m.setPos(pos);
            b = new byte[dis.readByte()];
            dis.readBytes(b);
            m.label = new String(b);
            this.outputs.add(m);
        }
    }

    public void fixCons() {
        Module m = this.module0;
        while (m != null) {
            for (Con c : m.cons) {
                if (c == null || c.type == 1) continue;
                c.mod = this.find(m, c.addr, false);
                if (c.mod == null) continue;
                c.addr -= c.mod.pos;
            }
            m = m.next;
        }
    }

    public void modify() {
        ++this.modified;
    }

    public void add(ModuleType t) {
        if (this.mode) {
            if (this.outputs.size() >= 6) {
                return;
            }
            int p = this.selMod == null ? 0 : this.selMod.nextPos;
            this.selMod = new Module(t);
            this.selMod.setPos(p);
            this.outputs.add(this.selMod);
        } else {
            Module tgt = this.selMod == null ? this.moduleL : this.selMod;
            this.selMod = new Module(t);
            if (tgt == null) {
                this.module0 = this.moduleL = this.selMod;
            } else {
                tgt.insert(this.selMod);
            }
        }
        ++this.modified;
    }

    public void move(Module m, int pos) {
        if (this.mode) {
            m.setPos(pos);
        } else {
            Module m1 = this.find(m, pos, true);
            if (m1 != m) {
                this.remove(m);
                m.setPos(pos);
                if (m1 != null) {
                    m1.insert(m);
                } else {
                    this.insertPre(m);
                }
            } else {
                m.setPos(pos);
            }
        }
        ++this.modified;
    }

    void insertPre(Module m) {
        if (this.module0 == null) {
            this.module0 = this.moduleL = m;
        } else {
            this.module0.prev = m;
            m.next = this.module0;
            this.module0 = m;
            if (m.nextPos > m.next.pos) {
                m.next.setPos(m.nextPos);
            }
        }
    }

    public Module find(Module m, int mp, boolean closest) {
        if (m == null) {
            return null;
        }
        if (mp >= m.nextPos) {
            m = m.next;
            while (m != null) {
                if (m.pos > mp) {
                    return closest ? m.prev : null;
                }
                if (m.nextPos > mp) {
                    return m;
                }
                m = m.next;
            }
            return closest ? this.moduleL : null;
        }
        if (mp < m.pos) {
            m = m.prev;
            while (m != null) {
                if (m.nextPos <= mp) {
                    return closest ? m : null;
                }
                if (m.pos <= mp) {
                    return m;
                }
                m = m.prev;
            }
            return null;
        }
        return m;
    }

    public void remove(Module m) {
        if (this.mode) {
            this.outputs.remove(m);
        } else {
            if (m.prev != null) {
                m.prev.next = m.next;
            } else {
                this.module0 = m.next;
            }
            if (m.next != null) {
                m.next.prev = m.prev;
            } else {
                this.moduleL = m.prev;
            }
            m.prev = null;
            m.next = null;
        }
    }

    public static class LastState {
        String name;
        boolean drawAll;
        boolean output;
        long edited;
    }

    public static enum ModuleType {
        OR(0, 8),
        NOR(0, 8),
        AND(0, 8),
        NAND(0, 8),
        XOR(0, 8),
        XNOR(0, 8),
        LS(0, 2){

            @Override
            public boolean conType(int i) {
                return true;
            }
        }
        ,
        NLS(0, 2){

            @Override
            public boolean conType(int i) {
                return true;
            }
        }
        ,
        EQ(0, 2){

            @Override
            public boolean conType(int i) {
                return true;
            }
        }
        ,
        NEQ(0, 2){

            @Override
            public boolean conType(int i) {
                return true;
            }
        }
        ,
        COUNT(1, 4){

            @Override
            public boolean conType(int i) {
                return i >= 2;
            }
        }
        ,
        SWITCH(5, 3){

            @Override
            public boolean conType(int i) {
                return i > 0;
            }
        }
        ,
        ADD(8, 2),
        SUB(8, 2),
        MUL(8, 2),
        DIV(8, 2),
        MOD(8, 2),
        IN(0, 0);

        public final int defCon;
        public final int idxLoc;

        private ModuleType(int b, int n2) {
            this.defCon = n2;
            this.idxLoc = b;
        }

        public boolean conType(int i) {
            return this.idxLoc > 0;
        }
    }

    public class Module {
        public final Con[] cons;
        public final ModuleType type;
        public int pos;
        public int nextPos;
        public int size;
        public int selCon;
        public Module next;
        public Module prev;
        public String label = "";

        public Module(ModuleType type) {
            this.type = type;
            this.size = type.idxLoc > 0 ? 8 : 1;
            this.cons = new Con[type.defCon];
            for (int i = 0; i < type.defCon; ++i) {
                if (!type.conType(i)) continue;
                this.cons[i] = new Con(null, -1, 0, 1);
            }
            this.nextPos = this.size;
        }

        public void setPos(int pos) {
            int n = pos = (pos & 7) + this.size > 8 ? pos + 7 & 0xF8 : pos;
            if (pos != this.pos || pos + this.size != this.nextPos) {
                this.pos = pos;
                this.nextPos = pos + this.size;
                if (this.nextPos > 256 && this.prev != null) {
                    this.prev.next = null;
                    CircuitDesigner.this.moduleL = this.prev;
                    this.next = null;
                    this.prev = null;
                } else if (this.next != null && this.nextPos > this.next.pos) {
                    this.next.setPos(this.nextPos);
                }
            }
        }

        public void resize(int s) {
            this.size = s;
            this.setPos(this.pos);
        }

        public void insert(Module m) {
            m.next = this.next;
            if (this.next != null) {
                this.next.prev = m;
            } else {
                CircuitDesigner.this.moduleL = m;
            }
            this.next = m;
            m.prev = this;
            if (this.nextPos > m.pos) {
                m.setPos(this.nextPos);
            } else if (m.next != null && m.nextPos > m.next.pos) {
                m.next.setPos(m.nextPos);
            }
        }
    }

    public static class Con {
        public Module mod;
        public int addr;
        public int size;
        public byte type;

        public Con(Module m, int ad, int s, byte t) {
            this.mod = m;
            this.addr = ad;
            this.size = s;
            this.type = t;
        }

        public int getAddr() {
            return this.mod != null ? this.mod.pos + this.addr : this.addr;
        }
    }
}

