/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.api.circuits.IQuickRedstoneHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.ModTileEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class Circuit
extends ModTileEntity
implements IDirectionalRedstone,
DataContainer.IGuiData,
ITickable,
IQuickRedstoneHandler {
    public static final int[] ClockSpeed = new int[]{20, 5, 1};
    public static final byte C_NULL = 0;
    public static final byte C_IN = 16;
    public static final byte C_OR = 32;
    public static final byte C_NOR = 48;
    public static final byte C_AND = 64;
    public static final byte C_NAND = 80;
    public static final byte C_XOR = 96;
    public static final byte C_XNOR = 112;
    public static final byte C_COMP = -128;
    public static final byte C_COMP_1 = -127;
    public static final byte C_COMP_2 = -126;
    public static final byte C_COMP_3 = -125;
    public static final byte C_CNT = -112;
    public static final byte C_MUX = -96;
    public static final byte C_ADD = -80;
    public static final byte C_SUB = -64;
    public static final byte C_MUL = -48;
    public static final byte C_DIV = -32;
    public static final byte C_MOD = -16;
    public String name = "";
    public int var;
    public final IOacc[] ioacc = new IOacc[6];
    public IOcfg[] iocfg = new IOcfg[0];
    public byte[] ram = new byte[0];
    public int tickInt = ClockSpeed[0];
    private long nextUpdate = 0L;
    public byte mode = 0;
    public byte memoryOfs;
    public int startIdx;

    public String getName() {
        return this.name.length() > 0 ? "\"" + this.name + "\"" : super.getName();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.mode == 0 || this.ram.length == 0) {
            return;
        }
        long t = this.field_145850_b.func_82737_E();
        if (t == this.nextUpdate) {
            if (this.mode == 1) {
                this.nextUpdate += (long)this.tickInt;
            } else if (this.mode == 3) {
                ++this.nextUpdate;
                this.mode = (byte)7;
            } else {
                --this.nextUpdate;
                this.mode = (byte)(this.mode & 3);
            }
            try {
                int[] out = this.cpuTick();
                for (IOacc acc : this.ioacc) {
                    if (acc == null) continue;
                    acc.update(out[acc.side.ordinal()]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.ram = new byte[0];
                this.name = "\u00ef\u00bf\u00bdcERROR: invalid code!\u00ef\u00bf\u00bd8";
            }
        }
    }

    private int[] cpuTick() {
        int m = 0;
        int n = 0;
        block33: for (int i = this.startIdx; i < this.ram.length; ++i) {
            int x;
            byte cmd = this.ram[i];
            int con = cmd & 0xF;
            int p = n >> 3;
            cmd = (byte)(cmd & 0xF0);
            switch (cmd) {
                case 0: {
                    n += con + 1;
                    continue block33;
                }
                case 16: {
                    IOcfg cfg = this.iocfg[m++];
                    x = this.ioacc[cfg.side].stateI >> cfg.ofs;
                    if (cfg.size >= 8) break;
                    int f = n & 7;
                    int mask = 255 >> 8 - cfg.size << f;
                    this.ram[p] = (byte)(this.ram[p] & ~mask | (x <<= f) & mask);
                    n += cfg.size;
                    continue block33;
                }
                case 32: {
                    int j = i;
                    i += con;
                    boolean s = true;
                    while (s && j < i) {
                        s = !this.getBit(++j);
                    }
                    int mask = 1 << (n & 7);
                    if (s) {
                        int n2 = p;
                        this.ram[n2] = (byte)(this.ram[n2] & ~mask);
                    } else {
                        int n3 = p;
                        this.ram[n3] = (byte)(this.ram[n3] | mask);
                    }
                    ++n;
                    continue block33;
                }
                case 48: {
                    int j = i;
                    i += con;
                    boolean s = true;
                    while (s && j < i) {
                        s = !this.getBit(++j);
                    }
                    int mask = 1 << (n & 7);
                    if (s) {
                        int n4 = p;
                        this.ram[n4] = (byte)(this.ram[n4] | mask);
                    } else {
                        int n5 = p;
                        this.ram[n5] = (byte)(this.ram[n5] & ~mask);
                    }
                    ++n;
                    continue block33;
                }
                case 64: {
                    int j = i;
                    i += con;
                    boolean s = true;
                    while (s && j < i) {
                        s = this.getBit(++j);
                    }
                    int mask = 1 << (n & 7);
                    if (s) {
                        int n6 = p;
                        this.ram[n6] = (byte)(this.ram[n6] | mask);
                    } else {
                        int n7 = p;
                        this.ram[n7] = (byte)(this.ram[n7] & ~mask);
                    }
                    ++n;
                    continue block33;
                }
                case 80: {
                    int j = i;
                    i += con;
                    boolean s = true;
                    while (s && j < i) {
                        s = this.getBit(++j);
                    }
                    int mask = 1 << (n & 7);
                    if (s) {
                        int n8 = p;
                        this.ram[n8] = (byte)(this.ram[n8] & ~mask);
                    } else {
                        int n9 = p;
                        this.ram[n9] = (byte)(this.ram[n9] | mask);
                    }
                    ++n;
                    continue block33;
                }
                case 96: {
                    int j = i;
                    i += con;
                    boolean s = false;
                    while (j < i) {
                        s ^= this.getBit(++j);
                    }
                    int mask = 1 << (n & 7);
                    if (s) {
                        int n10 = p;
                        this.ram[n10] = (byte)(this.ram[n10] | mask);
                    } else {
                        int n11 = p;
                        this.ram[n11] = (byte)(this.ram[n11] & ~mask);
                    }
                    ++n;
                    continue block33;
                }
                case 112: {
                    int j = i;
                    i += con;
                    boolean s = false;
                    while (j < i) {
                        s ^= this.getBit(++j);
                    }
                    int mask = 1 << (n & 7);
                    if (s) {
                        int n12 = p;
                        this.ram[n12] = (byte)(this.ram[n12] & ~mask);
                    } else {
                        int n13 = p;
                        this.ram[n13] = (byte)(this.ram[n13] | mask);
                    }
                    ++n;
                    continue block33;
                }
                case -128: {
                    boolean s;
                    int a = this.param(this.ram[++i], con >> 2);
                    int b = this.param(this.ram[++i], con >> 3);
                    switch (con & 3) {
                        case 0: {
                            s = a < b;
                            break;
                        }
                        case 1: {
                            s = a >= b;
                            break;
                        }
                        case 2: {
                            s = a == b;
                            break;
                        }
                        default: {
                            s = a != b;
                        }
                    }
                    int mask = 1 << (n & 7);
                    if (s) {
                        int n14 = p;
                        this.ram[n14] = (byte)(this.ram[n14] | mask);
                    } else {
                        int n15 = p;
                        this.ram[n15] = (byte)(this.ram[n15] & ~mask);
                    }
                    ++n;
                    continue block33;
                }
                case -112: {
                    if (this.getBit((i += 4) - 2)) {
                        x = this.param(this.ram[i], con >> 3);
                        break;
                    }
                    if (this.getBit(i - 3)) {
                        x = this.param(p | (con & 3) << 6, 0) + this.param(this.ram[i - 1], con >> 2);
                        break;
                    }
                    n += (con & 3) * 8 + 8;
                    continue block33;
                }
                case -96: {
                    x = this.getBit(++i) ? this.param(this.ram[i + 2], con >> 3) : this.param(this.ram[i + 1], con >> 2);
                    i += 2;
                    break;
                }
                case -80: {
                    x = this.param(this.ram[++i], con >> 2) + this.param(this.ram[++i], con >> 3);
                    break;
                }
                case -64: {
                    x = this.param(this.ram[++i], con >> 2) - this.param(this.ram[++i], con >> 3);
                    break;
                }
                case -48: {
                    x = this.param(this.ram[++i], con >> 2) * this.param(this.ram[++i], con >> 3);
                    break;
                }
                case -32: {
                    int a = this.param(this.ram[++i], con >> 2);
                    int b = this.param(this.ram[++i], con >> 3);
                    x = b == 0 ? -1 : a / b;
                    break;
                }
                case -16: {
                    int a = this.param(this.ram[++i], con >> 2);
                    int b = this.param(this.ram[++i], con >> 3);
                    x = b == 0 ? -1 : a % b;
                    break;
                }
                default: {
                    continue block33;
                }
            }
            n += (con &= 3) * 8 + 8;
            switch (con) {
                case 3: {
                    this.ram[p + 3] = (byte)(x >> 24);
                }
                case 2: {
                    this.ram[p + 2] = (byte)(x >> 16);
                }
                case 1: {
                    this.ram[p + 1] = (byte)(x >> 8);
                }
            }
            this.ram[p] = (byte)x;
        }
        int[] rsOut = new int[6];
        while (m < this.iocfg.length) {
            int x;
            IOcfg cfg = this.iocfg[m++];
            int p = cfg.addr >> 3 & 0x1F;
            if (cfg.size < 8) {
                x = this.ram[p] >> (cfg.addr & 7);
                x &= 255 >> 8 - cfg.size;
            } else {
                x = 0;
                switch (cfg.size) {
                    case 32: {
                        x |= this.ram[p + 3] << 24;
                    }
                    case 24: {
                        x |= (this.ram[p + 2] & 0xFF) << 16;
                    }
                    case 16: {
                        x |= (this.ram[p + 1] & 0xFF) << 8;
                    }
                }
                x |= this.ram[p] & 0xFF;
            }
            byte by = cfg.side;
            rsOut[by] = rsOut[by] | x << cfg.ofs;
        }
        return rsOut;
    }

    private boolean getBit(int i) {
        int p = this.ram[i] & 0xFF;
        return (this.ram[p >> 3 & 0x1F] & 1 << (p & 7)) != 0;
    }

    private int param(int p, int sign) {
        int t = p & 0x3F;
        switch ((p |= sign << 8) & 0x1C0) {
            case 0: {
                return this.ram[t] & 0xFF;
            }
            case 64: {
                return this.ram[t++] & 0xFF | (this.ram[t] & 0xFF) << 8;
            }
            case 128: {
                return this.ram[t++] & 0xFF | (this.ram[t++] & 0xFF) << 8 | (this.ram[t] & 0xFF) << 16;
            }
            case 256: {
                return this.ram[t];
            }
            case 320: {
                return this.ram[t++] & 0xFF | this.ram[t] << 8;
            }
            case 384: {
                return this.ram[t++] & 0xFF | (this.ram[t++] & 0xFF) << 8 | this.ram[t] << 16;
            }
        }
        return this.ram[t++] & 0xFF | (this.ram[t++] & 0xFF) << 8 | (this.ram[t++] & 0xFF) << 16 | this.ram[t] << 24;
    }

    public void onPlayerCommand(PacketBuffer data, EntityPlayerMP player) {
        int i;
        byte cmd = data.readByte();
        if (cmd == 0) {
            byte ofs;
            IOcfg cfg = this.iocfg[data.readByte()];
            byte side = data.readByte();
            if (side != cfg.side) {
                int dir = 0;
                byte prev = cfg.side;
                cfg.side = side;
                for (IOcfg c : this.iocfg) {
                    if (c.side != prev) continue;
                    dir = (byte)(dir | (c.dir ? 2 : 1));
                }
                if (dir == 0) {
                    this.ioacc[prev] = null;
                } else {
                    this.ioacc[prev].dir = (byte)(this.ioacc[prev].dir & (dir | 4));
                }
                IOacc acc = this.ioacc[side];
                if (acc == null) {
                    this.ioacc[side] = acc = new IOacc(side);
                }
                acc.dir = (byte)(acc.dir | (cfg.dir ? 2 : 1));
            }
            cfg.ofs = (ofs = data.readByte()) < 0 ? (byte)0 : (ofs > 32 - cfg.size ? (byte)(32 - cfg.size) : ofs);
        } else if (cmd == 1) {
            this.mode = (byte)(data.readByte() & 3);
            if (this.mode == 1) {
                long t = this.field_145850_b.func_82737_E();
                this.nextUpdate = t + (long)this.tickInt - t % (long)this.tickInt;
            }
        } else if (cmd == 2) {
            int min = ClockSpeed[this.func_145832_p() % ClockSpeed.length];
            this.tickInt = data.readInt();
            if (this.tickInt < min) {
                this.tickInt = min;
            } else if (this.tickInt > 1200) {
                this.tickInt = 1200;
            }
            if (this.mode == 1) {
                long t = this.field_145850_b.func_82737_E();
                this.nextUpdate = t + (long)this.tickInt - t % (long)this.tickInt;
            }
        } else if (cmd == 3) {
            Arrays.fill(this.ram, 0, (int)this.memoryOfs, (byte)0);
        } else if (cmd == 4 && (i = data.readByte() & 0xFF) < this.startIdx) {
            int n = i >> 3;
            this.ram[n] = (byte)(this.ram[n] ^ 1 << (i & 7));
        }
    }

    private NBTTagCompound write(NBTTagCompound nbt) {
        nbt.func_74774_a("IO", (byte)this.var);
        nbt.func_74774_a("Cap", (byte)(this.var >> 8));
        nbt.func_74774_a("Gate", (byte)(this.var >> 16));
        nbt.func_74774_a("Calc", (byte)(this.var >> 24));
        nbt.func_74773_a("data", Arrays.copyOf(this.ram, this.ram.length));
        nbt.func_74778_a("name", this.name);
        NBTTagList list = new NBTTagList();
        for (IOcfg cfg : this.iocfg) {
            list.func_74742_a((NBTBase)cfg.write());
        }
        nbt.func_74782_a("io", (NBTBase)list);
        nbt.func_74774_a("ofs", this.memoryOfs);
        return nbt;
    }

    private void read(NBTTagCompound nbt) {
        this.var = nbt.func_74771_c("IO") & 0xFF | (nbt.func_74771_c("Cap") & 0xFF) << 8 | (nbt.func_74771_c("Gate") & 0xFF) << 16 | (nbt.func_74771_c("Calc") & 0xFF) << 24 | nbt.func_74762_e("var");
        this.ram = nbt.func_74770_j("data");
        this.name = nbt.func_74779_i("name");
        NBTTagList list = nbt.func_150295_c("io", 10);
        Arrays.fill(this.ioacc, null);
        this.iocfg = new IOcfg[list.func_74745_c()];
        for (int i = 0; i < this.iocfg.length; ++i) {
            IOcfg cfg;
            this.iocfg[i] = cfg = new IOcfg(list.func_150305_b(i));
            IOacc acc = this.ioacc[cfg.side];
            if (acc == null) {
                this.ioacc[cfg.side] = acc = new IOacc(cfg.side);
            }
            acc.dir = (byte)(acc.dir | (cfg.dir ? 2 : 1));
        }
        this.memoryOfs = nbt.func_74771_c("ofs");
        this.startIdx = Math.min(this.var >> 8 & 0xFF, this.ram.length);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.write(nbt);
        int[] cache = new int[12];
        for (IOacc acc : this.ioacc) {
            if (acc == null) continue;
            int i = acc.side.ordinal() * 2;
            cache[i] = acc.stateI;
            cache[i + 1] = acc.stateO;
        }
        nbt.func_74783_a("out", cache);
        nbt.func_74774_a("mode", this.mode);
        nbt.func_74768_a("tick", this.tickInt);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.read(nbt);
        int[] o = nbt.func_74759_k("out");
        for (IOacc acc : this.ioacc) {
            if (acc == null) continue;
            int i = acc.side.ordinal() * 2;
            acc.stateI = o[i];
            acc.stateO = o[i + 1];
        }
        this.mode = nbt.func_74771_c("mode");
        this.tickInt = nbt.func_74762_e("tick");
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.mode == 1) {
            long t = this.field_145850_b.func_82737_E();
            this.nextUpdate = t + (long)this.tickInt - t % (long)this.tickInt;
        }
    }

    public List<ItemStack> dropItem(IBlockState m, int fortune) {
        ItemStack item = new ItemStack(this.func_145838_q(), 1, this.func_145832_p());
        item.func_77982_d(this.write(new NBTTagCompound()));
        return Arrays.asList(item);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (item.func_77942_o()) {
            this.read(item.func_77978_p());
        }
    }

    public int redstoneLevel(int s, boolean str) {
        if (str) {
            return 0;
        }
        IOacc acc = this.ioacc[s];
        return acc != null ? acc.stateO : 0;
    }

    public void onRedstoneStateChange(EnumFacing side, int value, TileEntity src) {
        IOacc acc = this.ioacc[side.ordinal()];
        if (acc != null && value != acc.stateI && (acc.dir & 1) != 0) {
            acc.setIn(value);
        }
    }

    public void onNeighborBlockChange(Block b) {
        for (IOacc acc : this.ioacc) {
            int rs;
            if (acc == null || (acc.dir & 1) == 0 || (rs = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(acc.side), acc.side)) == acc.stateI) continue;
            acc.setIn(rs);
        }
    }

    public byte getRSDirection(EnumFacing s) {
        IOacc acc = this.ioacc[s.ordinal()];
        return acc == null ? (byte)0 : (byte)(acc.dir & 3);
    }

    public void initContainer(DataContainer container) {
        if (this.field_145850_b.field_72995_K) {
            Arrays.fill(this.ram, 0, (int)this.memoryOfs, (byte)0);
        } else {
            container.extraRef = new LastState();
        }
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        int i;
        LastState ls = (LastState)container.extraRef;
        int p = dos.writerIndex();
        dos.writeByte(0);
        byte chng = 0;
        if (this.tickInt != ls.tickInt || this.mode != ls.mode) {
            ls.tickInt = this.tickInt;
            dos.writeShort(ls.tickInt);
            ls.mode = this.mode;
            dos.writeByte((int)ls.mode);
            chng = (byte)(chng | 1);
        }
        for (int i2 = 0; i2 < this.iocfg.length; ++i2) {
            IOcfg cfg = this.iocfg[i2];
            short x = (short)(cfg.ofs | cfg.side << 8);
            if (x == ls.iocfg[i2]) continue;
            ls.iocfg[i2] = x;
            dos.writeShort((int)ls.iocfg[i2]);
            chng = (byte)(chng | 2 << i2);
        }
        int chng1 = 0;
        for (i = 0; i < this.startIdx; ++i) {
            if (this.ram[i] == ls.ram[i]) continue;
            chng1 |= 1 << i;
        }
        if (chng1 != 0) {
            dos.writeInt(chng1);
            chng = (byte)(chng | 0x80);
            i = 0;
            while (chng1 != 0) {
                if ((chng1 & 1) != 0) {
                    ls.ram[i] = this.ram[i];
                    dos.writeByte((int)ls.ram[i]);
                }
                ++i;
                chng1 >>= 1;
            }
        }
        if (chng == 0) {
            return false;
        }
        dos.setByte(p, (int)chng);
        return true;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
        byte chng = dis.readByte();
        if ((chng & 1) != 0) {
            this.tickInt = dis.readShort();
            this.mode = dis.readByte();
        }
        for (int i = 0; i < this.iocfg.length; ++i) {
            if ((chng >> i & 2) == 0) continue;
            IOcfg cfg = this.iocfg[i];
            short x = dis.readShort();
            cfg.ofs = (byte)x;
            cfg.side = (byte)(x >> 8);
        }
        if ((chng & 0x80) != 0) {
            int chng1 = dis.readInt();
            for (int i = 0; chng1 != 0 && i < this.ram.length; ++i, chng1 >>= 1) {
                if ((chng1 & 1) == 0) continue;
                this.ram[i] = dis.readByte();
            }
        }
    }

    private static final class LastState {
        int tickInt;
        byte mode;
        final short[] iocfg = new short[6];
        final byte[] ram = new byte[32];

        private LastState() {
        }
    }

    class IOacc {
        int stateI;
        int stateO;
        IQuickRedstoneHandler te;
        final EnumFacing side;
        byte dir;

        IOacc(int s) {
            this.side = EnumFacing.field_82609_l[s];
        }

        void update(int state) {
            if (state != this.stateO) {
                ICapabilityProvider t;
                this.stateO = state;
                if ((this.te == null || this.te.invalid()) && (t = Circuit.this.getTileOnSide(this.side)) instanceof IQuickRedstoneHandler) {
                    this.te = (IQuickRedstoneHandler)t;
                }
                if (this.te != null) {
                    this.te.onRedstoneStateChange(this.side.func_176734_d(), state, (TileEntity)Circuit.this);
                } else {
                    Circuit.this.field_145850_b.func_180496_d(Circuit.this.field_174879_c.func_177972_a(this.side), Circuit.this.field_145854_h);
                }
            }
            if ((this.dir & 4) != 0) {
                state = Circuit.this.field_145850_b.func_175651_c(Circuit.this.field_174879_c.func_177972_a(this.side), this.side);
                if (state != this.stateI) {
                    this.setIn(state);
                }
                this.dir = (byte)(this.dir & 3);
            }
        }

        void setIn(int state) {
            long t = Circuit.this.field_145850_b.func_82737_E();
            if (t != Circuit.this.nextUpdate) {
                this.stateI = state;
                if (Circuit.this.mode >= 2 && t > Circuit.this.nextUpdate) {
                    Circuit.this.nextUpdate = Circuit.this.nextUpdate + (long)(Circuit.this.tickInt + 1);
                    if (t >= Circuit.this.nextUpdate) {
                        Circuit.this.nextUpdate = t + 1L;
                    }
                }
            } else {
                this.dir = (byte)(this.dir | 4);
            }
        }
    }

    public class IOcfg {
        public final String label;
        public final byte size;
        public final byte addr;
        public final boolean dir;
        public byte ofs;
        public byte side;

        IOcfg(boolean dir, String label, byte size, byte addr) {
            this.dir = dir;
            this.label = label;
            this.size = size;
            this.addr = addr;
        }

        IOcfg(NBTTagCompound tag) {
            this.dir = tag.func_74767_n("d");
            this.label = tag.func_74779_i("n");
            this.size = tag.func_74771_c("s");
            this.addr = tag.func_74771_c("p");
            this.side = tag.func_74771_c("a");
            this.ofs = tag.func_74771_c("o");
        }

        NBTTagCompound write() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("d", this.dir);
            tag.func_74774_a("p", this.addr);
            tag.func_74774_a("s", this.size);
            tag.func_74778_a("n", this.label);
            tag.func_74774_a("a", this.side);
            tag.func_74774_a("o", this.ofs);
            return tag;
        }
    }
}

