/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.api.circuits.ISensor;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.templates.Inventory;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BlockSensor
extends AutomatedTile
implements IDirectionalRedstone,
DataContainer.IGuiData {
    private static final float[] DefTransf = new float[]{1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f};
    public int tickInt = 20;
    public final float[] transf = Arrays.copyOf(DefTransf, 12);
    private final int[] output = new int[6];

    public BlockSensor() {
        this.inventory = new Inventory(6, 0, null);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % (long)this.tickInt != 0L) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            ItemStack item = this.inventory.items[i];
            int nstate = item != null && item.func_77973_b() instanceof ISensor ? (int)Math.floor(((ISensor)item.func_77973_b()).measure(item, this.field_145850_b, this.field_174879_c) * (double)this.transf[i * 2] + (double)this.transf[i * 2 + 1]) : 0;
            if (this.output[i] == nstate) continue;
            this.output[i] = nstate;
            Utils.updateRedstoneOnSide((ModTileEntity)this, (int)nstate, (EnumFacing)EnumFacing.field_82609_l[i]);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] arr = nbt.func_74759_k("cfg");
        for (int i = 0; i < 12; ++i) {
            this.transf[i] = arr.length > i ? Float.intBitsToFloat(arr[i]) : DefTransf[i];
        }
        this.tickInt = arr.length > 12 ? arr[12] : 1;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74783_a("cfg", this.getSyncVariables());
        nbt.func_74783_a("out", this.output);
        return super.func_189515_b(nbt);
    }

    protected void customPlayerCommand(byte cmd, PacketBuffer dis, EntityPlayerMP player) throws IOException {
        if (cmd < 12) {
            this.transf[cmd] = dis.readFloat();
        } else if (cmd == 14) {
            this.tickInt = dis.readInt();
            if (this.tickInt < 1) {
                this.tickInt = 1;
            } else if (this.tickInt > 1200) {
                this.tickInt = 1200;
            }
        }
    }

    public int redstoneLevel(int s, boolean str) {
        return str ? 0 : this.output[s];
    }

    public byte getRSDirection(EnumFacing s) {
        return 2;
    }

    public void initContainer(DataContainer container) {
        TileContainer cont = (TileContainer)container;
        for (int i = 0; i < 6; ++i) {
            cont.addItemSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, i, 44, 16 + 18 * i));
        }
        cont.addPlayerInventory(8, 140);
    }

    public int[] getSyncVariables() {
        int[] arr = new int[13];
        for (int i = 0; i < 12; ++i) {
            arr[i] = Float.floatToIntBits(this.transf[i]);
        }
        arr[12] = this.tickInt;
        return arr;
    }

    public void setSyncVariable(int i, int v) {
        if (i < 12) {
            this.transf[i] = Float.intBitsToFloat(v);
        } else if (i == 12) {
            this.tickInt = v;
        }
    }

    public void breakBlock() {
        this.inventory.dropItems((ModTileEntity)this, 0, 6);
    }
}

