/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IDirectionalRedstone;
import cd4017be.api.circuits.IQuickRedstoneHandler;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TickRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BitShifter
extends ModTileEntity
implements IDirectionalRedstone,
IQuickRedstoneHandler,
TickRegistry.IUpdatable {
    public byte ofsI = 0;
    public byte ofsO = 0;
    public byte size = 1;
    public int state;
    private boolean update;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            if (item != null) return false;
            if (this.size <= 1) return false;
            this.dropStack(BlockItemRegistry.stack((String)"m.IORelay", (int)(this.size - 1)));
            this.size = 1;
            this.onNeighborBlockChange(null);
            this.markUpdate();
            return true;
        } else if (item == null) {
            float f;
            int t = s.ordinal() >> 1;
            switch (this.getOrientation()) {
                case 0: {
                    f = Y;
                    t = (4 - t) % 3;
                    break;
                }
                case 1: {
                    f = 1.0f - Y;
                    t = (4 - t) % 3;
                    break;
                }
                case 2: {
                    f = Z;
                    break;
                }
                case 3: {
                    f = 1.0f - Z;
                    break;
                }
                case 4: {
                    f = X;
                    t = (3 - t) % 3;
                    break;
                }
                default: {
                    f = 1.0f - X;
                    t = (3 - t) % 3;
                }
            }
            if (t == 1) {
                return false;
            }
            int n = 32 - this.size;
            int p = Math.round(f * 32.0f - (float)this.size / 2.0f);
            if (p < 0) {
                p = 0;
            } else if (p > n) {
                p = n;
            }
            if (t == 2) {
                this.ofsI = (byte)p;
                this.onNeighborBlockChange(null);
            } else {
                this.ofsO = (byte)p;
                this.field_145850_b.func_180496_d(this.field_174879_c.func_177972_a(EnumFacing.field_82609_l[this.getOrientation() ^ 1]), Blocks.field_150429_aA);
            }
            this.markUpdate();
            return true;
        } else {
            if (!item.func_77969_a(BlockItemRegistry.stack((String)"m.IORelay", (int)1))) return true;
            int n = 32 - this.size;
            if (item.field_77994_a > n) {
                item.field_77994_a -= n;
                this.size = (byte)(this.size + n);
            } else {
                this.size = (byte)(this.size + item.field_77994_a);
                item = null;
            }
            player.func_184611_a(hand, item);
            this.onNeighborBlockChange(null);
            this.markUpdate();
        }
        return true;
    }

    public void onNeighborBlockChange(Block b) {
        EnumFacing dir = EnumFacing.field_82609_l[this.getOrientation()];
        this.setInput(this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir), dir);
    }

    public void onRedstoneStateChange(EnumFacing side, int value, TileEntity src) {
        EnumFacing dir = EnumFacing.field_82609_l[this.getOrientation()];
        if (side == dir) {
            this.setInput(value, dir);
        }
    }

    private void setInput(int value, EnumFacing dir) {
        value >>>= this.ofsI;
        if ((value &= -1 >>> 32 - this.size) != this.state) {
            this.state = value;
            ICapabilityProvider te = this.getTileOnSide(dir.func_176734_d());
            if (te != null && te instanceof IQuickRedstoneHandler) {
                ((IQuickRedstoneHandler)te).onRedstoneStateChange(dir, this.state << this.ofsO, (TileEntity)this);
            } else if (!this.update) {
                this.update = true;
                TickRegistry.instance.updates.add(this);
            }
        }
    }

    public int redstoneLevel(int s, boolean str) {
        return str || s != (this.getOrientation() ^ 1) ? 0 : this.state << this.ofsO;
    }

    public byte getRSDirection(EnumFacing s) {
        byte dir = this.getOrientation();
        return (byte)(s.ordinal() == dir ? 1 : ((s.ordinal() ^ 1) == dir ? 2 : 0));
    }

    public void process() {
        this.update = false;
        this.field_145850_b.func_180496_d(this.field_174879_c.func_177972_a(EnumFacing.field_82609_l[this.getOrientation() ^ 1]), Blocks.field_150429_aA);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ofsI = nbt.func_74771_c("ofsI");
        this.ofsO = nbt.func_74771_c("ofsO");
        this.size = nbt.func_74771_c("size");
        this.state = nbt.func_74762_e("state");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("ofsI", this.ofsI);
        nbt.func_74774_a("ofsO", this.ofsO);
        nbt.func_74774_a("size", this.size);
        nbt.func_74768_a("state", this.state);
        return super.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("ofsI", this.ofsI);
        nbt.func_74774_a("ofsO", this.ofsO);
        nbt.func_74774_a("size", this.size);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.ofsI = nbt.func_74771_c("ofsI");
        this.ofsO = nbt.func_74771_c("ofsO");
        this.size = nbt.func_74771_c("size");
    }

    public double func_145833_n() {
        return 256.0;
    }

    public void breakBlock() {
        if (this.size > 1) {
            this.dropStack(BlockItemRegistry.stack((String)"m.IORelay", (int)(this.size - 1)));
            this.size = 1;
        }
    }
}

