/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.circuits.Objects;
import cd4017be.circuits.tileEntity.CircuitDesigner;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.SlotItemType;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.templates.Inventory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.Level;

public class Assembler
extends AutomatedTile
implements Inventory.IAccessHandler,
DataContainer.IGuiData,
TileContainer.ISlotClickHandler {
    private static final Item circuit = Item.func_150898_a((Block)Objects.circuit);
    public static final String[] tagNames = new String[]{"IO", "Cap", "Gate", "Calc"};
    public static final String[] materials = new String[]{"m.IORelay", "m.RAMPlate", "m.LogicPrc", "m.CalcPrc"};
    public int[] N = new int[9];
    NBTTagCompound code;
    private boolean recompile;

    public Assembler() {
        this.inventory = new Inventory(8, 3, (Inventory.IAccessHandler)this).group(0, 0, 1, -1).group(1, 2, 3, 1).group(2, 3, 7, 0);
        this.N[8] = -1;
    }

    public void func_73660_a() {
        block15: {
            ItemStack item;
            block14: {
                int i;
                super.func_73660_a();
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if (this.recompile) {
                    this.compile();
                    this.recompile = false;
                }
                if (this.N[8] > 0) {
                    return;
                }
                item = this.inventory.items[1];
                if (item == null) break block14;
                boolean done = true;
                for (i = 0; i < 4; ++i) {
                    ItemStack stack;
                    int m = this.N[i + 4];
                    int n = this.N[i];
                    if (m > n) {
                        stack = this.inventory.insertItem(3 + i, BlockItemRegistry.stack((String)materials[i], (int)1), false);
                        if (stack == null) {
                            this.N[i + 4] = --m;
                        }
                    } else if (m < n && (stack = this.inventory.extractItem(3 + i, 1, false)) != null) {
                        this.N[i + 4] = ++m;
                    }
                    done &= m == n;
                }
                if (!done) break block15;
                item.func_77982_d(this.code);
                this.inventory.items[1] = this.inventory.insertItem(2, item, false);
                for (i = 4; i < 8; ++i) {
                    this.N[i] = 0;
                }
                break block15;
            }
            if (this.inventory.items[0] != null && this.inventory.items[0].func_77973_b() == circuit) {
                this.inventory.items[1] = item = this.inventory.extractItem(0, 1, false);
                NBTTagCompound nbt = item.func_77978_p();
                if (nbt == null) {
                    for (int i = 4; i < 8; ++i) {
                        this.N[i] = 0;
                    }
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.N[i + 4] = nbt.func_74771_c(tagNames[i]);
                    }
                }
            }
        }
    }

    public void compile() {
        ItemStack item = this.inventory.items[7];
        if (item == null || item.func_77973_b() != Objects.circuitPlan || !item.func_77942_o()) {
            for (int i = 0; i < 4; ++i) {
                this.N[i] = 0;
            }
            this.N[8] = -1;
            this.code = null;
            return;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int size = 0;
        int logic = 0;
        int calc = 0;
        int io = 0;
        NBTTagList list = new NBTTagList();
        HashMap<Integer, Constant> constants = new HashMap<Integer, Constant>();
        ByteBuf out = Unpooled.buffer();
        ByteBuf cst = Unpooled.buffer();
        ByteBuffer data = ByteBuffer.wrap(nbt.func_74770_j("data"));
        try {
            int l;
            int n;
            int p = 0;
            for (n = data.get() & 0xFF; n > 0; --n) {
                int l2;
                int t = data.get();
                if (t < 0) {
                    l2 = data.get() - 1 & 0xF;
                    out.writeByte(0 | l2);
                    p += l2 + 1;
                    continue;
                }
                if (t < 6) {
                    t = (t << 4) + 32;
                    l2 = data.get() & 0xF;
                    out.writeByte(t | l2);
                    for (int i = 0; i < l2; ++i) {
                        int a = data.get() & 0xFF;
                        if (a / 8 >= size) {
                            size = a / 8 + 1;
                        }
                        out.writeByte(a);
                    }
                    ++p;
                    ++logic;
                } else {
                    if (t == 17) {
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74757_a("d", false);
                        tag.func_74774_a("p", (byte)p);
                        l = data.get() & 0x3F;
                        tag.func_74774_a("s", (byte)l);
                        p += l;
                        io += l;
                        out.writeByte(0x10 | (l >= 8 ? l / 8 - 1 : 0));
                        byte[] str = new byte[data.get()];
                        data.get(str);
                        tag.func_74778_a("n", new String(str));
                        list.func_74742_a((NBTBase)tag);
                        continue;
                    }
                    int q = out.writerIndex();
                    int r = 0;
                    out.writeByte(r);
                    if (t < 10) {
                        r = t - 6 + -128;
                        ++p;
                        ++calc;
                    } else {
                        int s = data.get() / 8 - 1 & 3;
                        r = (t - 10) * 16 + -112 | s;
                        p += s * 8 + 8;
                        calc += s + (t == 11 ? 1 : (t < 14 ? 2 : 3));
                    }
                    CircuitDesigner.ModuleType tp = CircuitDesigner.ModuleType.values()[t];
                    for (int i = 0; i < tp.defCon; ++i) {
                        int x;
                        if (!tp.conType(i)) {
                            int a = data.get() & 0xFF;
                            if (a / 8 >= size) {
                                size = a / 8 + 1;
                            }
                            out.writeByte(a);
                            continue;
                        }
                        int ct = data.get();
                        if (ct < 0) {
                            x = data.getInt();
                            Constant c = (Constant)constants.get(x);
                            if (c == null) {
                                int k;
                                int s = cst.writerIndex();
                                if (x < -8388608 || x >= 0x800000) {
                                    cst.writeByte(x).writeByte(x >> 8).writeByte(x >> 16).writeByte(x >> 24);
                                    k = 192;
                                } else if (x < Short.MIN_VALUE || x >= 32768) {
                                    cst.writeByte(x).writeByte(x >> 8).writeByte(x >> 16);
                                    k = 128;
                                } else if (x < -128 || x >= 128) {
                                    cst.writeByte(x).writeByte(x >> 8);
                                    k = 64;
                                } else {
                                    cst.writeByte(x);
                                    k = 0;
                                }
                                c = new Constant(k, s);
                                constants.put(x, c);
                            }
                            c.ref.add(out.writerIndex());
                            out.writeByte(0);
                            r |= 16 >> tp.defCon - i;
                            continue;
                        }
                        r |= (ct & 4) << i + 2 - tp.defCon;
                        x = (data.get() & 0xFF) / 8;
                        if (x + (ct &= 3) >= size) {
                            size = x + ct + 1;
                        }
                        out.writeByte(x | ct << 6);
                    }
                    out.setByte(q, r);
                }
                data.position(data.get() + data.position());
            }
            if ((p += 7) / 8 > size) {
                size = p / 8;
            }
            if (size > 32) {
                this.N[8] = 1;
                return;
            }
            if (size + cst.writerIndex() > 64) {
                this.N[8] = 2;
                return;
            }
            for (Constant c : constants.values()) {
                int k = c.idx + size | c.type;
                for (int i : c.ref) {
                    out.setByte(i, k);
                }
            }
            n = data.get();
            if (n + list.func_74745_c() > 6) {
                this.N[8] = 3;
                return;
            }
            for (int i = 0; i < n; ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74757_a("d", true);
                tag.func_74774_a("p", data.get());
                l = data.get() & 0x3F;
                tag.func_74774_a("s", (byte)l);
                io += l;
                byte[] str = new byte[data.get()];
                data.get(str);
                tag.func_74778_a("n", new String(str));
                list.func_74742_a((NBTBase)tag);
            }
            if (data.position() != data.limit()) {
                throw new IllegalStateException(String.format("Only read %d of %d bytes!", data.position(), data.limit()));
            }
        }
        catch (Exception e) {
            String s = " ";
            for (byte b : data.array()) {
                s = s + Integer.toHexString(b & 0xFF) + " ";
            }
            FMLLog.log((String)"Circuit Assembler", (Level)Level.ERROR, (Throwable)e, (String)"crashed while compiling schematic data: [%s]", (Object[])new Object[]{s});
            this.N[8] = 4;
            return;
        }
        int ofs = size;
        size += cst.writerIndex();
        this.N[8] = 0;
        String name = nbt.func_74779_i("name");
        this.code = nbt = new NBTTagCompound();
        this.N[0] = io;
        nbt.func_74774_a(tagNames[0], (byte)this.N[0]);
        this.N[1] = size;
        nbt.func_74774_a(tagNames[1], (byte)this.N[1]);
        this.N[2] = logic;
        nbt.func_74774_a(tagNames[2], (byte)this.N[2]);
        this.N[3] = calc;
        nbt.func_74774_a(tagNames[3], (byte)this.N[3]);
        byte[] b = new byte[out.writerIndex() + size];
        out.readBytes(b, size, out.writerIndex());
        cst.readBytes(b, ofs, cst.writerIndex());
        nbt.func_74773_a("data", b);
        nbt.func_74782_a("io", (NBTBase)list);
        nbt.func_74774_a("ofs", (byte)ofs);
        nbt.func_74778_a("name", name);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.recompile = true;
    }

    public void initContainer(DataContainer container) {
        TileContainer c = (TileContainer)container;
        c.clickHandler = this;
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 0, 152, 16, new ItemStack[]{new ItemStack(circuit, 64), new ItemStack(circuit, 64, 1), new ItemStack(circuit, 64, 2)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 2, 152, 52, new ItemStack[0]));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 3, 26, 16, new ItemStack[]{BlockItemRegistry.stack((String)materials[0], (int)64)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 4, 8, 16, new ItemStack[]{BlockItemRegistry.stack((String)materials[1], (int)64)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 5, 8, 52, new ItemStack[]{BlockItemRegistry.stack((String)materials[2], (int)64)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 6, 26, 52, new ItemStack[]{BlockItemRegistry.stack((String)materials[3], (int)64)}));
        c.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inventory, 7, 116, 34, new ItemStack[]{new ItemStack((Item)Objects.circuitPlan, 1)}));
        c.addPlayerInventory(8, 86);
    }

    public int[] getSyncVariables() {
        return this.N;
    }

    public boolean transferStack(ItemStack item, int s, TileContainer container) {
        if (s < 7) {
            return false;
        }
        container.func_75135_a(item, 2, 6, false);
        if (item.field_77994_a > 0) {
            container.func_75135_a(item, 0, 1, false);
        }
        if (item.field_77994_a > 0) {
            container.func_75135_a(item, 6, 7, false);
        }
        return true;
    }

    public int insertAm(int g, int s, ItemStack item, ItemStack insert) {
        if (s >= 3 && s < 7 && !insert.func_77969_a(BlockItemRegistry.stack((String)materials[s - 3], (int)1)) || s == 7 && insert.func_77973_b() != Objects.circuitPlan || s == 0 && insert.func_77973_b() != circuit) {
            return 0;
        }
        int m = insert.func_77976_d();
        return item == null ? Math.min(m, insert.field_77994_a) : (item.field_77994_a < m && ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)insert) ? Math.min(m - item.field_77994_a, insert.field_77994_a) : 0);
    }

    public int extractAm(int g, int s, ItemStack item, int extract) {
        return item == null ? 0 : (item.field_77994_a < extract ? item.field_77994_a : extract);
    }

    public void setSlot(int g, int s, ItemStack item) {
        this.inventory.items[s] = item;
        if (s == 7) {
            this.recompile = true;
        }
    }

    private static class Constant {
        final int type;
        final int idx;
        final ArrayList<Integer> ref = new ArrayList();

        Constant(int t, int i) {
            this.type = t;
            this.idx = i;
        }
    }
}

