/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone1bit;
import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileEntityData;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ArithmeticConverter
extends AutomatedTile
implements IRedstone8bit,
IRedstone1bit {
    private short state;
    private boolean update;
    private boolean updateCon;

    public ArithmeticConverter() {
        this.netData = new TileEntityData(1, 0, 0, 0);
    }

    protected void customPlayerCommand(byte cmd, PacketBuffer dis, EntityPlayerMP player) throws IOException {
        if (cmd == 0) {
            this.netData.longs[0] = dis.readLong();
            this.updateCon = true;
            this.update = true;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("cfg", this.netData.longs[0]);
        nbt.func_74777_a("state", this.state);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.netData.longs[0] = nbt.func_74763_f("cfg");
        this.state = nbt.func_74765_d("state");
        this.update = true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateCon) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            this.updateCon = false;
        }
        if (this.update) {
            this.update(0);
        }
    }

    private void update(int recursion) {
        TileEntity te;
        byte d8;
        EnumFacing dir;
        int i;
        this.update = false;
        short lstate = this.state;
        this.state = (short)this.getConfig(6);
        for (i = 0; i < 6; ++i) {
            int v;
            block8: {
                block9: {
                    dir = EnumFacing.field_82609_l[i];
                    d8 = this.getDirection(i);
                    if (d8 >= 0) continue;
                    te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                    if (te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) > 0 && (v = ((IRedstone8bit)te).getValue(i ^ 1) & 0xFF) > 0) break block8;
                    if (te == null || !(te instanceof IRedstone1bit) || ((IRedstone1bit)te).getBitDirection(i ^ 1) <= 0) break block9;
                    byte by = ((IRedstone1bit)te).getBitValue(i ^ 1);
                    v = by;
                    if (by > 0) break block8;
                }
                if ((v = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir)) <= 0) continue;
            }
            this.state = (short)(this.state + v * this.getConfig(i));
        }
        if (this.state != lstate) {
            ++recursion;
            for (i = 0; i < 6; ++i) {
                dir = EnumFacing.field_82609_l[i];
                d8 = this.getDirection(i);
                if (d8 <= 0) continue;
                te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                if (te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) < 0) {
                    ((IRedstone8bit)te).setValue(i ^ 1, this.getValue(i), recursion);
                    continue;
                }
                if (te != null && te instanceof IRedstone1bit && ((IRedstone1bit)te).getBitDirection(i ^ 1) < 0) {
                    ((IRedstone1bit)te).setBitValue(i ^ 1, this.getBitValue(i), recursion);
                    continue;
                }
                this.notifyStateChange(this.field_174879_c.func_177972_a(dir), dir.func_176734_d());
            }
        }
    }

    private void notifyStateChange(BlockPos pos, EnumFacing except) {
        this.field_145850_b.func_180496_d(pos, this.func_145838_q());
        this.field_145850_b.func_175695_a(pos, this.func_145838_q(), except);
    }

    public int redstoneLevel(int s, boolean str) {
        return this.getConfig(s | 8) == 0 ? 0 : (int)this.getBitValue(s);
    }

    public void onNeighborBlockChange(Block b) {
        this.update = true;
    }

    public byte getValue(int s) {
        int c = this.getConfig(s);
        return (byte)(c == 0 ? 0 : this.state / c & 0xFF);
    }

    public byte getDirection(int s) {
        return (byte)(this.getConfig(s) == 0 ? 0 : (this.getConfig(s | 8) == 0 ? -1 : 1));
    }

    public void setValue(int s, byte v, int recursion) {
        this.update = true;
    }

    public byte getBitDirection(int s) {
        return this.getDirection(s);
    }

    public byte getBitValue(int s) {
        int c = this.getConfig(s);
        return (byte)(c == 0 ? 0 : this.state / c & 0xF);
    }

    public void setBitValue(int s, byte v, int recursion) {
        this.update = true;
    }

    public int getConfig(int s) {
        int c;
        if (s < 6) {
            c = 255;
            s *= 8;
        } else if (s == 6) {
            c = 1023;
            s = 48;
        } else {
            c = 1;
            s += 50;
        }
        int d = (int)(this.netData.longs[0] >> s) & c;
        if (s < 58 && (d & Integer.highestOneBit(c)) != 0) {
            d |= ~c;
        }
        return d;
    }

    public void setConfig(int s, int v) {
        long c;
        if (s < 6) {
            c = 255L;
            s *= 8;
        } else if (s == 6) {
            c = 1023L;
            s = 48;
        } else {
            c = 1L;
            s += 50;
        }
        this.netData.longs[0] = this.netData.longs[0] & (c << s ^ 0xFFFFFFFFFFFFFFFFL);
        this.netData.longs[0] = this.netData.longs[0] | ((long)v & c) << s;
    }
}

