/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.render;

import cd4017be.circuits.tileEntity.Oszillograph;
import cd4017be.lib.render.Util;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class OszillographRenderer
extends TileEntitySpecialRenderer<Oszillograph> {
    private static final float LineThick = 0.01f;
    private static final float ZLevel = 0.515625f;
    private static final float TexX = 0.0f;
    private static final float TexY0 = 0.0f;
    private static final float TexY1 = 1.0f;
    private static final float textH = 0.0625f;
    private static final float textW = 0.375f;
    private static final int[] defaultQuad = new int[]{0, 0, Float.floatToIntBits(0.515625f), Float.floatToIntBits(0.0f), Float.floatToIntBits(0.0f), 0, 0, 0, Float.floatToIntBits(0.515625f), Float.floatToIntBits(0.0f), Float.floatToIntBits(1.0f), 0};
    private static final int QuadSize = defaultQuad.length;
    public static final int[] colors = new int[]{255, 65280, 0xFF0000, 0xB400B4};
    public static final int[] textColors = new int[]{0xFF0000, 65280, 255, 0xB400B4};
    private static final ResourceLocation texture = new ResourceLocation("circuits", "textures/blocks/osziLine.png");

    public void renderTileEntityAt(Oszillograph te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Util.moveAndOrientToBlock((double)x, (double)y, (double)z, (int)(te.getOrientation() ^ 1));
        GL11.glScalef((float)0.9375f, (float)0.9375f, (float)1.0f);
        this.func_147499_a(texture);
        VertexBuffer buff = Tessellator.func_178181_a().func_178180_c();
        buff.func_181668_a(8, DefaultVertexFormats.field_181709_i);
        for (int i = 0; i < te.vertexData.length; ++i) {
            int[] vb = te.vertexData[i];
            if (vb == null) continue;
            buff.func_178981_a(vb);
        }
        Tessellator.func_178181_a().func_78381_a();
        this.renderInfoTexts(te);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void renderInfoTexts(Oszillograph te) {
        FontRenderer fr = this.func_147498_b();
        for (int i = 0; i < 4; ++i) {
            if (te.vertexData[i] == null || te.info[i].isEmpty()) continue;
            boolean right = (i & 1) != 0;
            boolean top = i < 2;
            String t = te.info[i];
            int l = fr.func_78256_a(t);
            int h = fr.field_78288_b;
            float scale = Math.min(0.0625f / (float)h, 0.375f / (float)l);
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)(right ? 0.5f : -0.5f), (float)(top ? 0.5f : -0.5f), (float)0.515625f);
            GL11.glScalef((float)scale, (float)(-scale), (float)0.0f);
            fr.func_78276_b(t, right ? -l : 0, top ? 0 : -h, textColors[i]);
            GlStateManager.func_179121_F();
        }
    }

    public static void recolor(int[] vb, int p, int color) {
        int n = vb.length / QuadSize - 1;
        for (int i = 5; i < vb.length; i += QuadSize) {
            int alpha = (i / QuadSize - p + n) % n;
            alpha = alpha < 15 ? alpha * 0x11000000 : -16777216;
            vb[i + 6] = vb[i] = color | alpha;
        }
    }

    public static void setValue(int[] vb, int p, float y) {
        int i = p * QuadSize + 1;
        vb[i] = Float.floatToIntBits(y + 0.01f);
        vb[i + 6] = Float.floatToIntBits(y - 0.01f);
        if (p == 0) {
            OszillographRenderer.setValue(vb, vb.length / QuadSize - 1, y);
        }
    }

    public static int[] newVertexData(int n) {
        int[] vb = new int[(n + 1) * QuadSize];
        int i = 0;
        int k = 0;
        while (i < vb.length) {
            System.arraycopy(defaultQuad, 0, vb, i, QuadSize);
            vb[i + 6] = vb[i] = Float.floatToIntBits((float)k / (float)n - 0.5f);
            i += QuadSize;
            ++k;
        }
        return vb;
    }
}

