/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.item;

import cd4017be.api.circuits.ItemBlockSensor;
import cd4017be.circuits.gui.GuiItemSensor;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.Gui.SlotHolo;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.IGuiItem;
import cd4017be.lib.templates.InventoryItem;
import cd4017be.lib.util.Utils;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemItemSensor
extends ItemBlockSensor
implements IGuiItem,
InventoryItem.IItemInventory {
    public ItemItemSensor(String id) {
        super(id, 20.0f);
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List<String> list, boolean b) {
        if (item.func_77942_o()) {
            String[] states = I18n.func_74838_a((String)"gui.cd4017be.itemSensor.tip").split(",");
            byte mode = item.func_77978_p().func_74771_c("mode");
            ItemStack stack = this.loadInventory(item, player)[0];
            if (states.length >= 6) {
                String s;
                if (stack == null) {
                    s = states[mode & 1];
                } else {
                    s = (mode & 1) != 0 ? states[2] : "";
                    s = s + stack.func_82833_r();
                    if ((mode & 2) != 0) {
                        s = s + states[3];
                    }
                    if ((mode & 4) != 0) {
                        s = s + states[4];
                    }
                    if ((mode & 8) != 0) {
                        s = s + states[5];
                    }
                }
                list.add(s);
            }
        }
        super.func_77624_a(item, player, list, b);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)item);
        }
        BlockGuiHandler.openItemGui((EntityPlayer)player, (World)world, (int)0, (int)-1, (int)0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public Container getContainer(World world, EntityPlayer player, int x, int y, int z) {
        return new TileContainer((DataContainer.IGuiData)new GuiData(), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(World world, EntityPlayer player, int x, int y, int z) {
        return new GuiItemSensor(new TileContainer((DataContainer.IGuiData)new GuiData(), player));
    }

    public void onPlayerCommand(ItemStack item, EntityPlayer player, PacketBuffer data) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        item.func_77978_p().func_74774_a("mode", data.readByte());
    }

    public ItemStack[] loadInventory(ItemStack inv, EntityPlayer player) {
        ItemStack[] items = new ItemStack[1];
        if (inv.func_77942_o() && inv.func_77978_p().func_150297_b("type", 10)) {
            items[0] = ItemStack.func_77949_a((NBTTagCompound)inv.func_77978_p().func_74775_l("type"));
        }
        return items;
    }

    public void saveInventory(ItemStack inv, EntityPlayer player, ItemStack[] items) {
        if (!inv.func_77942_o()) {
            inv.func_77982_d(new NBTTagCompound());
        }
        if (items[0] == null) {
            inv.func_77978_p().func_82580_o("type");
        } else {
            inv.func_77978_p().func_74782_a("type", (NBTBase)items[0].func_77955_b(new NBTTagCompound()));
        }
    }

    protected float measure(ItemStack sensor, NBTTagCompound nbt, World world, BlockPos pos, EnumFacing side) {
        byte mode = nbt.func_74771_c("mode");
        TileEntity te = world.func_175625_s(pos);
        IItemHandler acc = te != null ? (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        ItemStack filter = this.loadInventory(sensor, null)[0];
        boolean inv = (mode & 1) != 0;
        int n = 0;
        if (acc == null) {
            if (filter == null && !inv) {
                return 0.0f;
            }
            Utils.ItemType type = filter == null ? null : new Utils.ItemType((mode & 2) != 0, (mode & 4) != 0, (mode & 8) != 0, new ItemStack[]{filter});
            for (EntityItem e : world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos))) {
                ItemStack item = e.func_92059_d();
                if (type != null && !(inv ^ type.matches(item))) continue;
                n += item.field_77994_a;
            }
            IBlockState state = world.func_180495_p(pos);
            for (ItemStack it : state.func_177230_c().getDrops((IBlockAccess)world, pos, state, 0)) {
                if (type != null && !(inv ^ type.matches(it))) continue;
                n += it.field_77994_a;
            }
        } else if (filter == null) {
            for (int i = 0; i < acc.getSlots(); ++i) {
                ItemStack item = acc.getStackInSlot(i);
                if (!(item == null ^ inv)) continue;
                n += inv ? item.field_77994_a : 1;
            }
        } else {
            Utils.ItemType type = new Utils.ItemType((mode & 2) != 0, (mode & 4) != 0, (mode & 8) != 0, new ItemStack[]{filter});
            for (int i = 0; i < acc.getSlots(); ++i) {
                ItemStack item = acc.getStackInSlot(i);
                if (item == null || !(type.matches(item) ^ inv)) continue;
                n += item.field_77994_a;
            }
        }
        return n;
    }

    class GuiData
    extends ItemGuiData {
        public GuiData() {
            super((Item)ItemItemSensor.this);
        }

        public void initContainer(DataContainer container) {
            TileContainer cont = (TileContainer)container;
            InventoryItem inv = new InventoryItem(cont.player);
            cont.addItemSlot((Slot)new SlotHolo((IItemHandler)inv, 0, 44, 16, false, false));
            cont.addPlayerInventory(8, 50, false, true);
        }
    }
}

