/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.gui;

import cd4017be.circuits.tileEntity.Programmer;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.GuiMachine;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.TooltipInfo;
import cd4017be.lib.templates.AutomatedTile;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class GuiProgrammer
extends GuiMachine {
    private final Programmer tile;
    private int selByte = 0;
    private boolean view8 = false;

    public GuiProgrammer(Programmer tileEntity, EntityPlayer player) {
        super((Container)new TileContainer((DataContainer.IGuiData)tileEntity, player));
        this.MAIN_TEX = new ResourceLocation("circuits", "textures/gui/programmer.png");
        this.tile = tileEntity;
    }

    public void func_73866_w_() {
        int i;
        this.field_146999_f = 176;
        this.field_147000_g = 207;
        super.func_73866_w_();
        this.titleX = this.field_146999_f / 4;
        for (i = 0; i < 8; ++i) {
            this.guiComps.add(new GuiMachine.TextField((GuiMachine)this, i, 36, 25 + i * 8, 96, 8, 32).color(-4144960, -65536));
        }
        for (i = 0; i < 8; ++i) {
            this.guiComps.add(new GuiMachine.TextField((GuiMachine)this, i + 8, 133, 25 + i * 8, 35, 8, 8).color(-12517568, -65536));
        }
        this.guiComps.add(new GuiMachine.TextField((GuiMachine)this, 16, 89, 4, 80, 8, 24).setTooltip("program.n"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 17, 152, 91, 16, 16, -1).setTooltip("program.load"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 18, 116, 91, 16, 16, -1).setTooltip("program.save"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 19, 8, 91, 16, 8, -1).setTooltip("program.up"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 20, 8, 99, 16, 8, -1).setTooltip("program.down"));
        this.guiComps.add(new GuiMachine.GuiComp((GuiMachine)this, 21, 8, 16, 28, 8).setTooltip("program.index"));
        this.guiComps.add(new GuiMachine.GuiComp((GuiMachine)this, 22, 36, 16, 96, 8).setTooltip("program.code"));
        this.guiComps.add(new GuiMachine.GuiComp((GuiMachine)this, 23, 132, 16, 36, 8).setTooltip("program.label"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 24, 26, 91, 16, 16, 0).texture(176, 0).setTooltip("program.view#"));
    }

    protected void func_146979_b(int mx, int my) {
        super.func_146979_b(mx, my);
        if (this.func_146978_c(9, 26, 14, 62, mx, my)) {
            int x = (mx - this.field_147003_i - 8) / 2;
            int y = (my - this.field_147009_r - 25) / 2;
            int i = y * 8 + x;
            this.func_146283_a(Arrays.asList(String.format("%d:%02X ", y, i) + this.tile.getLabel(i)), mx - this.field_147003_i, my - this.field_147009_r);
        }
    }

    protected void func_146976_a(float t, int mx, int my) {
        super.func_146976_a(t, mx, my);
        this.field_146297_k.field_71446_o.func_110577_a(this.MAIN_TEX);
        if (this.focus >= 0 && this.focus < 8) {
            this.showIO((GuiMachine.TextField)this.guiComps.get(this.focus));
        } else {
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 25 + 2 * this.selByte, 239, 0, 17, this.view8 ? 16 : 2);
        }
        for (int i = 0; i < 8; ++i) {
            this.field_146289_q.func_78276_b(String.format("%02X", this.lineIndex(i)), this.field_147003_i + 24, this.field_147009_r + 25 + i * 8, -192);
        }
        String[] s = I18n.func_74838_a((String)"gui.cd4017be.program.head").split("\\n");
        if (s.length > 0) {
            this.field_146289_q.func_78276_b(s[0], this.field_147003_i + 8, this.field_147009_r + 16, 0x404040);
        }
        if (s.length > 1) {
            this.field_146289_q.func_78276_b(s[1], this.field_147003_i + 88 - this.field_146289_q.func_78256_a(s[1]) / 2, this.field_147009_r + 16, 0x404040);
        }
        if (s.length > 2) {
            this.field_146289_q.func_78276_b(s[2], this.field_147003_i + 168 - this.field_146289_q.func_78256_a(s[2]), this.field_147009_r + 16, 0x404040);
        }
        if (this.tile.errorCode > 0) {
            this.func_73733_a(this.field_147003_i + 8, this.field_147009_r + 111, this.field_147003_i + 168, this.field_147009_r + 120, -3750202, -3750202);
            this.drawStringCentered(TooltipInfo.format((String)("gui.cd4017be.err" + this.tile.errorCode), (Object[])new Object[]{this.tile.errorArg}), this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 112, 0xFF4040);
        }
    }

    protected Object getDisplVar(int id) {
        if (id < 8) {
            return this.tile.getCode(this.lineIndex(id));
        }
        if (id < 16) {
            return this.tile.getLabel(this.lineIndex(id - 8));
        }
        if (id == 16) {
            return this.tile.name;
        }
        return this.view8 ? 1 : 0;
    }

    protected void setDisplVar(int id, Object obj, boolean send) {
        PacketBuffer dos = this.tile.getPacketTargetData();
        if (id < 8) {
            dos.writeByte(AutomatedTile.CmdOffset).writeByte(this.lineIndex(id));
            dos.func_180714_a((String)obj);
        } else if (id < 16) {
            dos.writeByte(AutomatedTile.CmdOffset + 1).writeByte(this.lineIndex(id - 8));
            dos.func_180714_a((String)obj);
        } else if (id == 16) {
            dos.writeByte(AutomatedTile.CmdOffset + 2);
            dos.func_180714_a((String)obj);
        } else if (id == 17) {
            dos.writeByte(AutomatedTile.CmdOffset + 3);
        } else if (id == 18) {
            dos.writeByte(AutomatedTile.CmdOffset + 4);
        } else {
            this.setFocus(-1);
            if (id == 19) {
                this.selByte -= (Integer)obj == 0 ? 1 : 8;
            } else if (id == 20) {
                this.selByte += (Integer)obj == 0 ? 1 : 8;
            } else if (id == 24) {
                this.view8 = !this.view8;
            }
            this.selByte &= 0x1F;
            return;
        }
        if (send) {
            BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
        }
    }

    private int lineIndex(int l) {
        return (this.view8 ? l * 8 : l) + this.selByte * 8;
    }

    protected void func_73864_a(int x, int y, int b) throws IOException {
        if (this.func_146978_c(9, 26, 14, 62, x, y)) {
            int px = (x - this.field_147003_i - 8) / 2;
            int py = (y - this.field_147009_r - 25) / 2;
            int i = py * 8 + px;
            if (this.focus >= 0 && this.focus < 8) {
                this.addReqIndex((GuiMachine.TextField)this.guiComps.get(this.focus), py, i);
            } else {
                this.setFocus(-1);
                if (this.view8) {
                    if (py < this.selByte) {
                        this.selByte = py;
                    } else if (py - 7 > this.selByte) {
                        this.selByte = py - 7;
                    }
                    this.setFocus(py - this.selByte);
                } else {
                    this.selByte = py;
                    this.setFocus(px);
                }
            }
        } else {
            super.func_73864_a(x, y, b);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void func_73869_a(char c, int k) throws IOException {
        GuiMachine.TextField t;
        if (k == 200 && (this.focus == 0 || this.focus == 8)) {
            int f = this.focus;
            this.setDisplVar(19, this.view8 ? 1 : 0, false);
            this.setFocus(f + 7);
            return;
        }
        if (k == 208 && (this.focus == 7 || this.focus == 15)) {
            int f = this.focus;
            this.setDisplVar(20, this.view8 ? 1 : 0, false);
            this.setFocus(f - 7);
            return;
        }
        if (k == 203 && this.focus >= 8 && this.focus < 16) {
            t = (GuiMachine.TextField)this.guiComps.get(this.focus);
            if (t.cur == 0) {
                this.setFocus(this.focus - 8);
                return;
            }
        }
        if (k == 205 && this.focus >= 0 && this.focus < 8) {
            t = (GuiMachine.TextField)this.guiComps.get(this.focus);
            if (t.cur == t.text.length()) {
                this.setFocus(this.focus + 8);
                return;
            }
        }
        if (k == 201) {
            this.setDisplVar(19, GuiProgrammer.func_146272_n() ? 1 : 0, false);
            return;
        }
        if (k == 209) {
            this.setDisplVar(20, GuiProgrammer.func_146272_n() ? 1 : 0, false);
            return;
        }
        if (k == 31 && GuiProgrammer.func_146271_m()) {
            this.setDisplVar(18, null, true);
            return;
        }
        super.func_73869_a(c, k);
    }

    private void addReqIndex(GuiMachine.TextField t, int by, int bi) {
        String ins;
        boolean num;
        if (t.text.isEmpty()) {
            return;
        }
        int p0 = t.text.lastIndexOf(44, t.cur - 1) + 1;
        int p1 = t.text.indexOf(44, t.cur);
        if (p0 <= 0) {
            p0 = 1;
        }
        if (p1 < 0) {
            p1 = t.text.length();
        }
        switch (t.text.charAt(0)) {
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '\\': {
                num = false;
                break;
            }
            case '<': 
            case '=': 
            case '>': 
            case '~': {
                num = true;
                break;
            }
            case 'B': 
            case 'I': 
            case 'M': 
            case 'S': 
            case 'b': 
            case 'i': 
            case 'm': 
            case 's': {
                if (p0 == 1) {
                    p0 = 2;
                }
                if (p1 < p0) {
                    return;
                }
                int n = 0;
                int p = t.text.indexOf(44);
                while (p >= 0 && p < t.cur) {
                    ++n;
                    p = t.text.indexOf(44, p + 1);
                }
                num = n < 2;
                break;
            }
            default: {
                return;
            }
        }
        if (num) {
            int c;
            int n = c = t.text.length() > p0 ? (int)t.text.charAt(p0) : 32;
            if (!Character.isAlphabetic(c) && !Character.isAlphabetic(c = (int)t.text.charAt(0))) {
                c = 66;
            }
            ins = (char)c + Integer.toString(by);
        } else {
            ins = Integer.toHexString(bi);
        }
        t.text = t.text.substring(0, p0) + ins + t.text.substring(p1);
        if (t.text.length() > t.maxL) {
            t.text = t.text.substring(0, t.maxL);
        }
        t.cur = Math.min(t.maxL, p0 + ins.length());
    }

    private void showIO(GuiMachine.TextField t) {
        String[] s;
        int c;
        int l = 1;
        int id = this.lineIndex(t.id);
        if (t.text.isEmpty()) {
            c = 32;
            s = null;
        } else {
            c = t.text.charAt(0);
            s = t.text.substring(1).split(",");
        }
        switch (c) {
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 92: {
                for (String s1 : s) {
                    this.showBitParam(s1);
                }
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 126: {
                for (String s1 : s) {
                    this.showNumParam(s1);
                }
                break;
            }
            case 73: 
            case 105: {
                l += 8;
            }
            case 77: 
            case 109: {
                l += 8;
            }
            case 83: 
            case 115: {
                l += 8;
            }
            case 66: 
            case 98: {
                l += 7;
                if (s[0].isEmpty()) break;
                s[0] = s[0].substring(1);
                for (int i = 0; i < s.length; ++i) {
                    if (i < 2) {
                        this.showNumParam(s[i]);
                        continue;
                    }
                    this.showBitParam(s[i]);
                }
                break;
            }
        }
        this.func_73729_b(this.field_147003_i + 8 + 2 * (id & 7), this.field_147009_r + 25 + 2 * (id >> 3), 240 + 2 * (id & 7), 0, l >= 8 ? 16 : 2 * l, (l + 7) / 8 * 2);
    }

    private void showBitParam(String code) {
        try {
            int i = Integer.parseInt(code.trim().toLowerCase(), 16);
            this.func_73729_b(this.field_147003_i + 8 + 2 * (i % 8), this.field_147009_r + 25 + 2 * (i / 8), 240, 16, 2, 2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void showNumParam(String code) {
        int l;
        if (code.isEmpty()) {
            return;
        }
        switch (code.charAt(0)) {
            case 'B': 
            case 'b': {
                l = 1;
                break;
            }
            case 'S': 
            case 's': {
                l = 2;
                break;
            }
            case 'M': 
            case 'm': {
                l = 3;
                break;
            }
            case 'I': 
            case 'i': {
                l = 4;
                break;
            }
            default: {
                return;
            }
        }
        try {
            int i = Integer.parseInt(code.substring(1)) & 0x1F;
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 25 + 2 * i, 240, 16, 16, l * 2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

