/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.gui;

import cd4017be.circuits.tileEntity.CircuitDesigner;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.GuiMachine;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.TooltipInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class GuiCircuitDesigner
extends GuiMachine {
    private static final float ScrollSize = 24.0f;
    private static final ResourceLocation COMP_TEX = new ResourceLocation("circuits", "textures/gui/circuitOperators.png");
    private final CircuitDesigner tile;
    private int scroll;

    public GuiCircuitDesigner(CircuitDesigner tile, EntityPlayer player) {
        super((Container)new TileContainer((DataContainer.IGuiData)tile, player));
        this.MAIN_TEX = new ResourceLocation("circuits", "textures/gui/circuitDesigner.png");
        this.tile = tile;
    }

    public void func_73866_w_() {
        int i;
        this.field_146999_f = 236;
        this.field_147000_g = 244;
        super.func_73866_w_();
        this.titleX = this.field_146999_f / 4;
        for (i = 0; i < 10; ++i) {
            this.guiComps.add(new GuiMachine.Button((GuiMachine)this, i, 7, 15 + i * 9, 18, 9, -1).setTooltip("designer.m" + (char)(i + 48)));
        }
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 10, 25, 144, 18, 9, -1).setTooltip("designer.mA"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 11, 43, 144, 18, 9, -1).setTooltip("designer.mB"));
        for (i = 0; i < 5; ++i) {
            this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 12 + i, 7, 108 + i * 9, 18, 9, -1).setTooltip("designer.m" + (char)(i + 67)));
        }
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 17, 151, 144, 18, 9, 0).texture(238, 158).setTooltip("designer.io#"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 18, 191, 144, 18, 9, -1).setTooltip("designer.del"));
        this.guiComps.add(new GuiMachine.Slider((GuiMachine)this, 19, 219, 22, 116, 248, 0, 8, 12, false).scroll(0.041666668f).setTooltip("designer.scroll"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 20, 174, 161, 18, 9, 0).texture(238, 81).setTooltip("designer.out#"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 21, 210, 161, 18, 9, 0).texture(238, 27).setTooltip("designer.in#"));
        this.guiComps.add(new GuiMachine.TextField((GuiMachine)this, 22, 175, 176, 52, 7, 10).color(-16776961, -65536).setTooltip("designer.const"));
        this.guiComps.add(new GuiMachine.TextField((GuiMachine)this, 23, 175, 189, 52, 7, 10).color(-4145152, -65536).setTooltip("designer.label"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 24, 201, 161, 9, 9, 0).texture(238, 0).setTooltip("designer.sgn#"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 25, 212, 202, 16, 16, 0).texture(240, 126).setTooltip("designer.wire#"));
        this.guiComps.add(new GuiMachine.TextField((GuiMachine)this, 26, 118, 4, 109, 8, 16).setTooltip("designer.Pname"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 27, 176, 220, 16, 16, -1).setTooltip("designer.save"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 28, 212, 220, 16, 16, -1).setTooltip("designer.load"));
        this.guiComps.add(new GuiMachine.Button((GuiMachine)this, 29, 194, 202, 16, 16, 0).texture(240, 176).setTooltip("designer.mode#"));
        this.guiComps.add(new WorkPane(30, 25, 16, 8));
        this.guiComps.add(new GuiMachine.GuiComp((GuiMachine)this, 31, 7, 6, 7, 8).setTooltip("designer.info"));
    }

    protected Object getDisplVar(int id) {
        switch (id) {
            case 17: {
                return this.tile.mode ? 1 : 0;
            }
            case 19: {
                return Float.valueOf((float)this.scroll / 24.0f);
            }
            case 20: {
                return this.tile.selMod != null ? this.tile.selMod.size / 8 : 0;
            }
            case 21: {
                if (this.tile.selMod != null && this.tile.selMod.type != CircuitDesigner.ModuleType.IN) {
                    CircuitDesigner.Con c = this.tile.selMod.cons[this.tile.selMod.selCon];
                    return c != null ? (c.type == 1 ? 5 : c.size / 8) : 0;
                }
                return 0;
            }
            case 22: {
                if (this.tile.selMod == null) {
                    return "";
                }
                if (this.tile.selMod.type == CircuitDesigner.ModuleType.IN) {
                    return "" + this.tile.selMod.size;
                }
                CircuitDesigner.Con c = this.tile.selMod.cons[this.tile.selMod.selCon];
                return c != null && c.type == 1 ? "" + c.size : "";
            }
            case 23: {
                return this.tile.selMod != null ? this.tile.selMod.label : "";
            }
            case 24: {
                if (this.tile.selMod != null && this.tile.selMod.type != CircuitDesigner.ModuleType.IN) {
                    CircuitDesigner.Con c = this.tile.selMod.cons[this.tile.selMod.selCon];
                    return c != null && c.type >= 2 ? c.type - 1 : 0;
                }
                return 0;
            }
            case 25: {
                return this.tile.renderAll ? 1 : 0;
            }
            case 26: {
                return this.tile.name;
            }
            case 29: {
                return this.tile.mode ? 1 : 0;
            }
        }
        return null;
    }

    protected void setDisplVar(int id, Object obj, boolean send) {
        if (id < 18) {
            this.tile.add(CircuitDesigner.ModuleType.values()[id]);
        } else {
            switch (id) {
                case 18: {
                    if (this.tile.selMod == null) break;
                    this.tile.remove(this.tile.selMod);
                    this.tile.selMod = null;
                    ++this.tile.modified;
                    break;
                }
                case 19: {
                    this.scroll = (int)(((Float)obj).floatValue() * 24.0f);
                    break;
                }
                case 20: {
                    if (this.tile.selMod == null || this.tile.selMod.size <= 1) break;
                    this.tile.selMod.resize(8 + (this.tile.selMod.size / 8 + ((Integer)obj == 0 ? 0 : 2)) % 4 * 8);
                    ++this.tile.modified;
                    break;
                }
                case 21: {
                    if (this.tile.selMod == null || !this.tile.selMod.type.conType(this.tile.selMod.selCon)) break;
                    CircuitDesigner.Con c = this.tile.selMod.cons[this.tile.selMod.selCon];
                    int i = c.type == 1 ? 0 : c.size / 8;
                    if ((i = (i + ((Integer)obj == 0 ? 1 : 4)) % 5) == 0) {
                        c.mod = null;
                        c.addr = -1;
                        c.size = 0;
                        c.type = 1;
                    } else {
                        if (c.type == 1) {
                            c.mod = this.tile.selMod;
                            c.addr = 0;
                            c.type = (byte)2;
                        }
                        c.size = i * 8;
                    }
                    ++this.tile.modified;
                    break;
                }
                case 22: {
                    if (this.tile.selMod == null) break;
                    if (this.tile.selMod.type == CircuitDesigner.ModuleType.IN) {
                        try {
                            int n = Integer.parseInt((String)obj);
                            if (n <= 0) {
                                n = 1;
                            } else if (n > 32) {
                                n = 32;
                            } else if (n > 8) {
                                n &= 0xF8;
                            }
                            this.tile.selMod.resize(n);
                            ++this.tile.modified;
                        }
                        catch (NumberFormatException n) {}
                        break;
                    }
                    CircuitDesigner.Con c = this.tile.selMod.cons[this.tile.selMod.selCon];
                    if (c == null || c.type != 1) break;
                    try {
                        c.size = Integer.parseInt((String)obj);
                        ++this.tile.modified;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case 23: {
                    if (this.tile.selMod == null) break;
                    this.tile.selMod.label = (String)obj;
                    ++this.tile.modified;
                    break;
                }
                case 24: {
                    CircuitDesigner.Con c;
                    if (this.tile.selMod == null || (c = this.tile.selMod.cons[this.tile.selMod.selCon]) == null || c.type < 2) break;
                    c.type = (byte)(5 - c.type);
                    ++this.tile.modified;
                    break;
                }
                case 25: {
                    this.tile.renderAll = !this.tile.renderAll;
                    break;
                }
                case 26: {
                    PacketBuffer dos = this.tile.getPacketTargetData();
                    dos.writeByte(3);
                    this.tile.name = (String)obj;
                    dos.func_180714_a(this.tile.name);
                    BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
                    break;
                }
                case 27: {
                    if (GuiCircuitDesigner.func_146272_n()) {
                        this.saveAsFile();
                        break;
                    }
                    PacketBuffer dos = this.tile.getPacketTargetData();
                    dos.writeByte(1);
                    BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
                    break;
                }
                case 28: {
                    if (GuiCircuitDesigner.func_146272_n()) {
                        this.readAsFile();
                        break;
                    }
                    PacketBuffer dos = this.tile.getPacketTargetData();
                    dos.writeByte(2);
                    BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
                    break;
                }
                case 29: {
                    this.tile.mode = !this.tile.mode;
                    this.tile.selMod = null;
                }
            }
        }
    }

    protected void func_73869_a(char c, int k) throws IOException {
        if (k == 201 && this.scroll > 0) {
            --this.scroll;
        } else if (k == 209 && (float)this.scroll < 24.0f) {
            ++this.scroll;
        } else if (k == 211) {
            this.setDisplVar(18, null, false);
        }
        super.func_73869_a(c, k);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.tile.modified != 0L) {
            this.save();
        }
    }

    public void func_73876_c() {
        if (this.tile.modified != 0L) {
            this.save();
        }
        super.func_73876_c();
    }

    private void save() {
        this.tile.modified = 0L;
        PacketBuffer dos = this.tile.getPacketTargetData();
        dos.writeByte(0);
        dos.writeBytes(this.tile.serialize());
        BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
    }

    private void saveAsFile() {
        if (this.tile.name.isEmpty()) {
            this.sendChat(TooltipInfo.format((String)"gui.cd4017be.designer.noname", (Object[])new Object[0]));
        }
        File file = new File(Minecraft.func_71410_x().field_71412_D, "circuitSchematics/" + this.tile.name + ".dat");
        try {
            ByteBuf data = this.tile.serialize();
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            data.readBytes((OutputStream)fos, data.writerIndex());
            fos.close();
            this.sendChat(TooltipInfo.format((String)"gui.cd4017be.designer.saved", (Object[])new Object[]{file}));
        }
        catch (Exception e) {
            this.sendChat(e.toString());
        }
    }

    private void readAsFile() {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "circuitSchematics/" + this.tile.name + ".dat");
        try {
            int i;
            FileInputStream fis = new FileInputStream(file);
            ByteBuf data = Unpooled.buffer();
            while ((i = fis.available()) > 0) {
                data.writeBytes((InputStream)fis, i);
            }
            fis.close();
            this.tile.deserialize(data);
            ++this.tile.modified;
            this.sendChat(TooltipInfo.format((String)"gui.cd4017be.designer.loaded", (Object[])new Object[]{file}));
        }
        catch (FileNotFoundException e) {
            this.sendChat(TooltipInfo.format((String)"gui.cd4017be.designer.notFound", (Object[])new Object[]{file}));
        }
        catch (Exception e) {
            this.sendChat(e.toString());
        }
    }

    private void drawSmallNum(int x, int y, int i, int w) {
        char[] cs = Integer.toString(i).toCharArray();
        if (cs.length > w) {
            int scale = (cs.length + w - 1) / w;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)(1.0f / (float)scale), (float)(1.0f / (float)scale), (float)1.0f);
            x *= scale;
            y *= scale;
        }
        for (char c : cs) {
            this.func_73729_b(x, y, c == '-' ? 232 : 192 + 4 * (c - 48), 250, 4, 6);
            x += 4;
        }
        if (cs.length > w) {
            GlStateManager.func_179121_F();
        }
    }

    class WorkPane
    extends GuiMachine.GuiComp<Object> {
        int targetPos;

        public WorkPane(int id, int px, int py, int h) {
            super((GuiMachine)GuiCircuitDesigner.this, id, px, py, 192, h * 16);
            this.targetPos = -1;
        }

        public void draw() {
            GuiCircuitDesigner.this.field_146297_k.field_71446_o.func_110577_a(COMP_TEX);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179143_c((int)519);
            GuiCircuitDesigner.this.field_73735_i = 0.5f;
            GuiCircuitDesigner.this.func_73729_b(this.px, this.py, 0, 0, this.w, this.h / 2);
            GuiCircuitDesigner.this.func_73729_b(this.px, this.py + this.h / 2, 0, 0, this.w, this.h / 2);
            GlStateManager.func_179143_c((int)514);
            GlStateManager.func_179147_l();
            Object mod = ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.module0;
            while (mod != null) {
                if (((CircuitDesigner.Module)mod).nextPos > GuiCircuitDesigner.this.scroll * 8 && ((CircuitDesigner.Module)mod).pos < GuiCircuitDesigner.this.scroll * 8 + this.h / 2) {
                    int x1 = this.px + (((CircuitDesigner.Module)mod).pos & 7) * 24;
                    int y1 = this.py + ((((CircuitDesigner.Module)mod).pos >> 3) - GuiCircuitDesigner.this.scroll) * 16;
                    int t = ((CircuitDesigner.Module)mod).type.ordinal();
                    if (((CircuitDesigner.Module)mod).type.idxLoc > 0) {
                        GuiCircuitDesigner.this.func_73729_b(x1, y1, 0, 128 + (t - 10) * 16, 192, 16);
                        for (int i = 8; i < ((CircuitDesigner.Module)mod).size; i += 8) {
                            GuiCircuitDesigner.this.func_73729_b(x1, y1 + i * 2, 0, 240, 192, 16);
                        }
                        float dx = 192.0f / (float)(((CircuitDesigner.Module)mod).cons.length + 1);
                        float x = (float)(x1 - 8) + dx;
                        int i = 0;
                        while (i < ((CircuitDesigner.Module)mod).cons.length) {
                            CircuitDesigner.Con c = ((CircuitDesigner.Module)mod).cons[i];
                            if (c != null && c.type == 1) {
                                GuiCircuitDesigner.this.drawSmallNum((int)x + 13, y1 + 9, c.size, 8);
                            }
                            ++i;
                            x += dx;
                        }
                    } else if (((CircuitDesigner.Module)mod).type == CircuitDesigner.ModuleType.IN) {
                        if (((CircuitDesigner.Module)mod).size < 8) {
                            GuiCircuitDesigner.this.func_73729_b(x1, y1, 192, 160, 24, 16);
                            for (int i = 1; i < ((CircuitDesigner.Module)mod).size; ++i) {
                                GuiCircuitDesigner.this.func_73729_b(x1 + i * 24, y1, 192, 176, 24, 16);
                            }
                        } else {
                            GuiCircuitDesigner.this.func_73729_b(x1, y1, 0, 96, 192, 16);
                            for (int i = 8; i < ((CircuitDesigner.Module)mod).size; i += 8) {
                                GuiCircuitDesigner.this.func_73729_b(x1, y1 + i * 2, 0, 112, 192, 16);
                            }
                        }
                    } else {
                        GuiCircuitDesigner.this.func_73729_b(x1, y1, 192, t * 16, 24, 16);
                        if (((CircuitDesigner.Module)mod).type.ordinal() >= 6 || ((CircuitDesigner.Module)mod).type.ordinal() < 10) {
                            for (CircuitDesigner.Con c : ((CircuitDesigner.Module)mod).cons) {
                                if (c != null && c.type == 1) {
                                    GuiCircuitDesigner.this.drawSmallNum(x1 + 2, y1 + 2, c.size, 2);
                                }
                                x1 += 13;
                            }
                        }
                    }
                }
                mod = ((CircuitDesigner.Module)mod).next;
            }
            if (((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.renderAll) {
                mod = ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.module0;
                while (mod != null) {
                    this.drawModuleCons((CircuitDesigner.Module)mod);
                    mod = ((CircuitDesigner.Module)mod).next;
                }
            }
            if (((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod != null && (((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.mode || !((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.renderAll)) {
                this.drawModuleCons(((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod);
            }
            if (((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.mode) {
                for (CircuitDesigner.Module mod2 : ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.outputs) {
                    int i;
                    int x1 = this.px + (mod2.pos & 7) * 24;
                    int y1 = this.py + ((mod2.pos >> 3) - GuiCircuitDesigner.this.scroll) * 16;
                    if (mod2.size < 8) {
                        GuiCircuitDesigner.this.func_73729_b(x1, y1, 216, 160, 24, 16);
                        for (i = 1; i < mod2.size; ++i) {
                            GuiCircuitDesigner.this.func_73729_b(x1 + i * 24, y1, 216, 176, 24, 16);
                        }
                        continue;
                    }
                    GuiCircuitDesigner.this.func_73729_b(x1, y1, 0, 64, 192, 16);
                    for (i = 8; i < mod2.size; i += 8) {
                        GuiCircuitDesigner.this.func_73729_b(x1, y1 + i * 2, 0, 80, 192, 16);
                    }
                }
            }
            if (this.targetPos >= 0) {
                int x1 = this.px + (this.targetPos & 7) * 24;
                int y1 = this.py + ((this.targetPos >> 3) - GuiCircuitDesigner.this.scroll) * 16;
                GuiCircuitDesigner.this.func_73729_b(x1, y1, 192, 224, 24, 16);
            }
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GuiCircuitDesigner.this.field_73735_i = 0.0f;
        }

        private void drawModuleCons(CircuitDesigner.Module m) {
            int x1 = this.px + (m.pos & 7) * 24;
            int y1 = this.py + ((m.pos >> 3) - GuiCircuitDesigner.this.scroll) * 16;
            if (m == ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod) {
                GuiCircuitDesigner.this.func_73729_b(x1, y1, 192, 208, 24, 16);
            }
            GlStateManager.func_179090_x();
            VertexBuffer vb = Tessellator.func_178181_a().func_178180_c();
            vb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            double dx = (m.type.idxLoc > 0 ? 192.0 : 24.0) / (double)(m.cons.length + 1);
            double x2 = (double)x1 + dx;
            y1 += 12;
            if (m == ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod && m.type != CircuitDesigner.ModuleType.IN) {
                vb.func_181662_b(x2 + dx * (double)m.selCon, (double)(y1 - 1), (double)GuiCircuitDesigner.this.field_73735_i).func_181669_b(255, 0, 0, 255).func_181675_d();
                vb.func_181662_b(x2 + dx * (double)m.selCon, (double)(y1 + 1), (double)GuiCircuitDesigner.this.field_73735_i).func_181669_b(255, 0, 0, 255).func_181675_d();
            }
            int a = 255;
            int i = 0;
            while (i < m.cons.length) {
                CircuitDesigner.Con c = m.cons[i];
                if (c != null && c.addr >= 0) {
                    int addr;
                    int r;
                    int n = r = m == ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod && i == m.selCon ? 255 : 0;
                    if (c.type == 0) {
                        vb.func_181662_b(x2, (double)y1, (double)GuiCircuitDesigner.this.field_73735_i).func_181669_b(r, 0, 255, a).func_181675_d();
                        addr = c.getAddr();
                        vb.func_181662_b((double)(this.px + (addr & 7) * 24 + 22), (double)(this.py + ((addr >> 3) - GuiCircuitDesigner.this.scroll) * 16 + 8), (double)GuiCircuitDesigner.this.field_73735_i).func_181669_b(r, 0, 255, a).func_181675_d();
                    } else {
                        addr = c.getAddr();
                        int n2 = c.size / 8;
                        while (n2 > 0) {
                            vb.func_181662_b(x2, (double)y1, (double)GuiCircuitDesigner.this.field_73735_i).func_181669_b(r, 255, 128, a).func_181675_d();
                            vb.func_181662_b((double)(this.px + (addr & 7) * 24 + 188), (double)(this.py + ((addr >> 3) - GuiCircuitDesigner.this.scroll) * 16 + 8), (double)GuiCircuitDesigner.this.field_73735_i).func_181669_b(r, 255, 128, a).func_181675_d();
                            --n2;
                            addr += 8;
                        }
                    }
                }
                ++i;
                x2 += dx;
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179098_w();
        }

        public void drawOverlay(int x, int y) {
            int mp = (x - this.px) / 24 + ((y - this.py) / 16 + GuiCircuitDesigner.this.scroll) * 8;
            ArrayList<String> list = new ArrayList<String>();
            for (CircuitDesigner.Module m : ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.outputs) {
                if (m.pos > mp || m.nextPos <= mp || m.label.isEmpty()) continue;
                list.add(m.label);
            }
            CircuitDesigner.Module m = GuiCircuitDesigner.this.tile.find(((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.module0, mp, false);
            if (m != null && !m.label.isEmpty()) {
                list.add(m.label);
            }
            list.add(String.format("%d_%02X", mp / 8, mp));
            GuiCircuitDesigner.this.func_146283_a(list, x, y);
        }

        public boolean mouseIn(int x, int y, int b, int d) {
            if (d == 3 && ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod != null) {
                if (((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.type == CircuitDesigner.ModuleType.IN) {
                    return true;
                }
                ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.selCon += b + ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.cons.length;
                ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.selCon %= ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.cons.length;
                return true;
            }
            int mp = (x - this.px) / 24 + ((y - this.py) / 16 + GuiCircuitDesigner.this.scroll) * 8;
            if (d == 1 && b == 0 && ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod != null) {
                this.targetPos = this.targetPos >= 0 || mp == ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.pos ? mp : -1;
                return true;
            }
            if (d == 2 && b == 0) {
                GuiCircuitDesigner.this.setFocus(-1);
            }
            this.targetPos = -1;
            if (d != 0) {
                return true;
            }
            if (((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.mode) {
                for (CircuitDesigner.Module m : ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.outputs) {
                    if (m.pos > mp || m.nextPos <= mp) continue;
                    ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod = m;
                    return true;
                }
                ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod = null;
            } else {
                CircuitDesigner.Module m = GuiCircuitDesigner.this.tile.find(((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.module0, mp, false);
                if (b == 0) {
                    ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod = m;
                } else if (b == 1 && ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod != null && ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.type != CircuitDesigner.ModuleType.IN) {
                    CircuitDesigner.Con c;
                    boolean t = ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.type.conType(((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.selCon);
                    if (t) {
                        mp &= 0xF8;
                    }
                    if (m != null) {
                        mp -= m.pos;
                    }
                    if ((c = ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.cons[((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.selCon]) == null) {
                        c = new CircuitDesigner.Con(m, mp, 1, 0);
                    } else if (c.getAddr() == mp && c.type == 0) {
                        c = null;
                    } else {
                        c.mod = m;
                        c.addr = mp;
                        if (c.type == 1) {
                            c.type = (byte)2;
                            c.size = 8;
                        }
                    }
                    ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.cons[((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.selCon] = c;
                    ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.modified = 1L;
                }
            }
            return true;
        }

        public void unfocus() {
            if (this.targetPos >= 0 && ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod != null && this.targetPos != ((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod.pos) {
                GuiCircuitDesigner.this.tile.move(((GuiCircuitDesigner)GuiCircuitDesigner.this).tile.selMod, this.targetPos);
            }
        }

        public boolean focus() {
            return true;
        }
    }
}

