/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.gui;

import cd4017be.circuits.tileEntity.ArithmeticConverter;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileContainer;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.templates.GuiMachine;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiArithmeticConverter
extends GuiMachine {
    private final ArithmeticConverter tileEntity;
    private int sel = -1;
    private GuiMachine.TextField text = new GuiMachine.TextField((GuiMachine)this, "", 4);

    public GuiArithmeticConverter(ArithmeticConverter tileEntity, EntityPlayer player) {
        super((Container)new TileContainer((ModTileEntity)tileEntity, player));
        this.tileEntity = tileEntity;
    }

    public void initGui() {
        this.xSize = 56;
        this.ySize = 85;
        super.initGui();
    }

    protected void drawGuiContainerForegroundLayer(int mx, int my) {
        super.drawGuiContainerForegroundLayer(mx, my);
        this.drawInfo(21, 15, 28, 9, new String[]{"\\i", "rs.const"});
        this.drawInfo(11, 24, 9, 54, new String[]{"\\i", "rs.dir"});
        this.drawInfo(21, 24, 20, 54, new String[]{"\\i", "rs.filter"});
        if (this.isPointInRegion(12, 25, 7, 52, mx, my)) {
            int s = (my - this.guiTop - 25) / 9;
            this.drawSideCube(-64, 15, s, (byte)(this.tileEntity.getConfig(s | 8) + 2));
        }
    }

    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(new ResourceLocation("circuits", "textures/gui/circuit.png"));
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 192, 80, this.xSize, this.ySize);
        int x = this.guiLeft + 11;
        int y = this.guiTop + 15;
        for (int i = 0; i < 6; ++i) {
            int c = this.tileEntity.getConfig(i | 8);
            this.drawTexturedModalRect(x, y + 9 + i * 9, 242, c * 9, 9, 9);
        }
        x = this.guiLeft + 22;
        for (int i = 0; i < 7; ++i) {
            y = this.guiTop + 25 + i * 9;
            if (i == 6) {
                y -= 63;
            }
            if (i == this.sel) {
                this.text.draw(x, y, 0x80FFFF, -32640);
                continue;
            }
            String s = Integer.toString(this.tileEntity.getConfig(i));
            this.fontRendererObj.func_78276_b(s, x, y, 0x80FFFF);
        }
        this.drawStringCentered(this.tileEntity.getName(), this.guiLeft + this.xSize / 2, this.guiTop + 4, 0x404040);
    }

    protected void keyTyped(char c, int k) throws IOException {
        if (this.sel >= 0) {
            byte r = this.text.keyTyped(c, k);
            if (r == 1) {
                this.setTextField(-1);
            } else if (r >= 0) {
                this.setTextField((this.sel + r + 6) % 7);
            }
        } else {
            super.keyTyped(c, k);
        }
    }

    protected void mouseClicked(int x, int y, int b) throws IOException {
        boolean a = false;
        int k = (y - this.guiTop - 15) / 9 - 1;
        if (k == -1) {
            k = 6;
        } else if (k < 0 || k > 6) {
            k = -1;
        }
        if (this.isPointInRegion(11, 15, 9, 63, x, y) && b == 0 && k < 6) {
            this.tileEntity.netData.longs[0] = this.tileEntity.netData.longs[0] ^ 1L << 58 + k;
            a = true;
        }
        if (!this.isPointInRegion(21, 15, 20, 63, x, y)) {
            k = -1;
        }
        if (k != this.sel) {
            this.setTextField(k);
        } else if (a) {
            this.sendCurrentChange();
        } else {
            super.mouseClicked(x, y, b);
        }
    }

    private void setTextField(int k) throws IOException {
        if (k == this.sel) {
            return;
        }
        if (this.sel >= 0) {
            try {
                this.tileEntity.setConfig(this.sel, Integer.parseInt(this.text.text));
                this.sendCurrentChange();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (k >= 0) {
            this.text.text = Integer.toString(this.tileEntity.getConfig(k));
            this.text.cur = this.sel < 0 ? this.text.text.length() : Math.min(this.text.cur, this.text.text.length());
        }
        this.sel = k;
    }

    private void sendCurrentChange() throws IOException {
        PacketBuffer dos = this.tileEntity.getPacketTargetData();
        dos.writeByte(AutomatedTile.CmdOffset);
        dos.writeLong(this.tileEntity.netData.longs[0]);
        BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
    }
}

