/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.TileBlock;
import cd4017be.lib.templates.IPipe;
import cd4017be.lib.util.PropertyBlock;
import cd4017be.lib.util.PropertyByte;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockPipe
extends TileBlock {
    public static final PropertyByte[] CONS = new PropertyByte[6];
    public static final PropertyByte CORE = new PropertyByte("core");
    public static final PropertyBlock COVER = new PropertyBlock("cover");
    public static final IUnlistedProperty[] RENDER_PROPS;
    public float size = 0.25f;
    private boolean keepBB = false;

    public BlockPipe(String id, Material m, Class<? extends ItemBlock> item, int type) {
        super(id, m, item, type);
    }

    @Override
    protected BlockState func_180661_e() {
        ArrayList<IProperty> main = new ArrayList<IProperty>();
        this.addProperties(main);
        return new ExtendedBlockState((Block)this, main.toArray(new IProperty[main.size()]), RENDER_PROPS);
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe) {
            IPipe pipe = (IPipe)te;
            state = state.withProperty((IUnlistedProperty)CORE, (Object)((byte)pipe.textureForSide((byte)-1)));
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                state = state.withProperty((IUnlistedProperty)CONS[i], (Object)((byte)pipe.textureForSide(i)));
            }
            IPipe.Cover cover = pipe.getCover();
            if (cover != null) {
                state = state.withProperty((IUnlistedProperty)COVER, (Object)cover.block.func_177230_c().getExtendedState(cover.block, world, pos));
            }
            return state;
        }
        return state.withProperty((IUnlistedProperty)CORE, (Object)((byte)this.func_176201_c(oldState)));
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        if (this.keepBB) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        float f1 = (1.0f - this.size) / 2.0f;
        float f2 = (1.0f + this.size) / 2.0f;
        float[] bb = new float[]{f1, f2, f1, f2, f1, f2};
        if (te != null && te instanceof IPipe) {
            IPipe pipe = (IPipe)te;
            IPipe.Cover cover = pipe.getCover();
            if (cover != null) {
                bb = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
            } else {
                for (byte s = 0; s < 6; s = (byte)(s + 1)) {
                    if (pipe.textureForSide(s) == -1) continue;
                    bb[s] = (s & 1) == 0 ? 0.0f : 1.0f;
                }
            }
        }
        this.func_149676_a(bb[4], bb[0], bb[2], bb[5], bb[1], bb[3]);
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)world, pos);
        return super.func_180640_a(world, pos, state);
    }

    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        return this.func_180640_a(world, pos, world.func_180495_p(pos));
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB area, List<AxisAlignedBB> list, Entity entity) {
        TileEntity te = world.func_175625_s(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (te != null && te instanceof IPipe && ((IPipe)te).getCover() != null) {
            AxisAlignedBB box = new AxisAlignedBB((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0);
            if (area.func_72326_a(box)) {
                list.add(box);
            }
            return;
        }
        this.func_180654_a((IBlockAccess)world, pos);
        double d0 = (1.0f - this.size) / 2.0f;
        double d1 = (1.0f + this.size) / 2.0f;
        AxisAlignedBB box = new AxisAlignedBB((double)x + this.field_149759_B, (double)y + d0, (double)z + d0, (double)x + this.field_149755_E, (double)y + d1, (double)z + d1);
        if (box.func_72326_a(area)) {
            list.add(box);
        }
        if ((this.field_149760_C < d0 || this.field_149756_F > d1) && (box = new AxisAlignedBB((double)x + d0, (double)y + this.field_149760_C, (double)z + d0, (double)x + d1, (double)y + this.field_149756_F, (double)z + d1)).func_72326_a(area)) {
            list.add(box);
        }
        if ((this.field_149754_D < d0 || this.field_149757_G > d1) && (box = new AxisAlignedBB((double)x + d0, (double)y + d0, (double)z + this.field_149754_D, (double)x + d1, (double)y + d1, (double)z + this.field_149757_G)).func_72326_a(area)) {
            list.add(box);
        }
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 v0, Vec3 v1) {
        MovingObjectPosition pos1;
        MovingObjectPosition pos0;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe && ((IPipe)te).getCover() != null) {
            return super.func_180636_a(world, pos, v0, v1);
        }
        this.func_180654_a((IBlockAccess)world, pos);
        try {
            this.keepBB = true;
            double d0 = (1.0f - this.size) / 2.0f;
            double d1 = (1.0f + this.size) / 2.0f;
            double y0 = this.field_149760_C;
            double y1 = this.field_149756_F;
            double z0 = this.field_149754_D;
            double z1 = this.field_149757_G;
            this.field_149760_C = d0;
            this.field_149756_F = d1;
            this.field_149754_D = d0;
            this.field_149757_G = d1;
            pos0 = super.func_180636_a(world, pos, v0, v1);
            this.field_149759_B = d0;
            this.field_149755_E = d1;
            this.field_149760_C = y0;
            this.field_149756_F = y1;
            pos1 = super.func_180636_a(world, pos, v0, v1);
            if (pos1 != null && (pos0 == null || pos0.field_72307_f.func_72436_e(v0) > pos1.field_72307_f.func_72436_e(v0))) {
                pos0 = pos1;
            }
            this.field_149760_C = d0;
            this.field_149756_F = d1;
            this.field_149754_D = z0;
            this.field_149757_G = z1;
            pos1 = super.func_180636_a(world, pos, v0, v1);
            this.keepBB = false;
        }
        catch (RuntimeException e) {
            this.keepBB = false;
            throw e;
        }
        return pos1 != null && (pos0 == null || pos0.field_72307_f.func_72436_e(v0) > pos1.field_72307_f.func_72436_e(v0)) ? pos1 : pos0;
    }

    public boolean isNormalCube(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te instanceof IPipe && ((IPipe)te).getCover() != null;
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isNormalCube(world, pos);
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176212_b(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isNormalCube(world, pos);
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IPipe.Cover cover;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe && (cover = ((IPipe)te).getCover()) != null) {
            return cover.block.func_177230_c().func_149662_c();
        }
        return false;
    }

    public float func_176195_g(World world, BlockPos pos) {
        Block block;
        IPipe.Cover cover;
        float h = this.field_149782_v;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe && (cover = ((IPipe)te).getCover()) != null && (block = cover.block.func_177230_c()) != null) {
            float h1 = block.func_176195_g(world, new BlockPos(0, -1, 0));
            h = h1 < 0.0f ? -1.0f : (h += h1);
        }
        return h;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity ex, Explosion expl) {
        Block block;
        IPipe.Cover cover;
        float h = this.func_149638_a(ex);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IPipe && (cover = ((IPipe)te).getCover()) != null && (block = cover.block.func_177230_c()) != null) {
            h += block.func_149638_a(ex);
        }
        return h;
    }

    public float func_149685_I() {
        return 1.0f;
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return this.isNormalCube(world, pos) ? 255 : 0;
    }

    static {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(CORE);
        for (int i = 0; i < 6; ++i) {
            BlockPipe.CONS[i] = new PropertyByte("con" + i);
            list.add(CONS[i]);
        }
        list.add(COVER);
        RENDER_PROPS = list.toArray(new IUnlistedProperty[list.size()]);
    }
}

