/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.render.CombinedModel;
import cd4017be.lib.templates.BlockPipe;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ModelPipe
implements IModel {
    public static final String[] sides = new String[]{"B", "T", "N", "S", "W", "E"};
    public final ArrayList<ResourceLocation> dependencies;
    public final String path;

    public ModelPipe(String path, int Ncores, int Ncons) {
        int i;
        this.path = path;
        this.dependencies = new ArrayList();
        for (i = 0; i < Ncores; ++i) {
            this.dependencies.add((ResourceLocation)new ModelResourceLocation(path, "core" + i));
        }
        for (i = 0; i < Ncons; ++i) {
            for (String side : sides) {
                this.dependencies.add((ResourceLocation)new ModelResourceLocation(path, "con" + i + side));
            }
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.dependencies;
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedPipe(format, this.path);
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    public static class BakedPipe
    implements ISmartBlockModel,
    IFlexibleBakedModel {
        private final VertexFormat format;
        private final String path;

        public BakedPipe(VertexFormat format, String path) {
            this.format = format;
            this.path = path;
        }

        public List<BakedQuad> func_177551_a(EnumFacing p_177551_1_) {
            return Collections.emptyList();
        }

        public List<BakedQuad> func_177550_a() {
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_177553_d() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(new ModelResourceLocation(this.path, "core0")).func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }

        public IBakedModel handleBlockState(IBlockState state) {
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exts = (IExtendedBlockState)state;
                IBlockState block = (IBlockState)exts.getValue((IUnlistedProperty)BlockPipe.COVER);
                if (block != null) {
                    IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(block);
                    if (model instanceof ISmartBlockModel) {
                        model = ((ISmartBlockModel)model).handleBlockState(block);
                    }
                    return model;
                }
                ModelManager manager = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b();
                Byte type = (Byte)exts.getValue((IUnlistedProperty)BlockPipe.CORE);
                CombinedModel model = null;
                if (type != null && type >= 0) {
                    model = new CombinedModel(manager.func_174953_a(new ModelResourceLocation(this.path, "core" + type.toString())));
                }
                for (int i = 0; i < 6; ++i) {
                    type = (Byte)exts.getValue((IUnlistedProperty)BlockPipe.CONS[i]);
                    if (type == null || type < 0) continue;
                    if (model == null) {
                        model = new CombinedModel(manager.func_174953_a(new ModelResourceLocation(this.path, "con" + type.toString() + sides[i])));
                        continue;
                    }
                    model.add(manager.func_174953_a(new ModelResourceLocation(this.path, "con" + type.toString() + sides[i])));
                }
                if (model != null) {
                    return model;
                }
            }
            return this;
        }

        public VertexFormat getFormat() {
            return this.format;
        }
    }
}

