/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.util.vector.Vector3f;

public class CombinedModel
implements IBakedModel {
    public static final ModelRotation[] Rotations = new ModelRotation[]{ModelRotation.X90_Y0, ModelRotation.X270_Y0, ModelRotation.X0_Y0, ModelRotation.X0_Y180, ModelRotation.X0_Y270, ModelRotation.X0_Y90};
    private final IBakedModel origin;
    private ArrayList<BakedQuad>[] quads = new ArrayList[7];

    public CombinedModel(IBakedModel origin) {
        this.origin = origin;
        for (int i = 0; i < this.quads.length; ++i) {
            this.quads[i] = new ArrayList();
        }
        this.add(origin);
    }

    public CombinedModel add(IBakedModel model) {
        for (int i = 0; i < 6; ++i) {
            this.quads[i].addAll(model.func_177551_a(EnumFacing.field_82609_l[i]));
        }
        this.quads[6].addAll(model.func_177550_a());
        return this;
    }

    public CombinedModel addRotated(IBakedModel model, ModelRotation rot) {
        if (rot == ModelRotation.X0_Y0) {
            return this.add(model);
        }
        Vector3f v = new Vector3f();
        Matrix4f m = rot.getMatrix();
        for (int j = 0; j < this.quads.length; ++j) {
            List list;
            List list2 = list = j < 6 ? model.func_177551_a(rot.rotate(EnumFacing.field_82609_l[j])) : model.func_177550_a();
            if (list == null || list.isEmpty()) continue;
            for (BakedQuad q : list) {
                int[] data = new int[28];
                System.arraycopy(q.func_178209_a(), 0, data, 0, data.length);
                for (int i = 0; i < data.length; i += 7) {
                    v.set(Float.intBitsToFloat(data[i]), Float.intBitsToFloat(data[i + 1]), Float.intBitsToFloat(data[i + 2]));
                    ForgeHooksClient.transform((Vector3f)v, (Matrix4f)m);
                    data[i] = Float.floatToRawIntBits(v.x);
                    data[i + 1] = Float.floatToRawIntBits(v.y);
                    data[i + 2] = Float.floatToRawIntBits(v.z);
                }
                this.quads[j].add(new BakedQuad(data, q.func_178211_c(), rot.rotate(q.func_178210_d())));
            }
        }
        return this;
    }

    public List<BakedQuad> func_177551_a(EnumFacing face) {
        return this.quads[face.func_176745_a()];
    }

    public List<BakedQuad> func_177550_a() {
        return this.quads[6];
    }

    public boolean func_177555_b() {
        return this.origin.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.origin.func_177556_c();
    }

    public boolean func_177553_d() {
        return this.origin.func_177553_d();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.origin.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.origin.func_177552_f();
    }
}

