/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.util.Utils;
import java.io.IOException;
import java.util.BitSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityData {
    public final int variables;
    public final long[] longs;
    public final int[] ints;
    public final float[] floats;
    public final FluidStack[] fluids;

    public TileEntityData(TileEntityData ref) {
        this.longs = new long[ref.longs.length];
        this.ints = new int[ref.ints.length];
        this.floats = new float[ref.floats.length];
        this.fluids = new FluidStack[ref.fluids.length];
        this.variables = ref.variables;
    }

    public TileEntityData(int b, int i, int f, int l) {
        this.longs = new long[b];
        this.ints = new int[i];
        this.floats = new float[f];
        this.fluids = new FluidStack[l];
        this.variables = b + i + f + l;
    }

    public BitSet detectChanges(TileEntityData old, boolean setAll) {
        BitSet reg = new BitSet(this.variables);
        int var = 0;
        int i = 0;
        while (i < this.longs.length) {
            if (this.longs[i] != old.longs[i]) {
                reg.set(var);
                old.longs[i] = this.longs[i];
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.ints.length) {
            if (this.ints[i] != old.ints[i]) {
                reg.set(var);
                old.ints[i] = this.ints[i];
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.floats.length) {
            if (this.floats[i] != old.floats[i]) {
                reg.set(var);
                old.floats[i] = this.floats[i];
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.fluids.length) {
            if (!Utils.fluidsEqual(this.fluids[i], old.fluids[i], true)) {
                reg.set(var);
                old.fluids[i] = this.fluids[i] == null ? null : this.fluids[i].copy();
            }
            ++i;
            ++var;
        }
        if (setAll) {
            reg.set(0, this.variables);
        }
        return reg;
    }

    public void writeData(PacketBuffer dos, BitSet reg) throws IOException {
        TileEntityData.writeBitsToStream(reg, this.variables, dos);
        int var = 0;
        int i = 0;
        while (i < this.longs.length) {
            if (reg.get(var)) {
                dos.writeLong(this.longs[i]);
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.ints.length) {
            if (reg.get(var)) {
                dos.writeInt(this.ints[i]);
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.floats.length) {
            if (reg.get(var)) {
                dos.writeFloat(this.floats[i]);
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.fluids.length) {
            if (reg.get(var)) {
                NBTTagCompound nbt = new NBTTagCompound();
                if (this.fluids[i] != null) {
                    this.fluids[i].writeToNBT(nbt);
                } else {
                    nbt.func_74778_a("FluidName", "null");
                }
                dos.func_150786_a(nbt);
            }
            ++i;
            ++var;
        }
    }

    public void readData(PacketBuffer data) throws IOException {
        BitSet reg = new BitSet();
        TileEntityData.readBitsFromStream(reg, this.variables, data);
        int var = 0;
        int i = 0;
        while (i < this.longs.length) {
            if (reg.get(var)) {
                this.longs[i] = data.readLong();
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.ints.length) {
            if (reg.get(var)) {
                this.ints[i] = data.readInt();
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.floats.length) {
            if (reg.get(var)) {
                this.floats[i] = data.readFloat();
            }
            ++i;
            ++var;
        }
        i = 0;
        while (i < this.fluids.length) {
            if (reg.get(var)) {
                this.fluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_150793_b());
            }
            ++i;
            ++var;
        }
    }

    public static void writeBitsToStream(BitSet set, int l, PacketBuffer dos) throws IOException {
        byte[] data = new byte[(l + 7) / 8];
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            int j = 1;
            while (j < 256) {
                if (set.get(n)) {
                    int n2 = i;
                    data[n2] = (byte)(data[n2] | j);
                }
                j <<= 1;
                ++n;
            }
        }
        dos.writeBytes(data);
    }

    public static void readBitsFromStream(BitSet set, int l, PacketBuffer dis) throws IOException {
        byte[] data = new byte[(l + 7) / 8];
        dis.readBytes(data);
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            int j = 1;
            while (j < 256) {
                if ((data[i] & j) != 0) {
                    set.set(n);
                }
                j <<= 1;
                ++n;
            }
        }
    }
}

