/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.DefaultBlock;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileBlockRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileBlock
extends DefaultBlock
implements ITileEntityProvider {
    public static final Orientation[] Orientations = new Orientation[4];
    protected static int tmpType;
    public int machineId;
    public boolean registered;
    public final Orientation orient;
    private boolean redstone;
    private boolean opaque;
    private int renderType;
    private boolean drop;
    private EnumWorldBlockLayer blockLayer = EnumWorldBlockLayer.SOLID;

    public static TileBlock create(String id, Material m, Class<? extends ItemBlock> item, int type) {
        tmpType = (type & 0xF) % Orientations.length;
        TileBlock block = new TileBlock(id, m, item, type);
        tmpType = 0;
        return block;
    }

    protected TileBlock(String id, Material m, Class<? extends ItemBlock> item, int type) {
        super(id, m, item);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.orient = Orientations[tmpType];
        this.redstone = (type & 0x10) != 0;
        this.opaque = (type & 0x20) == 0;
        this.drop = (type & 0x40) == 0;
        this.renderType = 3;
        if (this.orient != null) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)this.orient.values.get(0)));
        }
    }

    public IBlockState func_176203_a(int meta) {
        if (this.orient != null && this.orient.inRange(meta)) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(meta));
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return this.orient != null ? (Integer)state.func_177229_b((IProperty)this.orient) : 0;
    }

    protected void addProperties(ArrayList<IProperty> main) {
        if (tmpType > 0) {
            main.add(Orientations[tmpType]);
        }
    }

    protected BlockState func_180661_e() {
        ArrayList<IProperty> main = new ArrayList<IProperty>();
        this.addProperties(main);
        return new BlockState((Block)this, main.toArray(new IProperty[main.size()]));
    }

    public TileEntity func_149915_a(World world, int id) {
        TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(this);
        if (entry != null && entry.tileEntity != null) {
            try {
                return entry.tileEntity.newInstance();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing s, float X, float Y, float Z) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).onActivated(player, s, X, Y, Z);
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onClicked(player);
        }
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block b) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onNeighborBlockChange(b);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).breakBlock();
        }
        super.func_180663_b(world, pos, state);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos npos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onNeighborTileChange(npos);
        }
    }

    public boolean func_149744_f() {
        return this.redstone;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return super.isNormalCube(world, pos);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing s, float X, float Y, float Z, int m, EntityLivingBase placer) {
        int h;
        if (this.orient == null) {
            return this.func_176203_a(m);
        }
        if (placer.func_70093_af()) {
            if (this.orient.type == 0 && (s == EnumFacing.DOWN || s == EnumFacing.UP)) {
                return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(Z + X > 1.0f ? (Z > X ? 5 : 7) : (Z < X ? 4 : 6)));
            }
            if (this.orient.type >= 2 && s == EnumFacing.DOWN) {
                return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(Z + X > 1.0f ? (Z > X ? 1 : 3) : (Z < X ? 0 : 2)));
            }
            if (this.orient.type >= 2 && s == EnumFacing.UP) {
                return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(Z + X > 1.0f ? (Z > X ? 9 : 11) : (Z < X ? 8 : 10)));
            }
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf((s.func_176745_a() ^ 1) + 2));
        }
        int n = placer.field_70125_A > 40.0f ? 1 : (h = placer.field_70125_A < -35.0f ? -1 : 0);
        if (this.orient.type == 1 && h != 0) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(h < 0 ? 2 : 3));
        }
        int d = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (d > 0) {
            d = (d + 1) % 3 + 1;
        }
        if (this.orient.type < 2 || h == 0) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(4 + d));
        }
        if (h < 0) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(d));
        }
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orient, (Comparable)Integer.valueOf(8 + d));
    }

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing s) {
        if (!this.redstone) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).redstoneLevel(s.func_176745_a() ^ 1, false);
        }
        return 0;
    }

    public int func_176211_b(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing s) {
        if (!this.redstone) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).redstoneLevel(s.func_176745_a() ^ 1, true);
        }
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack item) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onPlaced(entity, item);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.func_176199_a(world, pos, entity);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            ((ModTileEntity)te).onEntityCollided(entity);
        }
    }

    public boolean func_149662_c() {
        return this.opaque;
    }

    public boolean func_149686_d() {
        return this.field_149755_E == 1.0 && this.field_149759_B == 0.0 && this.field_149756_F == 1.0 && this.field_149760_C == 0.0 && this.field_149757_G == 1.0 && this.field_149754_D == 0.0;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void setRenderType(int t) {
        this.renderType = t;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        if (this.drop) {
            super.func_180657_a(world, player, pos, state, te);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!this.drop) {
            super.func_180657_a(world, player, pos, state, null);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.drop) {
            return super.getDrops(world, pos, state, fortune);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof ModTileEntity) {
            return ((ModTileEntity)te).dropItem(state, fortune);
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public void setBlockLayer(EnumWorldBlockLayer layer) {
        this.blockLayer = layer;
    }

    public EnumWorldBlockLayer func_180664_k() {
        return this.blockLayer;
    }

    static {
        for (byte i = 0; i < Orientations.length - 1; i = (byte)(i + 1)) {
            TileBlock.Orientations[i + 1] = new Orientation(i);
        }
    }

    public static class Orientation
    implements IProperty<Integer> {
        public static final String[] namesAll = new String[]{"BN", "BS", "BW", "BE", "N", "S", "W", "E", "TN", "TS", "TW", "TE"};
        public static final String[] namesHor = new String[]{"--", "--", "--", "--", "N", "S", "W", "E", "--", "--", "--", "--"};
        public static final String[] namesVert = new String[]{"--", "--", "B", "T", "N", "S", "W", "E", "--", "--", "--", "--"};
        public final byte type;
        public final ArrayList<Integer> values;

        private Orientation(byte type) {
            int i;
            this.type = type;
            int j = type == 0 || type == 1 ? 8 : 12;
            this.values = new ArrayList(j - i);
            for (i = type == 0 ? 4 : (type == 1 ? 2 : 0); i < j; ++i) {
                this.values.add(i);
            }
        }

        public String func_177701_a() {
            return "orient";
        }

        public Collection<Integer> func_177700_c() {
            return this.values;
        }

        public Class<Integer> func_177699_b() {
            return Integer.class;
        }

        public String getName(Integer v) {
            return this.type == 0 ? namesHor[v] : (this.type == 1 ? namesVert[v] : namesAll[v]);
        }

        public boolean inRange(Integer i) {
            return this.type == 0 ? i >= 4 && i < 8 : (this.type == 1 ? i >= 2 && i < 8 : i >= 0 && i < 8);
        }
    }
}

