/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.api.automation.IOperatingArea;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MovedBlock {
    public final NBTTagCompound nbt;
    public final IBlockState block;

    public MovedBlock(IBlockState block, NBTTagCompound tile) {
        this.block = block;
        this.nbt = tile;
    }

    public boolean set(World world, BlockPos pos) {
        TileEntity tile = null;
        boolean multipart = false;
        if (this.nbt != null) {
            this.nbt.func_74768_a("x", pos.func_177958_n());
            this.nbt.func_74768_a("y", pos.func_177956_o());
            this.nbt.func_74768_a("z", pos.func_177952_p());
            multipart = this.nbt.func_74779_i("id").equals("savedMultipart");
            if (multipart) {
                try {
                    Class<?> multipartHelper = Class.forName("codechicken.multipart.MultipartHelper");
                    Method m = multipartHelper.getMethod("createTileFromNBT", World.class, NBTTagCompound.class);
                    tile = (TileEntity)m.invoke(null, world, this.nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                tile = TileEntity.func_145827_c((NBTTagCompound)this.nbt);
                if (tile instanceof IOperatingArea) {
                    int[] area = ((IOperatingArea)tile).getOperatingArea();
                    area[0] = area[0] + pos.func_177958_n();
                    area[3] = area[3] + pos.func_177958_n();
                    area[1] = area[1] + pos.func_177956_o();
                    area[4] = area[4] + pos.func_177956_o();
                    area[2] = area[2] + pos.func_177952_p();
                    area[5] = area[5] + pos.func_177952_p();
                }
            }
        }
        boolean set = MovedBlock.setBlock(world, pos, this.block, tile);
        if (multipart && set) {
            try {
                Class<?> multipartHelper = Class.forName("codechicken.multipart.MultipartHelper");
                multipartHelper.getMethod("sendDescPacket", World.class, TileEntity.class).invoke(null, world, tile);
                Class<?> tileMultipart = Class.forName("codechicken.multipart.TileMultipart");
                tileMultipart.getMethod("onMoved", new Class[0]).invoke((Object)tile, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return set;
    }

    public static MovedBlock get(World world, BlockPos pos) {
        IBlockState id = world.func_180495_p(pos);
        NBTTagCompound nbt = null;
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            if (te instanceof IOperatingArea) {
                int[] area = ((IOperatingArea)te).getOperatingArea();
                area[0] = area[0] - pos.func_177958_n();
                area[3] = area[3] - pos.func_177958_n();
                area[1] = area[1] - pos.func_177956_o();
                area[4] = area[4] - pos.func_177956_o();
                area[2] = area[2] - pos.func_177952_p();
                area[5] = area[5] - pos.func_177952_p();
            }
            nbt = new NBTTagCompound();
            te.func_145841_b(nbt);
        }
        return new MovedBlock(id, nbt);
    }

    public static boolean setBlock(World world, BlockPos pos, IBlockState state, TileEntity tile) {
        int bz;
        int p;
        if (!world.func_175667_e(pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IBlockState state0 = chunk.func_177435_g(pos);
        Block block = state.func_177230_c();
        Block block0 = state0.func_177230_c();
        int oldLight = block0.getLightValue((IBlockAccess)world, pos);
        world.func_175713_t(pos);
        if (state0 == state) {
            world.func_175690_a(pos, tile);
            world.func_175689_h(pos);
            return true;
        }
        int bx = pos.func_177958_n() & 0xF;
        int y = pos.func_177956_o();
        if (y >= chunk.field_76638_b[p = (bz = pos.func_177952_p() & 0xF) << 4 | bx] - 1) {
            chunk.field_76638_b[p] = -999;
        }
        int h = chunk.func_177445_q()[p];
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        ExtendedBlockStorage extendedblockstorage = storageArrays[y >> 4];
        boolean flag = false;
        if (extendedblockstorage == null) {
            if (block == Blocks.field_150350_a) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, !world.field_73011_w.func_177495_o());
            storageArrays[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            flag = y >= h;
        }
        extendedblockstorage.func_177484_a(bx, y & 0xF, bz, state);
        if (extendedblockstorage.func_150819_a(bx, y & 0xF, bz) != block) {
            return false;
        }
        if (flag) {
            chunk.func_76603_b();
        } else {
            int l = block.getLightOpacity((IBlockAccess)world, pos);
            int l0 = block0.getLightOpacity((IBlockAccess)world, pos);
            if (l > 0) {
                if (y >= h) {
                    chunk.func_76615_h(bx, y + 1, bz);
                }
            } else if (y == h - 1) {
                chunk.func_76615_h(bx, y, bz);
            }
            if (l != l0 && (l < l0 || chunk.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0)) {
                chunk.func_76595_e(bx, bz);
            }
        }
        world.func_175690_a(pos, tile);
        chunk.func_177427_f(true);
        if (block.func_149717_k() != block0.func_149717_k() || block.getLightValue((IBlockAccess)world, pos) != oldLight) {
            world.field_72984_F.func_76320_a("checkLight");
            world.func_175664_x(pos);
            world.field_72984_F.func_76319_b();
        }
        world.func_175689_h(pos);
        return true;
    }

    public static void moveEntity(Entity entity, int dim, double x, double y, double z) {
        int dimO = entity.field_70170_p.field_73011_w.func_177502_q();
        if (entity instanceof EntityPlayerMP) {
            if (dim != dimO) {
                MovedBlock.tpPlayerToDim((EntityPlayerMP)entity, dim, x, y, z);
            } else {
                ((EntityPlayerMP)entity).func_70634_a(x, y, z);
            }
        } else if (dim != dimO) {
            entity.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer server = MinecraftServer.func_71276_C();
            WorldServer worldO = server.func_71218_a(dimO);
            WorldServer worldN = server.func_71218_a(dim);
            entity.field_71093_bK = dim;
            entity.field_70170_p.func_72900_e(entity);
            entity.field_70128_L = false;
            entity.field_70170_p.field_72984_F.func_76320_a("reposition");
            MovedBlock.tpEntity(entity, worldO, worldN, x, y, z);
            entity.field_70170_p.field_72984_F.func_76318_c("reloading");
            Entity var6 = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)worldN);
            if (var6 != null) {
                var6.func_180432_n(entity);
                worldN.func_72838_d(var6);
            }
            entity.field_70128_L = true;
            entity.field_70170_p.field_72984_F.func_76319_b();
            worldO.func_82742_i();
            worldN.func_82742_i();
            entity.field_70170_p.field_72984_F.func_76319_b();
        } else {
            entity.func_70107_b(x, y, z);
        }
    }

    private static void tpPlayerToDim(EntityPlayerMP player, int dim, double x, double y, double z) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ServerConfigurationManager manager = server.func_71203_ab();
        int j = player.field_71093_bK;
        WorldServer worldO = server.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dim;
        WorldServer worldN = server.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, worldN.func_175659_aa(), worldN.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldO.func_72973_f((Entity)player);
        player.field_70128_L = false;
        MovedBlock.tpEntity((Entity)player, worldO, worldN, x, y, z);
        worldO.func_73040_p().func_72695_c(player);
        worldN.func_73040_p().func_72683_a(player);
        worldN.field_73059_b.func_73158_c((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldN);
        manager.func_72354_b(player, worldN);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, j, dim);
    }

    private static void tpEntity(Entity entity, WorldServer os, WorldServer ns, double x, double y, double z) {
        os.field_72984_F.func_76320_a("placing");
        if (entity.func_70089_S()) {
            ns.func_72838_d(entity);
            entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            ns.func_72866_a(entity, false);
        }
        os.field_72984_F.func_76319_b();
        entity.func_70029_a((World)ns);
    }
}

