/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.IGuiItem;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileBlockRegistry;
import cd4017be.lib.TileContainer;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class BlockGuiHandler
implements IGuiHandler {
    private static final String guiChannel = "CD4017BE_gui";
    public static BlockGuiHandler instance = new BlockGuiHandler();
    private static Object modRef;
    public static FMLEventChannel eventChannel;

    public static void registerMod(Object mod) {
        if (modRef == null) {
            modRef = mod;
            NetworkRegistry.INSTANCE.registerGuiHandler(modRef, (IGuiHandler)instance);
        }
    }

    public static void openGui(EntityPlayer player, World world, int x, int y, int z) {
        if (modRef != null) {
            player.openGui(modRef, 0, world, x, y, z);
        } else {
            FMLLog.severe((String)"CD4017BE-lib: BlockGuiHandler failed to open Gui! No Mod registered!", (Object[])new Object[0]);
        }
    }

    public static void openItemGui(EntityPlayer player, World world, int x, int y, int z) {
        if (modRef != null) {
            player.openGui(modRef, 1, world, x, y, z);
        } else {
            FMLLog.severe((String)"CD4017BE-lib: BlockGuiHandler failed to open Gui! No Mod registered!", (Object[])new Object[0]);
        }
    }

    public static void sendPacketToServer(PacketBuffer data) {
        eventChannel.sendToServer(new FMLProxyPacket(data, guiChannel));
    }

    public static void sendPacketToPlayer(EntityPlayerMP player, PacketBuffer data) {
        eventChannel.sendTo(new FMLProxyPacket(data, guiChannel), player);
    }

    public static PacketBuffer getPacketTargetData(BlockPos pos) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.func_179255_a(pos);
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onServerPacketReceived(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket packet = event.packet;
        if (!packet.channel().equals(guiChannel)) {
            return;
        }
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container != null && container instanceof TileContainer) {
            try {
                PacketBuffer data = new PacketBuffer(packet.payload());
                ModTileEntity te = ((TileContainer)container).tileEntity;
                if (te.func_174877_v().equals((Object)data.func_179259_c())) {
                    ((TileContainer)container).onDataUpdate(data);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPacketReceived(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket packet = event.packet;
        if (!packet.channel().equals(guiChannel)) {
            return;
        }
        if (!(event.handler instanceof NetHandlerPlayServer)) {
            FMLLog.log((Level)Level.WARN, (String)"NetHandler not instanceof NetHandlerPlayServer!", (Object[])new Object[0]);
        }
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            PacketBuffer data = new PacketBuffer(packet.payload());
            BlockPos pos = data.func_179259_c();
            if (pos.func_177956_o() < 0) {
                ItemStack item = player.func_71045_bC();
                if (item != null && item.func_77973_b() instanceof IGuiItem) {
                    ((IGuiItem)item.func_77973_b()).onPlayerCommand(player.field_70170_p, (EntityPlayer)player, data);
                }
            } else {
                TileEntity te = player.field_70170_p.func_175625_s(pos);
                if (te != null && te instanceof ModTileEntity) {
                    ((ModTileEntity)te).onPlayerCommand(data, player);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 0) {
            BlockPos pos = new BlockPos(x, y, z);
            TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(world.func_180495_p(pos).func_177230_c());
            TileEntity te = world.func_175625_s(pos);
            if (entry != null && entry.container != null && te != null && entry.tileEntity.isInstance(te)) {
                try {
                    return entry.container.getConstructor(ModTileEntity.class, EntityPlayer.class).newInstance(new Object[]{(ModTileEntity)te, player});
                }
                catch (NoSuchMethodException ex) {
                    FMLLog.severe((String)"CD4017BE-lib: TileContainer %1$s is missing the Constructor ( %2$s , %3$s )", (Object[])new Object[]{entry.container.getName(), ModTileEntity.class.getName(), EntityPlayer.class.getName()});
                    return null;
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        if (ID == 1) {
            ItemStack item = player.func_71045_bC();
            if (item != null && item.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)item.func_77973_b()).getContainer(world, player, x, y, z);
            }
            return null;
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 0) {
            BlockPos pos = new BlockPos(x, y, z);
            TileBlockRegistry.TileBlockEntry entry = TileBlockRegistry.getBlockEntry(world.func_180495_p(pos).func_177230_c());
            TileEntity te = world.func_175625_s(pos);
            if (entry != null && entry.gui != null && te != null && entry.tileEntity.isInstance(te)) {
                try {
                    return entry.gui.getConstructor(entry.tileEntity, EntityPlayer.class).newInstance(new Object[]{entry.tileEntity.cast(te), player});
                }
                catch (NoSuchMethodException ex) {
                    FMLLog.severe((String)"CD4017BE-lib: GuiContainer %1$s is missing the Constructor ( %2$s , %3$s )", (Object[])new Object[]{entry.gui.getName(), entry.tileEntity.getName(), EntityPlayer.class.getName()});
                    return null;
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        if (ID == 1) {
            ItemStack item = player.func_71045_bC();
            if (item != null && item.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)item.func_77973_b()).getGui(world, player, x, y, z);
            }
            return null;
        }
        return null;
    }

    static {
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(guiChannel);
        eventChannel.register((Object)instance);
    }
}

