/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.lib.templates.Inventory;
import cd4017be.lib.templates.TankContainer;
import cd4017be.lib.util.Obj2;
import cd4017be.lib.util.OreDictStack;
import cd4017be.lib.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class AutomationRecipes {
    public static float LFEmult = 1.0f;
    public static float CoolEmult = 1.0f;
    public static float ElEmult = 1.0f;
    private static List<LFRecipe> lfRecipes = new ArrayList<LFRecipe>();
    private static List<CmpRecipe> cmpRecipes = new ArrayList<CmpRecipe>();
    private static List<CoolRecipe> coolRecipes = new ArrayList<CoolRecipe>();
    private static List<ElRecipe> elRecipes = new ArrayList<ElRecipe>();
    private static List<GCRecipe> gcRecipes = new ArrayList<GCRecipe>();
    public static HashMap<Fluid, Obj2<Integer, FluidStack>> radiatorRecipes = new HashMap();

    public static List<LFRecipe> getAdvancedFurnaceRecipes() {
        return lfRecipes;
    }

    public static void addRecipe(LFRecipe recipe) {
        lfRecipes.add(recipe);
    }

    public static LFRecipe getRecipeFor(FluidStack liquid, ItemStack[] items) {
        for (LFRecipe recipe : lfRecipes) {
            if (!recipe.matches(liquid, items)) continue;
            return recipe.copy();
        }
        return null;
    }

    public static LFRecipe readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Items", 10);
        ItemStack[] items = new ItemStack[list.func_74745_c()];
        for (int id = 0; id < items.length; ++id) {
            NBTTagCompound tag = list.func_150305_b(id);
            items[id] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        float energy = nbt.func_74760_g("Energy");
        return new LFRecipe(null, null, liquid, items, energy);
    }

    public static NBTTagCompound writeToNBT(LFRecipe recipe) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (recipe.Ioutput != null) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < recipe.Ioutput.length; ++i) {
                if (recipe.Ioutput[i] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                recipe.Ioutput[i].func_77955_b(tag);
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("Items", (NBTBase)list);
        }
        if (recipe.Loutput != null) {
            recipe.Loutput.writeToNBT(nbt);
        }
        nbt.func_74776_a("Energy", recipe.energy);
        return nbt;
    }

    public static boolean isItemEqual(ItemStack item, Object obj) {
        if (obj == null && item == null) {
            return true;
        }
        if (obj instanceof ItemStack) {
            return Utils.itemsEqual(item, (ItemStack)obj);
        }
        if (obj instanceof OreDictStack) {
            return ((OreDictStack)obj).isEqual(item);
        }
        return false;
    }

    public static int getStacksize(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).field_77994_a;
        }
        if (obj instanceof OreDictStack) {
            return ((OreDictStack)obj).stacksize;
        }
        return 0;
    }

    public static List<CmpRecipe> getCompressorRecipes() {
        return cmpRecipes;
    }

    public static void addRecipe(CmpRecipe recipe) {
        cmpRecipes.add(recipe);
    }

    public static void addCmpRecipe(ItemStack out, Object ... in) {
        cmpRecipes.add(new CmpRecipe(in, out));
    }

    public static CmpRecipe getRecipeFor(ItemStack[] inventory, int s, int e) {
        for (CmpRecipe recipe : cmpRecipes) {
            if (!recipe.matches(inventory, s, e)) continue;
            return recipe;
        }
        return null;
    }

    public static CoolRecipe readCoolRecipeFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tag;
        float energy = nbt.func_74760_g("Energy");
        FluidStack out0 = null;
        FluidStack out1 = null;
        if (nbt.func_74764_b("out0")) {
            tag = nbt.func_74775_l("out0");
            if (tag.func_74764_b("FluidName")) {
                out0 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            } else if (tag.func_74764_b("id")) {
                out0 = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }
        if (nbt.func_74764_b("out1")) {
            tag = nbt.func_74775_l("out1");
            if (tag.func_74764_b("FluidName")) {
                out1 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            } else if (tag.func_74764_b("id")) {
                out1 = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }
        return new CoolRecipe(null, out0, null, out1, energy);
    }

    public static NBTTagCompound writeCoolRecipeToNBT(CoolRecipe rcp) {
        NBTTagCompound tag;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("Energy", rcp.energy);
        if (rcp.out0 != null) {
            tag = new NBTTagCompound();
            if (rcp.out0 instanceof FluidStack) {
                ((FluidStack)rcp.out0).writeToNBT(tag);
            } else if (rcp.out0 instanceof ItemStack) {
                ((ItemStack)rcp.out0).func_77955_b(tag);
            }
            nbt.func_74782_a("out0", (NBTBase)tag);
        }
        if (rcp.out1 != null) {
            tag = new NBTTagCompound();
            if (rcp.out1 instanceof FluidStack) {
                ((FluidStack)rcp.out1).writeToNBT(tag);
            } else if (rcp.out1 instanceof ItemStack) {
                ((ItemStack)rcp.out1).func_77955_b(tag);
            }
            nbt.func_74782_a("out1", (NBTBase)tag);
        }
        return nbt;
    }

    public static List<CoolRecipe> getCoolerRecipes() {
        return coolRecipes;
    }

    public static void addRecipe(CoolRecipe recipe) {
        coolRecipes.add(recipe);
    }

    public static CoolRecipe getRecipeFor(ItemStack[] inv, int s, FluidStack in0, FluidStack in1) {
        for (CoolRecipe recipe : coolRecipes) {
            if (!recipe.matches(inv, s, in0, in1)) continue;
            return recipe.copy();
        }
        return null;
    }

    public static ElRecipe readElRecipeFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tag;
        float energy = nbt.func_74760_g("Energy");
        FluidStack out0 = null;
        FluidStack out1 = null;
        if (nbt.func_74764_b("out0")) {
            tag = nbt.func_74775_l("out0");
            if (tag.func_74764_b("FluidName")) {
                out0 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            } else if (tag.func_74764_b("id")) {
                out0 = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }
        if (nbt.func_74764_b("out1")) {
            tag = nbt.func_74775_l("out1");
            if (tag.func_74764_b("FluidName")) {
                out1 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            } else if (tag.func_74764_b("id")) {
                out1 = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }
        return new ElRecipe(null, out0, out1, energy);
    }

    public static NBTTagCompound writeElRecipeToNBT(ElRecipe rcp) {
        NBTTagCompound tag;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("Energy", rcp.energy);
        if (rcp.out0 != null) {
            tag = new NBTTagCompound();
            if (rcp.out0 instanceof FluidStack) {
                ((FluidStack)rcp.out0).writeToNBT(tag);
            } else if (rcp.out0 instanceof ItemStack) {
                ((ItemStack)rcp.out0).func_77955_b(tag);
            }
            nbt.func_74782_a("out0", (NBTBase)tag);
        }
        if (rcp.out1 != null) {
            tag = new NBTTagCompound();
            if (rcp.out1 instanceof FluidStack) {
                ((FluidStack)rcp.out1).writeToNBT(tag);
            } else if (rcp.out1 instanceof ItemStack) {
                ((ItemStack)rcp.out1).func_77955_b(tag);
            }
            nbt.func_74782_a("out1", (NBTBase)tag);
        }
        return nbt;
    }

    public static List<ElRecipe> getElectrolyserRecipes() {
        return elRecipes;
    }

    public static void addRecipe(ElRecipe recipe) {
        elRecipes.add(recipe);
    }

    public static ElRecipe getRecipeFor(ItemStack[] inv, int s, FluidStack in) {
        for (ElRecipe recipe : elRecipes) {
            if (!recipe.matches(inv, s, in)) continue;
            return recipe.copy();
        }
        return null;
    }

    public static List<GCRecipe> getGraviCondRecipes() {
        return gcRecipes;
    }

    public static void addRecipe(GCRecipe recipe) {
        gcRecipes.add(recipe);
    }

    public static GCRecipe getRecipeFor(ItemStack input) {
        for (GCRecipe recipe : gcRecipes) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    public static void addItemCrushingRecipes(String oreType) {
        String[] names = OreDictionary.getOreNames();
        HashMap<String, String> dusts = new HashMap<String, String>();
        ArrayList<String> items = new ArrayList<String>();
        for (String name : names) {
            if (name.startsWith("dust")) {
                dusts.put(oreType + name.substring(4), name);
                continue;
            }
            if (!name.startsWith(oreType)) continue;
            items.add(name);
        }
        for (String item : items) {
            List list;
            String dust = (String)dusts.get(item);
            if (dust == null || (list = OreDictionary.getOres((String)dust)).isEmpty()) continue;
            AutomationRecipes.addCmpRecipe((ItemStack)list.get(0), item);
        }
    }

    public static void addRadiatorRecipe(FluidStack in, FluidStack out) {
        radiatorRecipes.put(in.getFluid(), new Obj2<Integer, FluidStack>(in.amount, out));
    }

    public static class GCRecipe {
        public final ItemStack input;
        public final ItemStack output;
        public final int matter;

        public GCRecipe(ItemStack out, ItemStack in, int m) {
            this.input = in;
            this.output = out;
            this.matter = m;
        }

        public boolean matches(ItemStack in) {
            return Utils.oresEqual(in, this.input) && in.field_77994_a >= this.input.field_77994_a;
        }
    }

    public static class ElRecipe {
        public Object in;
        public Object out0;
        public Object out1;
        public float energy;

        public ElRecipe(Object in, Object out0, Object out1, float e) {
            this.in = in;
            this.out0 = out0;
            this.out1 = out1;
            this.energy = e * ElEmult;
        }

        public boolean matches(ItemStack[] inv, int s, FluidStack in) {
            if (this.in instanceof FluidStack && in != null) {
                if (!in.containsFluid((FluidStack)this.in)) {
                    return false;
                }
            } else if (this.in instanceof ItemStack && in == null && inv[s] != null) {
                if (!inv[s].func_77969_a((ItemStack)this.in) || inv[s].field_77994_a < ((ItemStack)this.in).field_77994_a) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        public void useRes(Inventory inv, int s0, TankContainer tanks, int t0) {
            if (this.in instanceof FluidStack) {
                tanks.drain(t0, ((FluidStack)this.in).amount, true);
            } else if (this.in instanceof ItemStack) {
                if (inv.items[s0].field_77994_a > ((ItemStack)this.in).field_77994_a) {
                    inv.items[s0].field_77994_a -= ((ItemStack)this.in).field_77994_a;
                } else {
                    inv.items[s0] = null;
                }
            }
            this.in = null;
        }

        public boolean output(Inventory inv, int s0, int s1, TankContainer tanks, int t0, int t1) {
            int n;
            if (this.out0 instanceof FluidStack) {
                ((FluidStack)this.out0).amount -= tanks.fill(t0, (FluidStack)this.out0, true);
                if (((FluidStack)this.out0).amount <= 0) {
                    this.out0 = null;
                }
            } else if (this.out0 instanceof ItemStack) {
                if (inv.items[s0] == null) {
                    inv.items[s0] = (ItemStack)this.out0;
                    this.out0 = null;
                } else if (inv.items[s0].func_77969_a((ItemStack)this.out0)) {
                    n = inv.items[s0].func_77976_d() - inv.items[s0].field_77994_a;
                    if (n > ((ItemStack)this.out0).field_77994_a) {
                        inv.items[s0].field_77994_a += ((ItemStack)this.out0).field_77994_a;
                        this.out0 = null;
                    } else {
                        inv.items[s0].field_77994_a += n;
                        ((ItemStack)this.out0).field_77994_a -= n;
                    }
                }
            }
            if (this.out1 instanceof FluidStack) {
                ((FluidStack)this.out1).amount -= tanks.fill(t1, (FluidStack)this.out1, true);
                if (((FluidStack)this.out1).amount <= 0) {
                    this.out1 = null;
                }
            } else if (this.out1 instanceof ItemStack) {
                if (inv.items[s1] == null) {
                    inv.items[s1] = (ItemStack)this.out1;
                    this.out1 = null;
                } else if (inv.items[s1].func_77969_a((ItemStack)this.out1)) {
                    n = inv.items[s1].func_77976_d() - inv.items[s1].field_77994_a;
                    if (n > ((ItemStack)this.out1).field_77994_a) {
                        inv.items[s1].field_77994_a += ((ItemStack)this.out1).field_77994_a;
                        this.out1 = null;
                    } else {
                        inv.items[s1].field_77994_a += n;
                        ((ItemStack)this.out1).field_77994_a -= n;
                    }
                }
            }
            return this.out0 == null && this.out1 == null;
        }

        public ElRecipe copy() {
            ItemStack out0;
            ItemStack in;
            Object object = this.in instanceof ItemStack ? ((ItemStack)this.in).func_77946_l() : (in = this.in instanceof FluidStack ? ((FluidStack)this.in).copy() : null);
            Object object2 = this.out0 instanceof ItemStack ? ((ItemStack)this.out0).func_77946_l() : (out0 = this.out0 instanceof FluidStack ? ((FluidStack)this.out0).copy() : null);
            ItemStack out1 = this.out1 instanceof ItemStack ? ((ItemStack)this.out1).func_77946_l() : (this.out1 instanceof FluidStack ? ((FluidStack)this.out1).copy() : null);
            return new ElRecipe(in, out0, out1, this.energy);
        }
    }

    public static class CoolRecipe {
        public Object in0;
        public Object out0;
        public Object in1;
        public Object out1;
        public float energy;

        public CoolRecipe(Object in0, Object out0, Object in1, Object out1, float energy) {
            this.in0 = in0;
            this.out0 = out0;
            this.in1 = in1;
            this.out1 = out1;
            this.energy = energy * CoolEmult;
        }

        public boolean matches(ItemStack[] inv, int s, FluidStack in0, FluidStack in1) {
            if (this.in0 instanceof FluidStack && in0 != null) {
                if (!in0.containsFluid((FluidStack)this.in0)) {
                    return false;
                }
            } else if (this.in0 instanceof ItemStack && in0 == null && inv[s] != null) {
                if (!inv[s].func_77969_a((ItemStack)this.in0) || inv[s].field_77994_a < ((ItemStack)this.in0).field_77994_a) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.in1 instanceof FluidStack && in1 != null) {
                if (!in1.containsFluid((FluidStack)this.in1)) {
                    return false;
                }
            } else if (this.in1 instanceof ItemStack && in1 == null && inv[s + 1] != null) {
                if (!inv[s + 1].func_77969_a((ItemStack)this.in1) || inv[s + 1].field_77994_a < ((ItemStack)this.in1).field_77994_a) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        public void useRes(Inventory inv, int s0, int s1, TankContainer tanks, int t0, int t1) {
            if (this.in0 instanceof FluidStack) {
                tanks.drain(t0, ((FluidStack)this.in0).amount, true);
            } else if (this.in0 instanceof ItemStack) {
                if (inv.items[s0].field_77994_a > ((ItemStack)this.in0).field_77994_a) {
                    inv.items[s0].field_77994_a -= ((ItemStack)this.in0).field_77994_a;
                } else {
                    inv.items[s0] = null;
                }
            }
            if (this.in1 instanceof FluidStack) {
                tanks.drain(t1, ((FluidStack)this.in1).amount, true);
            } else if (this.in1 instanceof ItemStack) {
                if (inv.items[s1].field_77994_a > ((ItemStack)this.in1).field_77994_a) {
                    inv.items[s1].field_77994_a -= ((ItemStack)this.in1).field_77994_a;
                } else {
                    inv.items[s1] = null;
                }
            }
            this.in0 = null;
            this.in1 = null;
        }

        public boolean output(Inventory inv, int s0, int s1, TankContainer tanks, int t0, int t1) {
            int n;
            if (this.out0 instanceof FluidStack) {
                ((FluidStack)this.out0).amount -= tanks.fill(t0, (FluidStack)this.out0, true);
                if (((FluidStack)this.out0).amount <= 0) {
                    this.out0 = null;
                }
            } else if (this.out0 instanceof ItemStack) {
                if (inv.items[s0] == null) {
                    inv.items[s0] = (ItemStack)this.out0;
                    this.out0 = null;
                } else if (inv.items[s0].func_77969_a((ItemStack)this.out0)) {
                    n = inv.items[s0].func_77976_d() - inv.items[s0].field_77994_a;
                    if (n > ((ItemStack)this.out0).field_77994_a) {
                        inv.items[s0].field_77994_a += ((ItemStack)this.out0).field_77994_a;
                        this.out0 = null;
                    } else {
                        inv.items[s0].field_77994_a += n;
                        ((ItemStack)this.out0).field_77994_a -= n;
                    }
                }
            }
            if (this.out1 instanceof FluidStack) {
                ((FluidStack)this.out1).amount -= tanks.fill(t1, (FluidStack)this.out1, true);
                if (((FluidStack)this.out1).amount <= 0) {
                    this.out1 = null;
                }
            } else if (this.out1 instanceof ItemStack) {
                if (inv.items[s1] == null) {
                    inv.items[s1] = (ItemStack)this.out1;
                    this.out1 = null;
                } else if (inv.items[s1].func_77969_a((ItemStack)this.out1)) {
                    n = inv.items[s1].func_77976_d() - inv.items[s1].field_77994_a;
                    if (n > ((ItemStack)this.out1).field_77994_a) {
                        inv.items[s1].field_77994_a += ((ItemStack)this.out1).field_77994_a;
                        this.out1 = null;
                    } else {
                        inv.items[s1].field_77994_a += n;
                        ((ItemStack)this.out1).field_77994_a -= n;
                    }
                }
            }
            return this.out0 == null && this.out1 == null;
        }

        public CoolRecipe copy() {
            ItemStack out0;
            ItemStack in1;
            ItemStack in0;
            Object object = this.in0 instanceof ItemStack ? ((ItemStack)this.in0).func_77946_l() : (in0 = this.in0 instanceof FluidStack ? ((FluidStack)this.in0).copy() : null);
            Object object2 = this.in1 instanceof ItemStack ? ((ItemStack)this.in1).func_77946_l() : (in1 = this.in1 instanceof FluidStack ? ((FluidStack)this.in1).copy() : null);
            Object object3 = this.out0 instanceof ItemStack ? ((ItemStack)this.out0).func_77946_l() : (out0 = this.out0 instanceof FluidStack ? ((FluidStack)this.out0).copy() : null);
            ItemStack out1 = this.out1 instanceof ItemStack ? ((ItemStack)this.out1).func_77946_l() : (this.out1 instanceof FluidStack ? ((FluidStack)this.out1).copy() : null);
            return new CoolRecipe(in0, out0, in1, out1, this.energy);
        }
    }

    public static class CmpRecipe {
        public Object[] input;
        public ItemStack output;

        public CmpRecipe(Object[] in, ItemStack out) {
            this.input = in;
            for (int i = 0; i < this.input.length; ++i) {
                if (!(this.input[i] instanceof String)) continue;
                this.input[i] = OreDictStack.deserialize((String)this.input[i]);
            }
            this.output = out;
        }

        public boolean matches(ItemStack[] inventory, int s, int e) {
            if (e - s < this.input.length) {
                return false;
            }
            for (int i = 0; i < this.input.length; ++i) {
                if (this.input[i] == null) {
                    if (inventory[s + i] == null) continue;
                    return false;
                }
                if (this.input[i] instanceof ItemStack) {
                    if (Utils.itemsEqual((ItemStack)this.input[i], inventory[s + i]) && inventory[s + i].field_77994_a >= ((ItemStack)this.input[i]).field_77994_a) continue;
                    return false;
                }
                if (!(this.input[i] instanceof OreDictStack)) continue;
                OreDictStack obj = (OreDictStack)this.input[i];
                if (inventory[s + i] != null && inventory[s + i].field_77994_a >= obj.stacksize && obj.isEqual(inventory[s + i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class LFRecipe {
        public FluidStack Linput;
        public Object[] Iinput;
        public FluidStack Loutput;
        public ItemStack[] Ioutput;
        public float energy;

        public LFRecipe(FluidStack Linput, Object[] Iinput, FluidStack Loutput, ItemStack[] Ioutput, float energy) {
            this.Linput = Linput;
            this.Loutput = Loutput;
            if (Iinput != null) {
                for (int i = 0; i < Iinput.length; ++i) {
                    if (!(Iinput[i] instanceof String)) continue;
                    Iinput[i] = OreDictStack.deserialize((String)Iinput[i]);
                }
                this.Iinput = Iinput;
            } else {
                this.Iinput = new Object[0];
            }
            this.Ioutput = Ioutput != null ? Ioutput : new ItemStack[0];
            this.energy = energy * LFEmult;
        }

        private LFRecipe() {
        }

        public boolean matches(FluidStack liquid, ItemStack[] items) {
            if (!(this.Linput == null || liquid != null && liquid.containsFluid(this.Linput))) {
                return false;
            }
            if (this.Iinput != null) {
                if (items == null) {
                    return false;
                }
                for (Object item : this.Iinput) {
                    if (item == null) continue;
                    int n = AutomationRecipes.getStacksize(item);
                    for (ItemStack i : items) {
                        if (!AutomationRecipes.isItemEqual(i, item)) continue;
                        n -= i.field_77994_a;
                    }
                    if (n <= 0) continue;
                    return false;
                }
            }
            return true;
        }

        public LFRecipe copy() {
            int i;
            LFRecipe recipe = new LFRecipe();
            recipe.Linput = this.Linput == null ? null : this.Linput.copy();
            recipe.Loutput = this.Loutput == null ? null : this.Loutput.copy();
            recipe.Iinput = new Object[this.Iinput.length];
            for (i = 0; i < this.Iinput.length; ++i) {
                recipe.Iinput[i] = this.Iinput[i] == null ? null : (this.Iinput[i] instanceof ItemStack ? ((ItemStack)this.Iinput[i]).func_77946_l() : ((OreDictStack)this.Iinput[i]).copy());
            }
            recipe.Ioutput = new ItemStack[this.Ioutput.length];
            for (i = 0; i < this.Ioutput.length; ++i) {
                recipe.Ioutput[i] = this.Ioutput[i] == null ? null : this.Ioutput[i].func_77946_l();
            }
            recipe.energy = this.energy;
            return recipe;
        }
    }
}

