/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.automation.IEnergy;
import cd4017be.api.automation.PipeEnergy;
import cd4017be.api.energy.EnergyAPI;
import cd4017be.lib.TooltipInfo;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class EnergyAutomation
implements EnergyAPI.IEnergyHandler {
    @Override
    public EnergyAPI.IEnergyAccess create(TileEntity te) {
        return te instanceof IEnergy ? new Cable((IEnergy)te) : null;
    }

    @Override
    public EnergyAPI.IEnergyAccess create(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IEnergyItem ? new EnergyItem(item, (IEnergyItem)item.func_77973_b()) : null;
    }

    public static class Cable
    implements EnergyAPI.IEnergyAccess {
        private final IEnergy energy;

        public Cable(IEnergy e) {
            this.energy = e;
        }

        @Override
        public double getStorage(int s) {
            PipeEnergy pipe = this.energy.getEnergy((byte)s);
            return pipe == null ? 0.0 : pipe.Ucap * pipe.Ucap;
        }

        @Override
        public double getCapacity(int s) {
            PipeEnergy pipe = this.energy.getEnergy((byte)s);
            return pipe == null ? 0.0 : (double)pipe.Umax * (double)pipe.Umax;
        }

        @Override
        public double addEnergy(double e, int s) {
            PipeEnergy pipe = this.energy.getEnergy((byte)s);
            if (pipe == null || pipe == PipeEnergy.empty) {
                return 0.0;
            }
            double d = pipe.Ucap * pipe.Ucap;
            double m = (double)pipe.Umax * (double)pipe.Umax;
            if (d + e < 0.0) {
                e = -d;
                pipe.Ucap = 0.0;
            } else if (d + e > m) {
                e = m - d;
                pipe.Ucap = pipe.Umax;
            } else {
                pipe.addEnergy(e);
            }
            return e;
        }
    }

    public static class EnergyItem
    implements EnergyAPI.IEnergyAccess {
        private final ItemStack stack;
        public final IEnergyItem item;
        public double fractal = 0.0;

        public EnergyItem(ItemStack stack, IEnergyItem item) {
            this.stack = stack;
            this.item = item;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
        }

        public void addInformation(List list) {
            list.add(String.format("Energy: %d / %d %s", this.getStorageI(), this.item.getEnergyCap(this.stack), TooltipInfo.getEnergyUnit()));
        }

        public int getStorageI() {
            return this.stack.func_77978_p().func_74762_e(this.item.getEnergyTag());
        }

        public int addEnergyI(int n, int s) {
            int e;
            if (n == 0) {
                return n;
            }
            int cap = this.item.getEnergyCap(this.stack);
            if (s >= 0) {
                int max = this.item.getChargeSpeed(this.stack);
                if (n > max) {
                    n = max;
                } else if (n < -max) {
                    n = -max;
                }
            }
            if ((e = this.stack.func_77978_p().func_74762_e(this.item.getEnergyTag()) + n) < 0) {
                n -= e;
                e = 0;
            } else if (e > cap) {
                n -= e - cap;
                e = cap;
            }
            this.stack.func_77978_p().func_74768_a(this.item.getEnergyTag(), e);
            return n;
        }

        @Override
        public double getStorage(int s) {
            if (s == -2) {
                return ((double)this.getStorageI() + this.fractal) * 1000.0;
            }
            return (double)this.getStorageI() * 1000.0;
        }

        @Override
        public double getCapacity(int s) {
            return (double)this.item.getEnergyCap(this.stack) * 1000.0;
        }

        @Override
        public double addEnergy(double E, int s) {
            E /= 1000.0;
            if (s == -2) {
                this.fractal = E - (double)this.addEnergyI((int)Math.floor(E + this.fractal), s);
                if (this.fractal < 0.0 || this.fractal >= 1.0) {
                    double d = Math.floor(this.fractal);
                    this.fractal -= d;
                    E -= d;
                }
                return E * 1000.0;
            }
            return (double)this.addEnergyI(E < 0.0 ? (int)Math.ceil(E) : (int)Math.floor(E), s) * 1000.0;
        }
    }

    public static interface IEnergyItem {
        public int getEnergyCap(ItemStack var1);

        public int getChargeSpeed(ItemStack var1);

        public String getEnergyTag();
    }
}

