/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAutomation;
import cd4017be.api.energy.EnergyRedstoneFlux;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class EnergyAPI {
    public static ArrayList<IEnergyHandler> handlers = new ArrayList();
    public static final IEnergyAccess NULL = new NullAccess();
    public static EnergyAutomation main = new EnergyAutomation();
    public static double RF_value = 100.0;
    public static double EU_value = 400.0;
    public static double OC_value = 1000.0;

    public static IEnergyAccess get(TileEntity te) {
        if (te == null) {
            return NULL;
        }
        if (te instanceof IEnergyAccess) {
            return (IEnergyAccess)te;
        }
        for (IEnergyHandler c : handlers) {
            IEnergyAccess e = c.create(te);
            if (e == null) continue;
            return e;
        }
        return NULL;
    }

    public static IEnergyAccess get(ItemStack item) {
        if (item == null || item.func_77973_b() == null || item.field_77994_a != 1) {
            return NULL;
        }
        for (IEnergyHandler c : handlers) {
            IEnergyAccess e = c.create(item);
            if (e == null) continue;
            return e;
        }
        return NULL;
    }

    static {
        handlers.add(main);
        handlers.add(new EnergyRedstoneFlux());
    }

    static class NullAccess
    implements IEnergyAccess {
        NullAccess() {
        }

        @Override
        public double getStorage(int s) {
            return 0.0;
        }

        @Override
        public double getCapacity(int s) {
            return 0.0;
        }

        @Override
        public double addEnergy(double e, int s) {
            return 0.0;
        }
    }

    public static interface IEnergyHandler {
        public IEnergyAccess create(TileEntity var1);

        public IEnergyAccess create(ItemStack var1);
    }

    public static interface IEnergyAccess {
        public double getStorage(int var1);

        public double getCapacity(int var1);

        public double addEnergy(double var1, int var3);
    }
}

