/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import cd4017be.lib.util.Utils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class InventoryItemHandler {
    public static void addInformation(ItemStack item, List list) {
        if (InventoryItemHandler.isInventoryItem(item)) {
            IItemStorage inv = (IItemStorage)item.func_77973_b();
            int n = 0;
            if (item.func_77978_p() != null) {
                n = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10).func_74745_c();
            }
            list.add(String.format("Slots: %d / %d used", n, inv.getSizeInventory(item)));
        }
    }

    public static ItemStack insertItemStack(ItemStack item, ItemStack stack) {
        int s;
        if (!InventoryItemHandler.isInventoryItem(item) || stack == null) {
            return stack;
        }
        stack = stack.func_77946_l();
        IItemStorage inv = (IItemStorage)item.func_77973_b();
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10);
        boolean[] emptyS = new boolean[inv.getSizeInventory(item)];
        for (int i = 0; i < list.func_74745_c() && stack != null; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            s = tag.func_74771_c("slot") & 0xFF;
            if (s >= emptyS.length) continue;
            emptyS[s] = true;
            ItemStack it = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (!Utils.itemsEqual(stack, it)) continue;
            if (it.field_77994_a + stack.field_77994_a <= it.func_77976_d()) {
                it.field_77994_a += stack.field_77994_a;
                stack = null;
            } else {
                stack.field_77994_a -= it.func_77976_d() - it.field_77994_a;
                it.field_77994_a = it.func_77976_d();
            }
            it.func_77955_b(tag);
        }
        if (stack != null) {
            s = 0;
            while (emptyS[s]) {
                if (++s < emptyS.length) continue;
                return stack;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            stack.func_77955_b(nbt);
            nbt.func_74774_a("slot", (byte)s);
            list.func_74742_a((NBTBase)nbt);
        }
        return null;
    }

    public static ItemStack[] getItemList(ItemStack item) {
        if (!InventoryItemHandler.isInventoryItem(item) || item.func_77978_p() == null) {
            return new ItemStack[0];
        }
        IItemStorage inv = (IItemStorage)item.func_77973_b();
        NBTTagList list = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10);
        ItemStack[] buff = new ItemStack[list.func_74745_c()];
        int n = 0;
        for (int i = 0; i < buff.length; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack it = ItemStack.func_77949_a((NBTTagCompound)tag);
            for (int j = 0; j < n && it != null; ++j) {
                if (!Utils.itemsEqual(buff[j], it)) continue;
                buff[j].field_77994_a += it.field_77994_a;
                it = null;
            }
            if (it == null) continue;
            buff[n++] = it;
        }
        ItemStack[] ret = new ItemStack[n];
        System.arraycopy(buff, 0, ret, 0, n);
        return ret;
    }

    public static boolean hasEmptySlot(ItemStack item) {
        if (!InventoryItemHandler.isInventoryItem(item)) {
            return false;
        }
        if (item.func_77978_p() == null) {
            return true;
        }
        IItemStorage inv = (IItemStorage)item.func_77973_b();
        return inv.getSizeInventory(item) > item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10).func_74745_c();
    }

    public static int extractItemStack(ItemStack item, ItemStack stack) {
        if (!InventoryItemHandler.isInventoryItem(item) || item.func_77978_p() == null || stack == null) {
            return 0;
        }
        IItemStorage inv = (IItemStorage)item.func_77973_b();
        NBTTagList list = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10);
        int n = stack.field_77994_a;
        for (int i = 0; i < list.func_74745_c() && n > 0; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack it = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (!Utils.itemsEqual(stack, it)) continue;
            if (it.field_77994_a <= n) {
                n -= it.field_77994_a;
                list.func_74744_a(i--);
                continue;
            }
            it.field_77994_a -= n;
            n = 0;
            it.func_77955_b(tag);
        }
        return stack.field_77994_a - n;
    }

    public static boolean isInventoryItem(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IItemStorage;
    }

    public static ItemInventory getInventory(ItemStack item) {
        if (!InventoryItemHandler.isInventoryItem(item)) {
            return null;
        }
        return new ItemInventory(item);
    }

    public static class ItemInventory
    implements IInventory {
        private final int size;
        private ItemStack[] items;
        private ItemStack ref;

        private ItemInventory(ItemStack item) {
            IItemStorage inv = (IItemStorage)item.func_77973_b();
            this.size = inv.getSizeInventory(item);
            this.load(item);
        }

        public void load(ItemStack item) {
            this.ref = item;
            this.items = new ItemStack[this.size];
            if (item.func_77978_p() == null) {
                return;
            }
            IItemStorage inv = (IItemStorage)item.func_77973_b();
            NBTTagList list = item.func_77978_p().func_150295_c(inv.getInventoryTag(), 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                int s = tag.func_74771_c("slot") & 0xFF;
                if (s >= this.size) continue;
                this.items[s] = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }

        public void save(ItemStack item) {
            if (!InventoryItemHandler.isInventoryItem(item)) {
                return;
            }
            if (item.func_77978_p() == null) {
                item.func_77982_d(new NBTTagCompound());
            }
            IItemStorage inv = (IItemStorage)item.func_77973_b();
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.size; ++i) {
                if (this.items[i] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                this.items[i].func_77955_b(tag);
                tag.func_74774_a("slot", (byte)i);
                list.func_74742_a((NBTBase)tag);
            }
            item.func_77978_p().func_74782_a(inv.getInventoryTag(), (NBTBase)list);
        }

        public int func_70302_i_() {
            return this.size;
        }

        public ItemStack func_70301_a(int s) {
            return this.items[s];
        }

        public ItemStack func_70298_a(int s, int n) {
            ItemStack stack = this.items[s];
            if (stack == null) {
                return null;
            }
            if (n < stack.field_77994_a) {
                return stack.func_77979_a(n);
            }
            this.items[s] = null;
            return stack;
        }

        public ItemStack func_70304_b(int s) {
            ItemStack item = this.items[s];
            this.items[s] = null;
            return item;
        }

        public void func_70299_a(int s, ItemStack stack) {
            this.items[s] = stack;
        }

        public String func_70005_c_() {
            return this.ref.func_82833_r();
        }

        public boolean func_145818_k_() {
            return true;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer player) {
            return !player.field_70128_L;
        }

        public boolean func_94041_b(int s, ItemStack stack) {
            return true;
        }

        public IChatComponent func_145748_c_() {
            return new ChatComponentText(this.func_70005_c_());
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
        }
    }

    public static interface IItemStorage {
        public int getSizeInventory(ItemStack var1);

        public String getInventoryTag();
    }
}

