/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.circuits.item.ItemCircuit;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileContainer;
import cd4017be.lib.TileEntityData;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.templates.Inventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class Programmer
extends AutomatedTile
implements ISidedInventory {
    public static final byte C_OR = 0;
    public static final byte C_NOR = 16;
    public static final byte C_AND = 32;
    public static final byte C_NAND = 48;
    public static final byte C_XOR = 64;
    public static final byte C_XNOR = 80;
    public static final byte C_IN = 96;
    public static final byte C_EQ = 112;
    public static final byte C_LO = -128;
    public static final byte C_HI = -112;
    private static final byte[] defaultArray = new byte[16];
    public byte[] outputs = Arrays.copyOf(defaultArray, defaultArray.length);
    public String[] gates = new String[]{""};
    public byte[] counter = Arrays.copyOf(defaultArray, defaultArray.length);
    public String name = "";
    public String message = "";

    public Programmer() {
        this.netData = new TileEntityData(1, 0, 0, 0);
        this.inventory = new Inventory((ModTileEntity)this, 1, new Inventory.Component[0]);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.save(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.load(nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.load(pkt.func_148857_g());
        this.message = pkt.func_148857_g().func_74779_i("msg");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.save(nbt);
        nbt.func_74778_a("msg", this.message);
        return new S35PacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    protected void customPlayerCommand(byte cmd, PacketBuffer dis, EntityPlayerMP player) throws IOException {
        this.message = "";
        if (cmd == 0 && this.inventory.items[0] != null) {
            if (this.inventory.items[0].func_77973_b() == Items.field_151121_aF) {
                this.outputs = Arrays.copyOf(defaultArray, defaultArray.length);
                this.counter = Arrays.copyOf(defaultArray, defaultArray.length);
                this.gates = new String[]{""};
                this.name = "";
            } else if (this.inventory.items[0].func_77973_b() == BlockItemRegistry.itemId((String)"circuitPlan") && this.inventory.items[0].func_77978_p() != null) {
                this.load(this.inventory.items[0].func_77978_p());
                this.message = "Programm Loaded";
            }
        } else if (cmd == 1 && this.inventory.items[0] != null) {
            if (this.inventory.items[0].func_77973_b() == Items.field_151121_aF) {
                this.inventory.items[0] = BlockItemRegistry.stack((String)"item.circuitPlan", (int)this.inventory.items[0].field_77994_a);
            } else if (this.inventory.items[0].func_77973_b() instanceof ItemCircuit) {
                if (this.inventory.items[0].func_77978_p() == null) {
                    this.inventory.items[0].func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound code = this.write();
                if (!this.message.equals("Compiling successfull")) {
                    this.markUpdate();
                    return;
                }
                int n = code.func_150295_c("Src", 8).func_74745_c();
                if ((this.inventory.items[0].func_77978_p().func_74771_c("Gates") & 0xFF) < n) {
                    this.message = "Not enought Gates: " + n + " needed!";
                    this.markUpdate();
                    return;
                }
                n = 0;
                for (byte b : code.func_74770_j("Out")) {
                    if (b < 0) continue;
                    ++n;
                }
                if ((this.inventory.items[0].func_77978_p().func_74771_c("InOut") & 0xFF) < n) {
                    this.message = "Not enought IO-Ports: " + n + " needed!";
                    this.markUpdate();
                    return;
                }
                n = 0;
                byte[] b = code.func_74770_j("Count");
                for (int j = 0; j < 8; ++j) {
                    if (b[j] < 0 && b[j + 8] < 0) continue;
                    ++n;
                }
                if ((this.inventory.items[0].func_77978_p().func_74771_c("Count") & 0xFF) < n) {
                    this.message = "Not enought Counter: " + n + " needed!";
                    this.markUpdate();
                    return;
                }
                NBTTagCompound progr = new NBTTagCompound();
                progr.func_74778_a("name", code.func_74779_i("name"));
                progr.func_74773_a("code", code.func_74770_j("Data"));
                progr.func_74773_a("out", code.func_74770_j("Out"));
                progr.func_74773_a("cnt", code.func_74770_j("Count"));
                this.inventory.items[0].func_77978_p().func_74782_a("Progr", (NBTBase)progr);
            } else {
                if (this.inventory.items[0].func_77973_b() != BlockItemRegistry.itemId((String)"circuitPlan")) {
                    return;
                }
                this.inventory.items[0].func_77982_d(this.write());
            }
        } else if (cmd == 2) {
            byte l = dis.readByte();
            if (l >= 0 && l < this.gates.length) {
                this.gates[l] = dis.func_150789_c(40);
            }
        } else if (cmd == 3) {
            byte l = dis.readByte();
            if (l >= 0 && l <= this.gates.length) {
                String[] buff = new String[this.gates.length + 1];
                if (l > 0) {
                    System.arraycopy(this.gates, 0, buff, 0, l);
                }
                if (l < this.gates.length) {
                    System.arraycopy(this.gates, l, buff, l + 1, this.gates.length - l);
                }
                this.gates = buff;
                this.gates[l] = "";
            }
        } else if (cmd == 4) {
            byte l = dis.readByte();
            if (l >= 0 && l < this.gates.length) {
                String[] buff = new String[this.gates.length - 1];
                if (l > 0) {
                    System.arraycopy(this.gates, 0, buff, 0, l);
                }
                if (l < this.gates.length - 1) {
                    System.arraycopy(this.gates, l + 1, buff, l, this.gates.length - l - 1);
                }
                this.gates = buff;
                if (this.gates.length == 0) {
                    this.gates = new String[]{""};
                }
            }
        } else if (cmd == 5) {
            byte l = dis.readByte();
            if (l >= 0 && l < this.outputs.length) {
                this.outputs[l] = dis.readByte();
            }
        } else if (cmd == 6) {
            byte l = dis.readByte();
            if (l >= 0 && l < this.counter.length) {
                this.counter[l] = dis.readByte();
            }
        } else if (cmd == 7) {
            this.name = dis.func_150789_c(40);
        }
        this.markUpdate();
    }

    private void load(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.outputs = nbt.func_74770_j("Out");
        this.counter = nbt.func_74770_j("Count");
        NBTTagList list = nbt.func_150295_c("Src", 8);
        this.gates = new String[list.func_74745_c()];
        for (int i = 0; i < this.gates.length; ++i) {
            this.gates[i] = list.func_150307_f(i);
        }
        if (this.gates.length == 0) {
            this.gates = new String[]{""};
        }
    }

    private void save(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.name);
        nbt.func_74773_a("Out", this.outputs);
        nbt.func_74773_a("Count", this.counter);
        NBTTagList list = new NBTTagList();
        for (String s : this.gates) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        nbt.func_74782_a("Src", (NBTBase)list);
    }

    private NBTTagCompound write() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74773_a("Out", this.outputs);
        nbt.func_74773_a("Count", this.counter);
        NBTTagList list = new NBTTagList();
        for (String s : this.gates) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        nbt.func_74782_a("Src", (NBTBase)list);
        int l = 0;
        try {
            ArrayList<Byte> data = new ArrayList<Byte>();
            block13: for (l = 0; l < this.gates.length; ++l) {
                String s0 = this.gates[l].substring(1);
                switch (this.gates[l].charAt(0)) {
                    case '+': {
                        this.addParameters(data, (byte)0, s0);
                        continue block13;
                    }
                    case '-': {
                        this.addParameters(data, (byte)16, s0);
                        continue block13;
                    }
                    case '&': {
                        this.addParameters(data, (byte)32, s0);
                        continue block13;
                    }
                    case '*': {
                        this.addParameters(data, (byte)48, s0);
                        continue block13;
                    }
                    case '/': {
                        this.addParameters(data, (byte)64, s0);
                        continue block13;
                    }
                    case '\\': {
                        this.addParameters(data, (byte)80, s0);
                        continue block13;
                    }
                    case '%': {
                        data.add((byte)(0x60 | Byte.parseByte(s0.trim())));
                        continue block13;
                    }
                    case '#': {
                        this.compare(data, s0);
                    }
                }
            }
            byte[] b = new byte[data.size()];
            for (int i = 0; i < b.length; ++i) {
                b[i] = (Byte)data.get(i);
            }
            nbt.func_74773_a("Data", b);
            this.message = "Compiling successfull";
        }
        catch (Exception e) {
            this.message = "Compile Error in line " + l;
        }
        return nbt;
    }

    private void addParameters(ArrayList<Byte> data, byte cmd, String s) {
        if (s.length() == 0) {
            data.add(cmd);
            return;
        }
        String[] s1 = s.split(",");
        data.add((byte)(cmd | s1.length));
        for (String s2 : s1) {
            data.add(Byte.parseByte(s2.trim()));
        }
    }

    private void compare(ArrayList<Byte> data, String s) {
        int cmd = 0;
        int p0 = s.indexOf("=");
        int p1 = s.indexOf("<");
        int p2 = s.indexOf(">");
        if (p0 > 0) {
            cmd = 112;
        } else if (p1 > 0) {
            p0 = p1;
            cmd = -128;
        } else if (p2 > 0) {
            p0 = p2;
            cmd = -112;
        }
        data.add((byte)(cmd | Byte.parseByte(s.substring(0, p0))));
        data.add((byte)Short.parseShort(s.substring(p0 + 1)));
    }

    public void initContainer(TileContainer container) {
        container.addEntitySlot(new Slot((IInventory)this, 0, 152, 55));
        container.addPlayerInventory(8, 107);
    }

    static {
        Arrays.fill(defaultArray, (byte)-1);
    }
}

