/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.ILinkedInventory;
import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileContainer;
import cd4017be.lib.TileEntityData;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.templates.Inventory;
import cd4017be.lib.templates.SlotHolo;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public class InvReader
extends AutomatedTile
implements IRedstone8bit,
ISidedInventory {
    private byte input;
    private byte output;
    private boolean update1;

    public InvReader() {
        this.inventory = new Inventory((ModTileEntity)this, 8, new Inventory.Component[0]);
        this.netData = new TileEntityData(3, 8, 0, 0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update1) {
            this.getIn();
        }
        this.update1();
        if (this.update1) {
            this.output(0);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.input = nbt.func_74771_c("in");
        this.output = nbt.func_74771_c("out");
        this.update1 = true;
        int[] data = nbt.func_74759_k("ref");
        System.arraycopy(data, 0, this.netData.ints, 0, Math.min(data.length, this.netData.ints.length));
        this.netData.longs[1] = nbt.func_74763_f("cfg1");
        this.netData.longs[2] = nbt.func_74763_f("cfg2");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("in", this.input);
        nbt.func_74774_a("out", this.output);
        nbt.func_74783_a("ref", this.netData.ints);
        nbt.func_74772_a("cfg1", this.netData.longs[1]);
        nbt.func_74772_a("cfg2", this.netData.longs[2]);
    }

    protected void customPlayerCommand(byte cmd, PacketBuffer dis, EntityPlayerMP player) throws IOException {
        if (cmd < 8) {
            this.netData.ints[cmd] = dis.readInt();
        } else if (cmd < 16) {
            byte s = dis.readByte();
            if (s == 0 || s == 1) {
                long p = (s == 0 ? cmd - 8 : cmd) * 3;
                long x = ((this.netData.longs[1] >> (int)p & 7L) + 1L) % 6L;
                this.netData.longs[1] = this.netData.longs[1] & (7L << (int)p ^ 0xFFFFFFFFFFFFFFFFL) | x << (int)p;
            } else if (s == 2) {
                long p = (cmd - 8) * 6;
                long x = ((this.netData.longs[2] >> (int)p & 3L) + 1L) % 4L;
                this.netData.longs[2] = this.netData.longs[2] & (3L << (int)p ^ 0xFFFFFFFFFFFFFFFFL) | x << (int)p;
            } else if (s > 2 && s < 7) {
                this.netData.longs[2] = this.netData.longs[2] ^ 1L << (int)((long)(cmd - 8) * 6L + (long)s - 1L);
            }
        } else if (cmd == 16) {
            byte s = dis.readByte();
            if (s < 0 || s >= 6) {
                return;
            }
            long p = 48 + s * 2;
            long x = ((this.netData.longs[1] >> (int)p & 3L) + 1L) % 3L;
            this.netData.longs[1] = this.netData.longs[1] & (3L << (int)p ^ 0xFFFFFFFFFFFFFFFFL) | x << (int)p;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
    }

    public void initContainer(TileContainer container) {
        container.addPlayerInventory(8, 104);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                container.addEntitySlot((Slot)new SlotHolo((IInventory)this, i * 4 + j, 26 + i * 99, 16 + j * 18, false, false));
            }
        }
    }

    private void getIn() {
        byte lstate = (byte)(this.input | this.output);
        this.input = 0;
        for (int i = 0; i < 6; ++i) {
            byte d8 = this.getDirection(i);
            if (d8 > -1) continue;
            TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
            if (d8 >= 0 || te == null || !(te instanceof IRedstone8bit) || ((IRedstone8bit)te).getDirection(i ^ 1) <= 0) continue;
            this.input = (byte)(this.input | ((IRedstone8bit)te).getValue(i ^ 1));
        }
        this.update1 = (this.input | this.output) != lstate;
    }

    private void update1() {
        byte lstate = (byte)(this.output | this.input);
        this.output = 0;
        for (int i = 0; i < 8; ++i) {
            IInventory inv;
            byte mode = this.getMode(i);
            byte comp = (byte)(mode & 3);
            if (comp == 0) continue;
            boolean neg = (mode & 4) != 0;
            TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)this.getDir(i));
            if (te == null || !(te instanceof IInventory)) continue;
            if (te instanceof ILinkedInventory) {
                inv = ((ILinkedInventory)te).getLinkInv();
                if (inv == null) {
                    continue;
                }
            } else {
                inv = (IInventory)te;
            }
            int[] slots = Utils.accessibleSlots((IInventory)inv, (int)this.getDir(i | 8));
            int x = 0;
            if (!neg && this.inventory.items[i] == null) {
                for (int s : slots) {
                    if (inv.func_70301_a(s) != null) continue;
                    ++x;
                }
            } else {
                Utils.ItemType filter = new Utils.ItemType((mode & 8) != 0, (mode & 0x10) != 0, (mode & 0x20) != 0, new ItemStack[]{this.inventory.items[i]});
                for (int s : slots) {
                    ItemStack item = inv.func_70301_a(s);
                    if (!(neg ^ filter.matches(item)) || item == null) continue;
                    x += item.field_77994_a;
                }
            }
            if (!(comp == 1 && x == this.netData.ints[i] || comp == 2 && x < this.netData.ints[i]) && (comp != 3 || x <= this.netData.ints[i])) continue;
            this.output = (byte)(this.output | 1 << i);
        }
        this.update1 |= (this.output | this.input) != lstate;
    }

    private void output(int recursion) {
        ++recursion;
        byte state = (byte)(this.input | this.output);
        for (int i = 0; i < 6; ++i) {
            byte d8 = this.getDirection(i);
            if (d8 < 1) continue;
            TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
            if (d8 <= 0 || te == null || !(te instanceof IRedstone8bit) || ((IRedstone8bit)te).getDirection(i ^ 1) >= 0) continue;
            ((IRedstone8bit)te).setValue(i ^ 1, state, recursion);
        }
        this.update1 = false;
    }

    public byte getDir(int b) {
        return (byte)(this.netData.longs[1] >> (int)((long)(b * 3)) & 7L);
    }

    public byte getMode(int b) {
        return (byte)(this.netData.longs[2] >> (int)((long)(b * 6)) & 0x3FL);
    }

    public void onNeighborBlockChange(Block b) {
        this.update1 = true;
    }

    public byte getValue(int s) {
        return (byte)(this.input | this.output);
    }

    public byte getDirection(int s) {
        byte k = (byte)(this.netData.longs[1] >> (int)((long)(48 + s * 2)) & 3L);
        return k > 1 ? (byte)-1 : (byte)k;
    }

    public void setValue(int s, byte v, int recursion) {
        if (recursion < 16) {
            this.getIn();
            if (this.update1) {
                this.output(recursion);
            }
        } else {
            this.update1 = true;
        }
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }
}

