/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.ILinkedInventory;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.IPipe;
import cd4017be.lib.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;

public class InvConnector
extends ModTileEntity
implements ILinkedInventory,
IPipe,
ITickable {
    private boolean linkUpdate = true;
    private int[] linkPos = new int[]{0, -1, 0};
    private TileEntity linkObj;
    private byte conDir;
    private IPipe.Cover cover;

    public void onNeighborBlockChange(Block b) {
        this.linkUpdate = true;
    }

    public void onNeighborTileChange(BlockPos pos) {
        this.linkUpdate = true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.conDir = nbt.func_74771_c("dir");
        this.cover = IPipe.Cover.read((NBTTagCompound)nbt, (String)"cover");
        this.linkUpdate = true;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("dir", this.conDir);
        if (this.cover != null) {
            this.cover.write(nbt, "cover");
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.linkUpdate) {
            return;
        }
        TileEntity last = this.linkObj;
        TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)this.conDir);
        if (te == null || !(te instanceof IInventory)) {
            this.linkPos[1] = -1;
            this.linkObj = null;
        } else if (te instanceof ILinkedInventory) {
            if ((((ILinkedInventory)te).getLinkDir() ^ this.conDir) == 1) {
                this.linkObj = null;
                this.linkPos[1] = -1;
            } else {
                this.linkPos = ((ILinkedInventory)te).getLinkPos();
                this.linkObj = this.field_145850_b.func_175625_s(new BlockPos(this.linkPos[0], this.linkPos[1], this.linkPos[2]));
                if (this.linkObj == null) {
                    this.linkPos[1] = -1;
                }
            }
            if (this.linkObj != null && (this.linkObj instanceof ILinkedInventory || !(this.linkObj instanceof IInventory))) {
                this.linkObj = null;
                this.linkPos[1] = -1;
            }
        } else {
            this.linkObj = te;
            this.linkPos = new int[]{te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()};
        }
        if (this.linkObj != last) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            this.markUpdate();
        }
        this.linkUpdate = false;
    }

    public boolean onActivated(EntityPlayer player, EnumFacing s, float X, float Y, float Z) {
        ItemStack item = player.func_71045_bC();
        if (player.func_70093_af() && item == null) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            if (this.cover != null) {
                player.func_70062_b(0, this.cover.item);
                this.cover = null;
                this.markUpdate();
                return true;
            }
            IInventory inv = this.getLinkInv();
            if (inv == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Not Linked!"));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format("Linked to %s at %d, %d, %d", inv.func_70005_c_(), this.linkPos[0], this.linkPos[1], this.linkPos[2])));
            }
            return true;
        }
        if (item == null) {
            if (!this.field_145850_b.field_72995_K) {
                this.connect();
            }
            return true;
        }
        if (!player.func_70093_af() && this.cover == null && item != null && (this.cover = IPipe.Cover.create((ItemStack)item)) != null) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            --item.field_77994_a;
            if (item.field_77994_a <= 0) {
                item = null;
            }
            player.func_70062_b(0, item);
            this.markUpdate();
            return true;
        }
        return false;
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        this.connect();
    }

    private void connect() {
        for (int i = 1; i <= 6; ++i) {
            byte d = (byte)((this.conDir + i) % 6);
            TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)d);
            if (te == null || !(te instanceof IInventory)) continue;
            this.conDir = d;
            this.markUpdate();
            this.linkUpdate = true;
            return;
        }
    }

    public int func_70302_i_() {
        IInventory inv = this.getLinkInv();
        return inv == null ? 0 : inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        IInventory inv = this.getLinkInv();
        return inv == null ? null : inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int n) {
        IInventory inv = this.getLinkInv();
        return inv == null ? null : inv.func_70298_a(i, n);
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack stack) {
        IInventory inv = this.getLinkInv();
        if (inv != null) {
            inv.func_70299_a(i, stack);
        }
    }

    public String func_70005_c_() {
        IInventory inv = this.getLinkInv();
        return inv == null ? "No Connection" : inv.func_70005_c_();
    }

    public boolean func_145818_k_() {
        IInventory inv = this.getLinkInv();
        return inv == null ? true : inv.func_145818_k_();
    }

    public int func_70297_j_() {
        IInventory inv = this.getLinkInv();
        return inv == null ? 0 : inv.func_70297_j_();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        IInventory inv = this.getLinkInv();
        return inv == null ? false : inv.func_94041_b(i, stack);
    }

    public int textureForSide(byte s) {
        if (s == this.conDir) {
            return this.linkPos[1] >= 0 ? 2 : 1;
        }
        TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)s);
        return te != null && te instanceof IInventory ? 0 : -1;
    }

    public IPipe.Cover getCover() {
        return this.cover;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.conDir = pkt.func_148857_g().func_74771_c("dir");
        this.linkPos[1] = pkt.func_148857_g().func_74767_n("link") ? 0 : -1;
        this.cover = IPipe.Cover.read((NBTTagCompound)pkt.func_148857_g(), (String)"cover");
        this.markUpdate();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("dir", (short)this.conDir);
        nbt.func_74757_a("link", this.linkPos[1] >= 0);
        if (this.cover != null) {
            this.cover.write(nbt, "cover");
        }
        return new S35PacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void breakBlock() {
        super.breakBlock();
        if (this.cover != null) {
            EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.cover.item);
            this.cover = null;
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    public int[] func_180463_a(EnumFacing s) {
        IInventory inv = this.getLinkInv();
        if (inv == null) {
            return new int[0];
        }
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180463_a(s);
        }
        int[] ret = new int[inv.func_70302_i_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public boolean func_180462_a(int i, ItemStack stack, EnumFacing s) {
        if (s.func_176745_a() == this.conDir) {
            return false;
        }
        IInventory inv = this.getLinkInv();
        return inv != null && (!(inv instanceof ISidedInventory) || ((ISidedInventory)inv).func_180462_a(i, stack, s));
    }

    public boolean func_180461_b(int i, ItemStack stack, EnumFacing s) {
        if (s.func_176745_a() == this.conDir) {
            return false;
        }
        IInventory inv = this.getLinkInv();
        return inv != null && (!(inv instanceof ISidedInventory) || ((ISidedInventory)inv).func_180461_b(i, stack, s));
    }

    public int[] getLinkPos() {
        return this.linkPos;
    }

    public IInventory getLinkInv() {
        if (this.linkObj == null) {
            return null;
        }
        if (this.linkObj.func_145837_r()) {
            this.linkUpdate = true;
            return null;
        }
        return (IInventory)this.linkObj;
    }

    public byte getLinkDir() {
        return this.conDir;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public IChatComponent func_145748_c_() {
        IInventory inv = this.getLinkInv();
        return inv == null ? new ChatComponentText("No Connection") : inv.func_145748_c_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }
}

