/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.api.computers.ComputerAPI;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers")})
public class Display8bit
extends ModTileEntity
implements IRedstone8bit,
ITickable,
Environment {
    private static String[] defaultFormat = new String[]{"", "##", "###"};
    private boolean update;
    private boolean textUpdate;
    public byte state;
    public byte dspType;
    public String text0 = "";
    public String text1 = "";
    public String format = "";
    private ArrayList<Object> listeners = new ArrayList();
    private Object node = ComputerAPI.newOCnode((TileEntity)this, (String)"RedstoneCircuits-In8bit", (boolean)false);

    public void onPlayerCommand(PacketBuffer data, EntityPlayerMP player) throws IOException {
        byte cmd = data.readByte();
        if (cmd == 0) {
            this.text0 = data.func_150789_c(16);
        } else if (cmd == 1) {
            this.format = data.func_150789_c(3);
        } else if (cmd == 2) {
            this.text1 = data.func_150789_c(16);
        } else if (cmd == 3) {
            this.dspType = (byte)(data.readByte() % 3);
            this.format = defaultFormat[this.dspType];
        }
        this.markUpdate();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.state = pkt.func_148857_g().func_74771_c("state");
        this.dspType = pkt.func_148857_g().func_74771_c("dsp");
        this.text0 = pkt.func_148857_g().func_74779_i("t0");
        this.text1 = pkt.func_148857_g().func_74779_i("t1");
        this.format = pkt.func_148857_g().func_74779_i("form");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("state", this.state);
        nbt.func_74774_a("dsp", this.dspType);
        nbt.func_74778_a("t0", this.text0);
        nbt.func_74778_a("t1", this.text1);
        nbt.func_74778_a("form", this.format);
        return new S35PacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ComputerAPI.update((TileEntity)this, (Object)this.node, (double)0.0);
        if (this.update) {
            byte lstate = this.state;
            this.state = 0;
            for (int i = 0; i < 6; ++i) {
                TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                if (te == null || !(te instanceof IRedstone8bit) || ((IRedstone8bit)te).getDirection(i ^ 1) <= 0) continue;
                this.state = (byte)(this.state | ((IRedstone8bit)te).getValue(i ^ 1));
            }
            if (this.state != lstate) {
                this.textUpdate = true;
                this.updateEvent();
            }
            this.update = false;
        }
        if (this.textUpdate) {
            this.markUpdate();
            this.textUpdate = false;
        }
    }

    public void onNeighborBlockChange(Block b) {
        this.update = true;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null) {
            ComputerAPI.saveNode((Object)this.node, (NBTTagCompound)nbt);
        }
        nbt.func_74774_a("state", this.state);
        nbt.func_74774_a("mode", this.dspType);
        nbt.func_74778_a("t0", this.text0);
        nbt.func_74778_a("t1", this.text1);
        nbt.func_74778_a("form", this.format);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null) {
            ComputerAPI.readNode((Object)this.node, (NBTTagCompound)nbt);
        }
        this.state = nbt.func_74771_c("state");
        this.dspType = nbt.func_74771_c("mode");
        this.text0 = nbt.func_74779_i("t0");
        this.text1 = nbt.func_74779_i("t1");
        this.format = nbt.func_74779_i("form");
        this.update = true;
    }

    public byte getValue(int s) {
        return this.state;
    }

    public byte getDirection(int s) {
        return -1;
    }

    public void setValue(int s, byte v, int recursion) {
        this.update = true;
    }

    private void updateEvent() {
        for (Object computer : this.listeners) {
            ComputerAPI.sendEvent((Object)computer, (String)"in8bit", (Object[])new Object[]{this.state});
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
        if (node.host() instanceof Context) {
            this.listeners.add(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            this.listeners.remove(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="", direct=true)
    public Object[] getInput(Context cont, Arguments args) {
        return new Object[]{this.state};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="", direct=true)
    public Object[] print(Context cont, Arguments args) {
        int tar = args.checkInteger(0);
        String text = args.checkString(1);
        if (tar == 0) {
            if (text.length() > 3) {
                throw new IllegalArgumentException("only max. 3 characters allowed for number format!");
            }
            this.format = text;
        } else if (tar == 1) {
            if (text.length() > 16) {
                throw new IllegalArgumentException("only max. 16 characters allowed for description!");
            }
            this.text0 = text;
        } else if (tar == 2) {
            if (text.length() > 16) {
                throw new IllegalArgumentException("only max. 16 characters allowed for description!");
            }
            this.text1 = text;
        } else {
            throw new IllegalArgumentException("invalid target index");
        }
        this.textUpdate = true;
        return new Object[0];
    }
}

