/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone1bit;
import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.api.computers.ComputerAPI;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileContainer;
import cd4017be.lib.TileEntityData;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers")})
public class Circuit
extends AutomatedTile
implements IRedstone8bit,
IRedstone1bit,
Environment {
    public final byte[] io = new byte[4];
    public final byte[] ram = new byte[16];
    public final byte[] obj = new byte[32];
    public byte[] code = new byte[0];
    public String name = "";
    public int var;
    private short timer = 0;
    private boolean update;
    private boolean updateCon;
    private boolean ticked = true;
    private Object node = ComputerAPI.newOCnode((TileEntity)this, (String)"RedstoneCircuits-Out8bit", (boolean)false);

    public Circuit() {
        this.netData = new TileEntityData(1, 1, 0, 0);
        this.netData.ints[0] = 1;
    }

    public String func_70005_c_() {
        return this.name.length() > 0 ? "\"" + this.name + "\"" : super.func_70005_c_();
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ComputerAPI.update((TileEntity)this, (Object)this.node, (double)0.0);
        if (this.updateCon) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            this.updateCon = false;
        }
        this.timer = (short)(this.timer + 1);
        if (this.getConfig(12) == 0) {
            this.timer = 0;
        }
        if (this.timer >= this.netData.ints[0]) {
            this.timer = 0;
            if (this.update) {
                this.io[1] = 0;
                this.io[0] = 0;
                for (int i = 0; i < 6; ++i) {
                    EnumFacing dir = EnumFacing.field_82609_l[i];
                    int c = this.getConfig(i + 6);
                    if (c >= 2) continue;
                    TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                    if (te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) > 0) {
                        int n = c;
                        this.io[n] = (byte)(this.io[n] | ((IRedstone8bit)te).getValue(i ^ 1) & this.getConfig(i));
                        continue;
                    }
                    if ((te == null || !(te instanceof IRedstone1bit) || ((IRedstone1bit)te).getBitDirection(i ^ 1) <= 0 || ((IRedstone1bit)te).getBitValue(i ^ 1) <= 0) && this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir) <= 0) continue;
                    int n = c;
                    this.io[n] = (byte)(this.io[n] | this.getConfig(i));
                }
                this.update = false;
            }
            byte l2 = this.io[2];
            byte l3 = this.io[3];
            this.cpuTick();
            if (this.io[2] != l2 || this.io[3] != l3) {
                for (int i = 0; i < 6; ++i) {
                    EnumFacing dir = EnumFacing.field_82609_l[i];
                    if (this.getDirection(i) <= 0) continue;
                    TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                    if (te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) < 0) {
                        ((IRedstone8bit)te).setValue(i ^ 1, this.getValue(i), 1);
                        continue;
                    }
                    if (te != null && te instanceof IRedstone1bit && ((IRedstone1bit)te).getBitDirection(i ^ 1) < 0) {
                        ((IRedstone1bit)te).setBitValue(i ^ 1, this.getBitValue(i), 1);
                        continue;
                    }
                    this.notifyStateChange(this.field_174879_c.func_177972_a(dir), dir.func_176734_d());
                }
            }
            this.ticked = true;
        }
    }

    private void cpuTick() {
        boolean x = false;
        byte n = 0;
        int i = 0;
        int j = 0;
        while (i < this.code.length) {
            int cmd = this.code[i] & 0xF0;
            int con = this.code[i] & 0xF;
            switch (cmd) {
                case 0: {
                    x = false;
                    while (i < j + con) {
                        x |= this.get(this.code[++i]);
                    }
                    break;
                }
                case 16: {
                    x = false;
                    while (i < j + con) {
                        x |= this.get(this.code[++i]);
                    }
                    x = !x;
                    break;
                }
                case 32: {
                    x = true;
                    while (i < j + con) {
                        x &= this.get(this.code[++i]);
                    }
                    break;
                }
                case 48: {
                    x = true;
                    while (i < j + con) {
                        x &= this.get(this.code[++i]);
                    }
                    x = !x;
                    break;
                }
                case 64: {
                    x = false;
                    while (i < j + con) {
                        x ^= this.get(this.code[++i]);
                    }
                    break;
                }
                case 80: {
                    x = true;
                    while (i < j + con) {
                        x ^= this.get(this.code[++i]);
                    }
                    break;
                }
                case 96: {
                    x = (this.io[con >> 3] & 1 << (con & 7)) != 0;
                    break;
                }
                case 112: {
                    x = this.ram[con] == this.code[++i];
                    break;
                }
                case -128: {
                    x = this.ram[con] < this.code[++i];
                    break;
                }
                case -112: {
                    x = this.ram[con] > this.code[++i];
                }
            }
            byte by = n;
            n = (byte)(n + 1);
            this.set(by, x);
            j = ++i;
        }
        for (i = 0; i < 8; ++i) {
            if (this.get(this.obj[i | 8])) {
                this.ram[i | 8] = 0;
                continue;
            }
            if (!this.get(this.obj[i])) continue;
            int n2 = i | 8;
            this.ram[n2] = (byte)(this.ram[n2] + 1);
        }
        this.io[3] = 0;
        this.io[2] = 0;
        for (i = 0; i < 16; ++i) {
            if (!this.get(this.obj[i | 0x10])) continue;
            int n3 = i >> 3 | 2;
            this.io[n3] = (byte)(this.io[n3] | 1 << (i & 7));
        }
    }

    private boolean get(byte i) {
        return i >= 0 && (this.ram[i >> 3] & 1 << (i & 7)) != 0;
    }

    private void set(byte i, boolean s) {
        if (s) {
            int n = i >> 3;
            this.ram[n] = (byte)(this.ram[n] | 1 << (i & 7));
        } else {
            int n = i >> 3;
            this.ram[n] = (byte)(this.ram[n] & ~(1 << (i & 7)));
        }
    }

    public int getConfig(int s) {
        int c;
        if (s < 6) {
            s *= 8;
            c = 255;
        } else {
            s = s * 2 + 36;
            c = 3;
        }
        return (int)(this.netData.longs[0] >> s) & c;
    }

    public void setConfig(int s, int v) {
        int c;
        if (s < 6) {
            s *= 8;
            c = 255;
        } else {
            s = s * 2 + 36;
            c = 3;
        }
        this.netData.longs[0] = this.netData.longs[0] & ((long)c << s ^ 0xFFFFFFFFFFFFFFFFL);
        this.netData.longs[0] = this.netData.longs[0] | (long)(v & c) << s;
    }

    protected void customPlayerCommand(byte cmd, PacketBuffer dis, EntityPlayerMP player) throws IOException {
        if (cmd == 2) {
            Arrays.fill(this.ram, (byte)0);
        } else if (cmd == 1) {
            this.netData.ints[0] = dis.readInt();
            if (this.netData.ints[0] < 1) {
                this.netData.ints[0] = 1;
            } else if (this.netData.ints[0] > 1200) {
                this.netData.ints[0] = 1200;
            }
        } else if (cmd == 0) {
            this.netData.longs[0] = dis.readLong();
            this.update = true;
            this.updateCon = true;
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null) {
            ComputerAPI.saveNode((Object)this.node, (NBTTagCompound)nbt);
        }
        nbt.func_74773_a("ram", this.ram);
        nbt.func_74773_a("io", this.io);
        nbt.func_74773_a("obj", this.obj);
        nbt.func_74773_a("code", this.code);
        nbt.func_74768_a("var", this.var);
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("tick", this.netData.ints[0]);
        nbt.func_74772_a("cfg", this.netData.longs[0]);
        nbt.func_74777_a("timer", this.timer);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null) {
            ComputerAPI.readNode((Object)this.node, (NBTTagCompound)nbt);
        }
        byte[] b = nbt.func_74770_j("ram");
        System.arraycopy(b, 0, this.ram, 0, Math.min(this.ram.length, b.length));
        b = nbt.func_74770_j("io");
        System.arraycopy(b, 0, this.io, 0, Math.min(this.io.length, b.length));
        b = nbt.func_74770_j("obj");
        System.arraycopy(b, 0, this.obj, 0, Math.min(this.obj.length, b.length));
        this.code = nbt.func_74770_j("code");
        this.var = nbt.func_74762_e("var");
        this.name = nbt.func_74779_i("name");
        this.timer = nbt.func_74765_d("timer");
        this.netData.ints[0] = nbt.func_74762_e("tick");
        this.netData.longs[0] = nbt.func_74763_f("cfg");
        this.ticked = true;
        this.update = true;
    }

    public ArrayList<ItemStack> dropItem(IBlockState m, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack item = new ItemStack(this.func_145838_q());
        item.func_77982_d(new NBTTagCompound());
        item.func_77978_p().func_74774_a("InOut", (byte)(this.var & 0xFF));
        item.func_77978_p().func_74774_a("Gates", (byte)(this.var >> 8 & 0xFF));
        item.func_77978_p().func_74774_a("Count", (byte)(this.var >> 16 & 0xFF));
        if (this.code.length > 0) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("name", this.name);
            nbt.func_74773_a("code", this.code);
            nbt.func_74773_a("cnt", Arrays.copyOfRange(this.obj, 0, 16));
            nbt.func_74773_a("out", Arrays.copyOfRange(this.obj, 16, 32));
            item.func_77978_p().func_74782_a("Progr", (NBTBase)nbt);
        }
        list.add(item);
        return list;
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (item.func_77978_p() != null) {
            this.var = 0;
            this.var |= item.func_77978_p().func_74771_c("InOut") & 0xFF;
            this.var |= item.func_77978_p().func_74771_c("Gates") << 8 & 0xFF00;
            this.var |= item.func_77978_p().func_74771_c("Count") << 16 & 0xFF0000;
            if (item.func_77978_p().func_74764_b("Progr")) {
                NBTTagCompound nbt = item.func_77978_p().func_74775_l("Progr");
                this.code = nbt.func_74770_j("code");
                byte[] b = nbt.func_74770_j("out");
                System.arraycopy(b, 0, this.obj, 16, Math.min(16, b.length));
                b = nbt.func_74770_j("cnt");
                System.arraycopy(b, 0, this.obj, 0, Math.min(16, b.length));
                for (int i = 0; i < 8; ++i) {
                    if (this.obj[i] < 0) continue;
                    this.var |= 1 << 24 + i;
                }
                this.name = nbt.func_74779_i("name");
            }
        }
    }

    public boolean detectAndSendChanges(TileContainer container, List<ICrafting> crafters, PacketBuffer dos) throws IOException {
        int i;
        if (!this.ticked) {
            dos.writeByte(0);
            return false;
        }
        this.ticked = false;
        int n = this.var >> 8 & 0xFF;
        dos.writeByte(n);
        for (i = 0; i < (n + 7) / 8; ++i) {
            dos.writeByte((int)this.ram[i]);
        }
        n = this.var >> 24 & 0xFF;
        dos.writeByte(n);
        for (i = 0; i < 8; ++i) {
            if ((n >> i & 1) == 0) continue;
            dos.writeByte((int)this.ram[i | 8]);
        }
        dos.func_180714_a(this.name);
        return true;
    }

    public void updateNetData(PacketBuffer dis, TileContainer container) throws IOException {
        int i;
        super.updateNetData(dis, container);
        int n = dis.readByte() & 0xFF;
        if (n == 0) {
            return;
        }
        this.var &= 0xFF00FF;
        this.var |= n << 8;
        for (i = 0; i < (n + 7) / 8; ++i) {
            this.ram[i] = dis.readByte();
        }
        n = dis.readByte() & 0xFF;
        this.var |= n << 24;
        for (i = 0; i < 8; ++i) {
            if ((n >> i & 1) == 0) continue;
            this.ram[i | 8] = dis.readByte();
        }
        this.name = dis.func_150789_c(32);
    }

    public byte getValue(int s) {
        int c = this.getConfig(s + 6);
        if (c >= 2) {
            return (byte)(this.io[c] & this.getConfig(s));
        }
        return 0;
    }

    public byte getDirection(int s) {
        return (byte)((this.netData.longs[0] & 255L << s * 8) == 0L ? 0 : ((this.netData.longs[0] & 2L << s * 2 + 48) == 0L ? -1 : 1));
    }

    public void setValue(int s, byte v, int recursion) {
        this.update = true;
    }

    public byte getBitDirection(int s) {
        return this.getDirection(s);
    }

    public byte getBitValue(int s) {
        return this.getValue(s) != 0 ? (byte)15 : 0;
    }

    public void setBitValue(int s, byte v, int recursion) {
        this.update = true;
    }

    private void notifyStateChange(BlockPos pos, EnumFacing except) {
        this.field_145850_b.func_180496_d(pos, this.func_145838_q());
        this.field_145850_b.func_175695_a(pos, this.func_145838_q(), except);
    }

    public int redstoneLevel(int s, boolean str) {
        return this.getBitValue(s);
    }

    public void onNeighborBlockChange(Block b) {
        this.update = true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(pos:int):int returns the 8 logic gate states at given byte position", direct=true)
    public Object[] getByte(Context cont, Arguments args) {
        int id = args.checkInteger(0);
        if (id >= 0 && id < this.ram.length) {
            return new Object[]{(int)this.ram[id]};
        }
        throw new IndexOutOfBoundsException();
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(pos:int, val:int[, mask:int]) sets the 8 logic gate states at given byte position. Use mask to only set specific bits", direct=true)
    public Object[] setByte(Context cont, Arguments args) {
        int id = args.checkInteger(0);
        int f = args.optInteger(2, 255);
        int n = args.checkInteger(1) & f;
        if (id >= 0 && id < this.ram.length) {
            int n2 = id;
            this.ram[n2] = (byte)(this.ram[n2] & ~f);
            int n3 = id;
            this.ram[n3] = (byte)(this.ram[n3] | n);
            return new Object[0];
        }
        throw new IndexOutOfBoundsException();
    }
}

