/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.render;

import cd4017be.circuits.tileEntity.Display8bit;
import cd4017be.circuits.tileEntity.Lever8bit;
import cd4017be.lib.ModTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RSInterfaceRenderer
extends TileEntitySpecialRenderer<ModTileEntity> {
    private final RenderManager manager = Minecraft.func_71410_x().func_175598_ae();

    private void renderStateBinary(byte state, int tex, int h) {
        this.manager.field_78724_e.func_110577_a(new ResourceLocation("circuits", "textures/blocks/displayOvl.png"));
        WorldRenderer t = Tessellator.func_178181_a().func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < 8; ++i) {
            this.renderFace(t, tex | state >> i & 1, 4 * (i % 4), h * (i / 4) + 8 - h, 4.0f, 8.0f);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void renderState(char[] format, int state, boolean hex) {
        byte[] digits = hex ? new byte[]{(byte)(state & 0xF), (byte)(state >> 4), 0} : new byte[]{(byte)(state % 10), (byte)(state / 10 % 10), (byte)(state / 100)};
        this.manager.field_78724_e.func_110577_a(new ResourceLocation("circuits", "textures/blocks/displayOvl.png"));
        WorldRenderer t = Tessellator.func_178181_a().func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int n = 0;
        float dx = 20.0f / (float)(format.length + 1);
        float x = 16.0f;
        for (int i = format.length - 1; i >= 0; --i) {
            char c = format[i];
            int d = c == '#' ? digits[n++] + 8 : (c >= '0' && c <= '9' ? c - 48 + 8 : (c >= 'a' && c <= 'f' ? c - 97 + 18 : (c >= 'A' && c <= 'F' ? c - 65 + 18 : (c == ':' ? 24 : (c == '.' ? 25 : (c == '-' ? 26 : (c == '%' ? 27 : 28)))))));
            this.renderFace(t, d, x -= dx, 4.0f, 4.0f, 8.0f);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void renderText(String s, float y) {
        FontRenderer fr = this.manager.func_78716_a();
        float w = fr.func_78256_a(s);
        float scale = Math.min(0.375f, 14.0f / w);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(8.0f - w * 0.5f * scale), (float)(y + 1.5f - 4.0f * scale), (float)-0.25f);
        GL11.glScalef((float)scale, (float)scale, (float)0.0f);
        fr.func_78276_b(s, 0, 0, 0xFFFF00);
        GL11.glPopMatrix();
    }

    private void renderFace(WorldRenderer t, int idx, float x, float y, float w, float h) {
        float tw = 0.125f;
        float th = 0.25f;
        float tx = (float)(idx % 8) * tw;
        float ty = (float)(idx / 8) * th;
        t.func_181662_b((double)x, (double)(y + h), -0.25).func_181673_a((double)tx, (double)(ty + th)).func_181675_d();
        t.func_181662_b((double)(x + w), (double)(y + h), -0.25).func_181673_a((double)(tx + tw), (double)(ty + th)).func_181675_d();
        t.func_181662_b((double)(x + w), (double)y, -0.25).func_181673_a((double)(tx + tw), (double)ty).func_181675_d();
        t.func_181662_b((double)x, (double)y, -0.25).func_181673_a((double)tx, (double)ty).func_181675_d();
    }

    public void renderTileEntityAt(ModTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        int s = te.func_145832_p();
        float a = s == 4 ? 0.0f : (s == 5 ? 180.0f : (s == 6 ? 90.0f : -90.0f));
        GL11.glRotatef((float)a, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)-0.0625f, (float)-0.0625f, (float)0.0625f);
        GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)-8.0f);
        if (te instanceof Lever8bit) {
            this.renderStateBinary(((Lever8bit)te).state, 0, 8);
        } else if (te instanceof Display8bit) {
            Display8bit dsp = (Display8bit)te;
            if (dsp.dspType == 0) {
                this.renderStateBinary(dsp.state, 2, 4);
            } else if (dsp.dspType == 1) {
                this.renderState(dsp.format.toCharArray(), dsp.state & 0xFF, true);
            } else {
                this.renderState(dsp.format.toCharArray(), dsp.state & 0xFF, false);
            }
            if (!dsp.text0.isEmpty()) {
                this.renderText(dsp.text0, 1.0f);
            }
            if (!dsp.text1.isEmpty()) {
                this.renderText(dsp.text1, 12.0f);
            }
        }
        GL11.glPopMatrix();
    }
}

