/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone1bit;
import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.TileEntityData;
import cd4017be.lib.templates.AutomatedTile;
import cd4017be.lib.util.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneInterface
extends AutomatedTile
implements IRedstone8bit,
IRedstone1bit {
    private byte state;
    private boolean update;

    public RedstoneInterface() {
        this.netData = new TileEntityData(0, 1, 0, 0);
    }

    public String func_145825_b() {
        return "8-bit-Port Redstone Adapter";
    }

    protected void customPlayerCommand(byte cmd, DataInputStream dis, EntityPlayerMP player) throws IOException {
        if (cmd == 0) {
            this.netData.ints[0] = dis.readInt();
            this.update = true;
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("cfg", this.netData.ints[0]);
        nbt.func_74774_a("state", this.state);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.netData.ints[0] = nbt.func_74762_e("cfg");
        this.state = nbt.func_74771_c("state");
        this.update = true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update) {
            this.update(0);
        }
    }

    private void update(int recursion) {
        TileEntity te;
        byte d8;
        byte d1;
        ForgeDirection dir;
        int i;
        byte lstate = this.state;
        this.state = 0;
        for (i = 0; i < 6; ++i) {
            dir = ForgeDirection.getOrientation((int)i);
            d1 = this.getBitDirection(i);
            d8 = this.getDirection(i);
            if (d1 > -1 && d8 > -1) continue;
            te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
            if (d8 < 0 && te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) > 0) {
                this.state = (byte)(this.state | ((IRedstone8bit)te).getValue(i ^ 1));
                continue;
            }
            if (d1 >= 0 || (te == null || !(te instanceof IRedstone1bit) || ((IRedstone1bit)te).getBitDirection(i ^ 1) <= 0 || !((IRedstone1bit)te).getBitValue(i ^ 1)) && !this.field_145850_b.func_94574_k(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, i)) continue;
            this.state = (byte)(this.state | 1 << (this.getConfig(i) & 0xF) - 2);
        }
        if (this.state != lstate) {
            ++recursion;
            for (i = 0; i < 6; ++i) {
                dir = ForgeDirection.getOrientation((int)i);
                d1 = this.getBitDirection(i);
                d8 = this.getDirection(i);
                if (d1 < 1 && d8 < 1) continue;
                te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                if (d8 > 0 && te != null && te instanceof IRedstone8bit && ((IRedstone8bit)te).getDirection(i ^ 1) < 0) {
                    ((IRedstone8bit)te).setValue(i ^ 1, this.state, recursion);
                    continue;
                }
                if (d1 <= 0) continue;
                if (te != null && te instanceof IRedstone1bit && ((IRedstone1bit)te).getBitDirection(i ^ 1) < 0) {
                    ((IRedstone1bit)te).setBitValue(i ^ 1, (this.state >> (this.getConfig(i) & 0xF) - 2 & 1) != 0, recursion);
                    continue;
                }
                this.notifyStateChange(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            }
        }
        this.update = false;
    }

    private void notifyStateChange(int x, int y, int z) {
        this.field_145850_b.func_147460_e(x, y, z, this.func_145838_q());
        this.field_145850_b.func_147459_d(x, y, z, this.func_145838_q());
    }

    public int redstoneLevel(int s, boolean str) {
        int c = this.getConfig(s);
        if ((c & 0xF) >= 2 && c >= 16) {
            return (this.state & 1 << (c & 0xF) - 2) != 0 ? 15 : 0;
        }
        return 0;
    }

    public void onNeighborBlockChange(Block b) {
        this.update = true;
    }

    public byte getValue(int s) {
        return this.state;
    }

    public byte getDirection(int s) {
        int c = this.getConfig(s);
        if ((c & 0xF) == 1) {
            return (c & 0x10) != 0 ? (byte)1 : -1;
        }
        return 0;
    }

    public void setValue(int s, byte v, int recursion) {
        if (recursion < 16) {
            this.update(recursion);
        } else {
            this.update = true;
        }
    }

    public byte getBitDirection(int s) {
        int c = this.getConfig(s);
        if ((c & 0xF) >= 2) {
            return (c & 0x10) != 0 ? (byte)1 : -1;
        }
        return 0;
    }

    public boolean getBitValue(int s) {
        int c = this.getConfig(s) & 0xF;
        if (c >= 2) {
            return (this.state & 1 << c - 2) != 0;
        }
        return false;
    }

    public void setBitValue(int s, boolean v, int recursion) {
        if (recursion < 16) {
            this.update(recursion);
        } else {
            this.update = true;
        }
    }

    public int getConfig(int s) {
        return this.netData.ints[0] >> s * 5 & 0x1F;
    }

    public void setConfig(int s, int v) {
        this.netData.ints[0] = this.netData.ints[0] & ~(31 << s * 5);
        this.netData.ints[0] = this.netData.ints[0] | (v & 0x1F) << s * 5;
    }
}

