/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone1bit;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.templates.IPipe;
import cd4017be.lib.util.Utils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RSPipe1
extends ModTileEntity
implements IRedstone1bit,
IPipe {
    private boolean state;
    private boolean update = false;
    private short flow;
    private boolean updateCon = true;
    private IPipe.Cover cover = null;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateCon) {
            this.updateConnections();
        }
        if (this.getFlowBit(6) && this.update) {
            this.transferSignal(0);
        }
    }

    private void updateConnections() {
        byte type = (byte)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean lHasOut = this.getFlowBit(6);
        boolean lHasIn = this.getFlowBit(14);
        boolean nHasOut = false;
        boolean nHasIn = false;
        ArrayList<RSPipe1> updateList = new ArrayList<RSPipe1>();
        short lFlow = this.flow;
        for (int i = 0; i < 6; ++i) {
            boolean lDirOut = this.getFlowBit(i);
            boolean lDirIn = this.getFlowBit(i | 8);
            if (lDirOut && lDirIn) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te != null && te instanceof RSPipe1) {
                boolean nDirIn;
                RSPipe1 pipe = (RSPipe1)te;
                boolean pHasOut = pipe.getFlowBit(6);
                boolean pHasIn = pipe.getFlowBit(14);
                boolean pDirOut = pipe.getFlowBit(i ^ 1);
                boolean pDirIn = pipe.getFlowBit(i ^ 1 | 8);
                boolean nDirOut = pHasOut && !pDirOut;
                boolean bl = nDirIn = pHasIn && !pDirIn;
                if (pDirOut && pDirIn) {
                    nDirOut = true;
                    nDirIn = true;
                } else if (nDirOut && nDirIn) {
                    boolean s = lHasIn ^ lHasOut;
                    nDirOut = s && lHasIn && !lDirIn;
                    nDirIn = s && lHasOut && !lDirOut;
                }
                this.setFlowBit(i, nDirOut);
                this.setFlowBit(i | 8, nDirIn);
                nHasIn |= nDirIn && !nDirOut;
                nHasOut |= nDirOut && !nDirIn;
                updateList.add(pipe);
                continue;
            }
            if (te != null && te instanceof IRedstone1bit) {
                byte d = ((IRedstone1bit)te).getBitDirection(i ^ 1);
                if (d == 0) {
                    this.setFlowBit(i, false);
                    this.setFlowBit(i | 8, false);
                    continue;
                }
                if (d > 0) {
                    this.setFlowBit(i, false);
                    this.setFlowBit(i | 8, true);
                    nHasIn = true;
                    continue;
                }
                if (d >= 0) continue;
                this.setFlowBit(i, true);
                this.setFlowBit(i | 8, false);
                nHasOut = true;
                continue;
            }
            if (type != 0 && !this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ).func_149688_o().func_76222_j()) {
                this.setFlowBit(i, type == 1);
                this.setFlowBit(i | 8, type == 2);
                nHasOut |= type == 1;
                nHasIn |= type == 2;
                continue;
            }
            this.setFlowBit(i, false);
            this.setFlowBit(i | 8, false);
        }
        this.setFlowBit(6, nHasOut);
        this.setFlowBit(14, nHasIn);
        if (this.flow != lFlow) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            for (RSPipe1 pipe : updateList) {
                pipe.onNeighborBlockChange(Blocks.field_150350_a);
            }
            this.update = true;
        }
        this.updateCon = false;
    }

    private void transferSignal(int recursion) {
        ForgeDirection fd;
        int i;
        IRedstone1bit[] rst = new IRedstone1bit[6];
        byte[] dir = new byte[6];
        int n = 0;
        boolean lstate = this.state;
        this.state = false;
        for (i = 0; i < 6; ++i) {
            boolean rs;
            boolean dirOut = this.getFlowBit(i);
            boolean dirIn = this.getFlowBit(i | 8);
            if (!dirIn ^ dirOut) continue;
            TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
            boolean bl = rs = te != null && te instanceof IRedstone1bit;
            if (dirIn) {
                if (rs) {
                    this.state |= ((IRedstone1bit)te).getBitValue(i ^ 1);
                    continue;
                }
                fd = ForgeDirection.getOrientation((int)i);
                this.state |= this.field_145850_b.func_94574_k(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ, i);
                continue;
            }
            if (!dirOut) continue;
            rst[n] = rs ? (IRedstone1bit)te : null;
            dir[n++] = (byte)(i ^ 1);
        }
        if (this.state != lstate) {
            ++recursion;
            for (i = 0; i < n; ++i) {
                if (rst[i] != null) {
                    rst[i].setBitValue((int)dir[i], this.state, recursion);
                    continue;
                }
                fd = ForgeDirection.getOrientation((int)dir[i]).getOpposite();
                this.notifyStateChange(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
            }
        }
        this.update = false;
    }

    private void notifyStateChange(int x, int y, int z) {
        this.field_145850_b.func_147460_e(x, y, z, this.func_145838_q());
        this.field_145850_b.func_147459_d(x, y, z, this.func_145838_q());
    }

    public void onNeighborBlockChange(Block b) {
        this.updateCon = true;
        if (b != this.func_145838_q()) {
            this.update = true;
        }
    }

    public boolean onActivated(EntityPlayer player, int s, float X, float Y, float Z) {
        ItemStack item = player.func_71045_bC();
        if (player.func_70093_af() && item == null) {
            float dz;
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            if (this.cover != null) {
                player.func_70062_b(0, this.cover.item);
                this.cover = null;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
            float dx = Math.abs(X -= 0.5f);
            float dy = Math.abs(Y);
            s = dy > (dz = Math.abs(Z)) && dy > dx ? ((Y -= 0.5f) < 0.0f ? 0 : 1) : (dz > dx ? ((Z -= 0.5f) < 0.0f ? 2 : 3) : (X < 0.0f ? 4 : 5));
            boolean lock = !this.getFlowBit(s) || !this.getFlowBit(s | 8);
            this.setFlowBit(s, lock);
            this.setFlowBit(s | 8, lock);
            this.onNeighborBlockChange(Blocks.field_150350_a);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)s));
            if (te != null && te instanceof RSPipe1) {
                RSPipe1 pipe = (RSPipe1)te;
                pipe.setFlowBit(s ^ 1, lock);
                pipe.setFlowBit(s ^ 1 | 8, lock);
                pipe.onNeighborBlockChange(Blocks.field_150350_a);
                this.field_145850_b.func_147471_g(pipe.field_145851_c, pipe.field_145848_d, pipe.field_145849_e);
            }
            return true;
        }
        if (!player.func_70093_af() && this.cover == null && item != null && (this.cover = IPipe.Cover.create((ItemStack)item)) != null) {
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            --item.field_77994_a;
            if (item.field_77994_a <= 0) {
                item = null;
            }
            player.func_70062_b(0, item);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean getFlowBit(int b) {
        return (this.flow & 1 << b) != 0;
    }

    private void setFlowBit(int b, boolean v) {
        this.flow = v ? (short)(this.flow | 1 << b) : (short)(this.flow & ~(1 << b));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("flow", this.flow);
        nbt.func_74757_a("state", this.state);
        if (this.cover != null) {
            this.cover.write(nbt, "cover");
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.flow = nbt.func_74765_d("flow");
        this.state = nbt.func_74767_n("state");
        this.cover = IPipe.Cover.read((NBTTagCompound)nbt, (String)"cover");
        this.updateCon = true;
        this.update = true;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.flow = pkt.func_148857_g().func_74765_d("flow");
        this.cover = IPipe.Cover.read((NBTTagCompound)pkt.func_148857_g(), (String)"cover");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("flow", this.flow);
        if (this.cover != null) {
            this.cover.write(nbt, "cover");
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, nbt);
    }

    public void breakBlock() {
        super.breakBlock();
        if (this.cover != null) {
            EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.cover.item);
            this.cover = null;
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    public int textureForSide(byte s) {
        boolean b1;
        TileEntity p = Utils.getTileOnSide((ModTileEntity)this, (byte)s);
        boolean b0 = this.getFlowBit(s);
        if (b0 ^ (b1 = this.getFlowBit(s | 8)) || !b0 && !b1 && p != null && p instanceof IRedstone1bit) {
            return (b0 ? 1 : 0) | (b1 ? 2 : 0);
        }
        return -1;
    }

    public boolean getBitValue(int s) {
        return this.state;
    }

    public byte getBitDirection(int s) {
        boolean b2;
        boolean b1 = this.getFlowBit(s);
        return (byte)(b1 ^ (b2 = this.getFlowBit(s | 8)) ? (b1 ? 1 : -1) : 0);
    }

    public void setBitValue(int s, boolean v, int recursion) {
        if (recursion > 16) {
            this.update = true;
        } else {
            this.transferSignal(recursion);
        }
    }

    public int redstoneLevel(int s, boolean str) {
        if (this.state && this.getFlowBit(s) && !this.getFlowBit(s | 8) && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            return 15;
        }
        return 0;
    }

    public IPipe.Cover getCover() {
        return this.cover;
    }
}

