/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.circuits.tileEntity;

import cd4017be.api.circuits.IRedstone8bit;
import cd4017be.api.computers.ComputerAPI;
import cd4017be.lib.ModTileEntity;
import cd4017be.lib.util.Utils;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers")})
public class Lever8bit
extends ModTileEntity
implements IRedstone8bit,
IPeripheral,
Environment {
    private boolean update;
    public byte state;
    private ArrayList<Object> listeners = new ArrayList();
    private Object node = ComputerAPI.newOCnode((TileEntity)this, (String)"RedstoneCircuits-Out8bit", (boolean)false);

    public boolean onActivated(EntityPlayer player, int s, float X, float Y, float Z) {
        if (!player.func_70093_af() && s == this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            int i;
            int n = i = Y < 0.5f ? 4 : 0;
            if (s == 3) {
                i |= (int)Math.floor(X * 4.0f);
            } else if (s == 2) {
                i |= (int)Math.floor((1.0f - X) * 4.0f);
            } else if (s == 5) {
                i |= (int)Math.floor((1.0f - Z) * 4.0f);
            } else if (s == 4) {
                i |= (int)Math.floor(Z * 4.0f);
            }
            this.state = (byte)(this.state ^ 1 << i);
            this.update = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.state = pkt.func_148857_g().func_74771_c("state");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("state", this.state);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, nbt);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update) {
            for (int i = 0; i < 6; ++i) {
                TileEntity te = Utils.getTileOnSide((ModTileEntity)this, (byte)((byte)i));
                if (te == null || !(te instanceof IRedstone8bit) || ((IRedstone8bit)te).getDirection(i ^ 1) >= 0) continue;
                ((IRedstone8bit)te).setValue(i ^ 1, this.state, 1);
            }
            this.updateEvent();
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("state", this.state);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = nbt.func_74771_c("state");
        this.update = true;
    }

    public byte getValue(int s) {
        return this.state;
    }

    public byte getDirection(int s) {
        return 1;
    }

    public void setValue(int s, byte v, int recursion) {
    }

    private void updateEvent() {
        for (Object computer : this.listeners) {
            ComputerAPI.sendEvent((Object)computer, (String)"out8bit", (Object[])new Object[]{this.state});
        }
    }

    public String getType() {
        return "RedstoneCircuits-Out8bit";
    }

    public String[] getMethodNames() {
        return new String[]{"getOutput", "setOutput"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext lua, int cmd, Object[] par) throws LuaException {
        if (cmd == 0) {
            return new Object[]{(double)this.state};
        }
        if (cmd == 1) {
            if (par.length != 1 || !(par[0] instanceof Double)) {
                throw new LuaException("missing parameter [setOutput(Number state)]");
            }
            this.state = ((Double)par[0]).byteValue();
            this.update = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return null;
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        this.listeners.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.listeners.remove(computer);
    }

    public boolean equals(IPeripheral peripheral) {
        return ((Object)((Object)this)).hashCode() == peripheral.hashCode();
    }

    public void func_145843_s() {
        super.func_145843_s();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
        if (node.host() instanceof Context) {
            this.listeners.add(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            this.listeners.remove(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="", direct=true)
    public Object[] getOutput(Context cont, Arguments args) {
        return new Object[]{this.state};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="", direct=true)
    public Object[] setOutput(Context cont, Arguments args) {
        this.state = (byte)args.checkInteger(0);
        this.update = true;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return new Object[0];
    }
}

